/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.RMCPPlus;
import com.supermicro.ipmi.SessionInfo;

public class IPMIPayloadCommand
extends IPMICommand {
    public IPMIPayloadCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public IPMIMessage activatePayloadCommand(byte payloadType, byte payloadInstance, byte[] parameter) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6];
        data[0] = payloadType;
        data[1] = payloadInstance;
        System.arraycopy(parameter, 0, data, 2, 4);
        ipmiMessage.setCommandAndData((byte)24, (byte)72, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage deactivatePayloadCommand(byte payloadType, byte payloadInstance, byte[] parameter) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6];
        data[0] = payloadType;
        data[1] = payloadInstance;
        System.arraycopy(parameter, 0, data, 2, 4);
        ipmiMessage.setCommandAndData((byte)24, (byte)73, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setUserPayloadAccessCommand(byte channel, byte operationAndUserID, byte standardPayloadEnable1, byte standardPayloadEnable2, byte OEMPayloadEnable1, byte OEMPayloadEnable2) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{channel, operationAndUserID, standardPayloadEnable1, standardPayloadEnable2, OEMPayloadEnable1, OEMPayloadEnable2};
        ipmiMessage.setCommandAndData((byte)24, (byte)76, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getUserPayloadAccessCommand(byte channel, byte userID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{channel, userID};
        ipmiMessage.setCommandAndData((byte)24, (byte)77, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public boolean activateSOLPayload(boolean encryption) {
        IPMIMessage resMessage;
        byte[] parameter = new byte[]{0, 0, 0, 0};
        if (encryption) {
            parameter[0] = -64;
        }
        if ((resMessage = this.activatePayloadCommand((byte)1, (byte)1, parameter)) != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            switch (resMessage.completionCode) {
                case -128: {
                    MessageCenter.getInstance().put(this, (Object)"Payload already active on another session (required).This will be returned any time an attempt is made to activate a payloadtype when that type is already activated for another session, and whenthe BMC only supports one instance of that payload type running at a time.");
                    break;
                }
                case -127: {
                    MessageCenter.getInstance().put(this, (Object)"Payload type is disabled (optional). Given payload type is not configured to be enabled for activation.");
                    break;
                }
                case -126: {
                    MessageCenter.getInstance().put(this, (Object)"Payload activation limit reached. Cannot activate given payload type because the maximum number of simultaneous instances of that payload type are already running.");
                    break;
                }
                case -125: {
                    MessageCenter.getInstance().put(this, (Object)"Cannot activate payload with encryption.");
                    break;
                }
                case -124: {
                    MessageCenter.getInstance().put(this, (Object)"Cannot activate payload without encryption. BMC requires encryption for all payloads for given privilege level.");
                    break;
                }
                default: {
                    MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
                }
            }
        }
        return false;
    }

    public boolean deactivateSOLPayload() {
        byte[] parameter = new byte[]{0, 0, 0, 0};
        IPMIMessage resMessage = this.deactivatePayloadCommand((byte)1, (byte)1, parameter);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            switch (resMessage.completionCode) {
                case -128: {
                    MessageCenter.getInstance().put(this, (Object)"Payload already deactivated.");
                    break;
                }
                case -127: {
                    MessageCenter.getInstance().put(this, (Object)"Payload type is disabled (optional). Given payload type is notconfigured to be enabled for activation.");
                    break;
                }
                default: {
                    MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
                }
            }
        }
        return false;
    }

    public boolean setEnableUserPayloadForSOL(byte userID, boolean enable) {
        byte byte2 = (byte)(userID | (enable ? 0 : 64));
        IPMIMessage resMessage = this.setUserPayloadAccessCommand((byte)1, byte2, (byte)2, (byte)0, (byte)0, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        return false;
    }

    public boolean setUserPayloadForSOL(byte userID) {
        return this.setEnableUserPayloadForSOL(userID, true);
    }

    public boolean isSOLEnabled(byte userID) {
        IPMIMessage resMessage = this.getUserPayloadAccessCommand((byte)1, userID);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return (resMessage.data[0] & 2) == 2;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Get User access");
        return false;
    }

    public static void main_org(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.1.193");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIPayloadCommand ipmiPayloadCommand = new IPMIPayloadCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiPayloadCommand.setIPMIInterface(rmcp);
        boolean result = ipmiPayloadCommand.activateSOLPayload(true);
        MessageCenter.getInstance().put("activate payload result : " + result);
        if (result && (result = ipmiPayloadCommand.deactivateSOLPayload())) {
            MessageCenter.getInstance().put("sol payload has been deactivated");
        }
        sessionController.closeSession();
    }

    public static void main_(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.1.193");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIPayloadCommand ipmiPayloadCommand = new IPMIPayloadCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiPayloadCommand.setIPMIInterface(rmcp);
        for (byte i = 1; i < 10; i = (byte)(i + 1)) {
            IPMIMessage ipmiMessage = ipmiPayloadCommand.getUserPayloadAccessCommand((byte)1, i);
            System.out.println("user id =" + i + " : " + ByteUtility.bytesToHex(ipmiMessage.data));
        }
        sessionController.closeSession();
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.12.157");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIPayloadCommand ipmiPayloadCommand = new IPMIPayloadCommand(null);
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiPayloadCommand.setIPMIInterface(rmcp);
        ipmiMessagingCommand.setIPMIInterface(rmcp);
        SessionInfo sessionInfo = ipmiMessagingCommand.getCurrentlySessionInfo(((RMCPPlus)rmcp).rmcpPlusSession.sessionID);
        boolean isSOLEnabled = ipmiPayloadCommand.isSOLEnabled(sessionInfo.getUserID());
        System.out.println("isSOLEnabled =" + isSOLEnabled);
        sessionController.closeSession();
    }
}

