/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIMessage;

public class IPMIOEMRoTCommand
extends IPMICommand {
    public IPMIOEMRoTCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public IPMIMessage getPFRStatusCommand(byte component) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{38, component};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setPFRActionCommand(byte component, byte action) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{39, component, action};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private IPMIMessage getProvisionStatusCommand() {
        return this.runProvisionCommand((byte)0);
    }

    private IPMIMessage setProvisionStartCommand() {
        return this.runProvisionCommand((byte)1);
    }

    private IPMIMessage getProvisionStateCommand() {
        return this.runProvisionCommand((byte)2);
    }

    private IPMIMessage getCPLDVersionCommand() {
        return this.runProvisionCommand((byte)3);
    }

    private IPMIMessage getCPLDKeySignedStatusCommand() {
        return this.runProvisionCommand((byte)10);
    }

    private IPMIMessage setBMCBackupCopyCommand() {
        return this.runFlashCommand((byte)32, (byte)0);
    }

    private IPMIMessage setBMCGoldenCopyCommand() {
        return this.runFlashCommand((byte)32, (byte)1);
    }

    private IPMIMessage setBIOSBackupCopyCommand() {
        return this.runFlashCommand((byte)32, (byte)2);
    }

    private IPMIMessage setBIOSGoldenCopyCommand() {
        return this.runFlashCommand((byte)32, (byte)3);
    }

    private IPMIMessage setBMCBackupEraseCommand() {
        return this.runFlashCommand((byte)33, (byte)0);
    }

    private IPMIMessage setBIOSBackupEraseCommand() {
        return this.runFlashCommand((byte)33, (byte)2);
    }

    private IPMIMessage setBMCStagingEraseCommand() {
        return this.runFlashCommand((byte)33, (byte)4);
    }

    private IPMIMessage setBIOSStagingEraseCommand() {
        return this.runFlashCommand((byte)33, (byte)5);
    }

    private IPMIMessage runProvisionCommand(byte action) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{40, action};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private IPMIMessage runFlashCommand(byte type, byte action) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{40, type, action};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private IPMIMessage runBIOSForceUpdateCommandMethod1(boolean isEnableForceUpdate) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-57, 1, isEnableForceUpdate ? (byte)1 : 0};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private IPMIMessage runBIOSForceUpdateCommandMethod2(boolean isEnableForceUpdate) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{51, isEnableForceUpdate ? (byte)1 : 0};
        ipmiMessage.setCommandAndData((byte)-64, (byte)-96, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public void API() {
    }

    public boolean setPFRAction(byte component, byte action) throws IPMIException {
        IPMIMessage resMessage = this.setPFRActionCommand(component, action);
        if (resMessage != null) {
            return resMessage.completionCode == 0;
        }
        throw new IPMIException("Call getMultiNodeStatusCommand failed");
    }

    public String getPFRStatus(byte component) throws IPMIException {
        IPMIMessage resMessage = this.getPFRStatusCommand(component);
        if (resMessage != null && resMessage.completionCode == 0) {
            String status;
            switch (resMessage.data[0]) {
                case 0: {
                    status = "Unknown";
                    break;
                }
                case 16: {
                    status = "Offline with normal image";
                    break;
                }
                case 17: {
                    status = "Offline with recovery image";
                    break;
                }
                case 32: {
                    status = "Boot up with normal image";
                    break;
                }
                case 33: {
                    status = "Boot up with recovery image";
                    break;
                }
                case 48: {
                    status = "Image verification failed";
                    break;
                }
                case 65: {
                    status = "Recovering with recovery image";
                    break;
                }
                case 80: {
                    status = "Boot successfully with normal image";
                    break;
                }
                case 81: {
                    status = "Boot successfully with recovery image";
                    break;
                }
                case 96: {
                    status = "Normal flashing";
                    break;
                }
                case 97: {
                    status = "Manual flashing with recovery image";
                    break;
                }
                default: {
                    status = "Unkown status";
                }
            }
            return status;
        }
        throw new IPMIException("Call getMultiNodeStatusCommand failed");
    }

    public int getProvisionStatus() {
        IPMIMessage resMessage = this.getProvisionStatusCommand();
        if (resMessage != null && resMessage.completionCode == 0) {
            return resMessage.data[0];
        }
        return -1;
    }

    public int getProvisionState() {
        IPMIMessage resMessage = this.getProvisionStateCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            return resMessage.completionCode;
        }
        return -1;
    }

    public boolean setProvisionStart() {
        IPMIMessage resMessage = this.setProvisionStartCommand();
        if (resMessage != null) {
            return resMessage.completionCode == 0;
        }
        return false;
    }

    public byte[] getCPLDVersion() {
        IPMIMessage resMessage = this.getCPLDVersionCommand();
        if (resMessage != null && resMessage.completionCode == 0) {
            return resMessage.data;
        }
        return null;
    }

    public boolean setBIOSForceUpdate(boolean isEnableForceUpdate) {
        boolean result = true;
        IPMIMessage resMessage = null;
        resMessage = this.runBIOSForceUpdateCommandMethod1(isEnableForceUpdate);
        if (!(resMessage != null && resMessage.completionCode == 0 || (resMessage = this.runBIOSForceUpdateCommandMethod2(isEnableForceUpdate)) != null && resMessage.completionCode == 0)) {
            result = false;
        }
        return result;
    }

    public int getCPLDKeyStatus() {
        IPMIMessage resMessage = this.getCPLDKeySignedStatusCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            return resMessage.completionCode;
        }
        return -1;
    }

    public boolean copyBMCBackupImage() {
        IPMIMessage resMessage = this.setBMCBackupCopyCommand();
        if (resMessage != null) {
            return resMessage.completionCode == 0;
        }
        return false;
    }

    public boolean copyBMCGoldenImage() {
        IPMIMessage resMessage = this.setBMCGoldenCopyCommand();
        if (resMessage != null) {
            return resMessage.completionCode == 0;
        }
        return false;
    }

    public boolean copyBIOSBackupImage() {
        IPMIMessage resMessage = this.setBIOSBackupCopyCommand();
        if (resMessage != null) {
            return resMessage.completionCode == 0;
        }
        return false;
    }

    public boolean copyBIOSGoldenImage() {
        IPMIMessage resMessage = this.setBIOSGoldenCopyCommand();
        if (resMessage != null) {
            return resMessage.completionCode == 0;
        }
        return false;
    }

    public boolean eraseBMCBackupImage() {
        IPMIMessage resMessage = this.setBMCBackupEraseCommand();
        if (resMessage != null) {
            return resMessage.completionCode == 0;
        }
        return false;
    }

    public boolean eraseBIOSBackupImage() {
        IPMIMessage resMessage = this.setBIOSBackupEraseCommand();
        if (resMessage != null) {
            return resMessage.completionCode == 0;
        }
        return false;
    }

    public boolean eraseBMCStagingImage() {
        IPMIMessage resMessage = this.setBMCStagingEraseCommand();
        if (resMessage != null) {
            return resMessage.completionCode == 0;
        }
        return false;
    }

    public boolean eraseBIOSStagingImage() {
        IPMIMessage resMessage = this.setBIOSStagingEraseCommand();
        if (resMessage != null) {
            return resMessage.completionCode == 0;
        }
        return false;
    }
}

