/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.HDDStatus;
import com.supermicro.ipmi.HDDStatusLogical;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;

public class IPMIHDDOEMCommand
extends IPMICommand {
    public static final int HDD_MAP_RAW_LENGTH = 80;
    public static int HDD_LOGICAL_MAP_RAW_LENGTH = 8;
    public static byte devId = 0;

    public IPMIHDDOEMCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public void CMD_______________________() {
    }

    public IPMIMessage getHDDExistAndErrBitMapCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{76};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getHDDExistAndErrBitMapCommand(int devID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{76, (byte)devID};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getHDDInfoStructureCommand(byte index, byte devId) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{77, index, devId};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getAllHDDInfoStructureCommand(byte[] offset, byte[] size) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{78, offset[0], offset[1], size[0], size[1]};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getLogicalHDDTargetIdExistBitMapCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{81};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getLogicalHDDInfoStructureCommand(byte index) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{82, index};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getLogicalAllHDDInfoStructureCommand(byte[] offset, byte[] size) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{83, offset[0], offset[1], size[0], size[1]};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setSensorPollingFlagCommand(byte enable) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-33, enable};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getVDInfoStructureByIndexCommand(byte index) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-88, index};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public void API_______________________() {
    }

    public byte[] getHDDExistAndErrBitMap() throws IPMIException {
        IPMIMessage resMessage = this.getHDDExistAndErrBitMapCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getHDDExistAndErrBitMap failed");
    }

    public byte[] getHDDExistAndErrBitMap(int devID) throws IPMIException {
        IPMIMessage resMessage = this.getHDDExistAndErrBitMapCommand(devID);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getHDDExistAndErrBitMap failed");
    }

    public void setSensorPollingFlag(boolean isEnable) throws IPMIException {
        byte enable = isEnable ? (byte)1 : 0;
        IPMIMessage resMessage = this.setSensorPollingFlagCommand(enable);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getHDDExistAndErrBitMap failed");
    }

    public byte[] getLogicalHDDTargetIdExistBitMap() throws IPMIException {
        IPMIMessage resMessage = this.getLogicalHDDTargetIdExistBitMapCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getLogicalHDDTargetIdExistBitMapCommand failed");
    }

    public HDDStatusLogical getLogicalHDDInfoStructure(byte index) throws IPMIException {
        IPMIMessage resMessage = this.getLogicalHDDInfoStructureCommand(index);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                HDDStatusLogical hddStatusLogical = new HDDStatusLogical();
                if (hddStatusLogical.fromRaw(resMessage.data)) {
                    return hddStatusLogical;
                }
                return null;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getHDDInfoStructureCommand failed");
    }

    public HDDStatusLogical getLogicalHDDInfoStructureNew(byte index) throws IPMIException {
        IPMIMessage resMessage = this.getVDInfoStructureByIndexCommand(index);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                HDDStatusLogical hddStatusLogical = new HDDStatusLogical();
                if (hddStatusLogical.fromRaw(resMessage.data)) {
                    return hddStatusLogical;
                }
                return null;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getHDDInfoStructureCommand failed");
    }

    public String drawExistAndErriBitMap() throws IPMIException {
        byte[] map = this.getHDDExistAndErrBitMap();
        HDDMap hddMap = new HDDMap();
        hddMap.fromRaw(map);
        return hddMap.drawAllMap();
    }

    public String drawLogicalHDDTargetIdExistBitMap() throws IPMIException {
        byte[] map = this.getLogicalHDDTargetIdExistBitMap();
        HDDLogicalMap hddLogicalMap = new HDDLogicalMap();
        hddLogicalMap.fromRaw(map);
        return hddLogicalMap.drawAllMap();
    }

    public HDDMap getHDDMap() throws IPMIException {
        byte[] map = this.getHDDExistAndErrBitMap();
        if (map.length != 80) {
            return null;
        }
        HDDMap hddMap = new HDDMap();
        hddMap.fromRaw(map);
        return hddMap;
    }

    public HDDMap getHDDMap(int devID) throws IPMIException {
        byte[] map = this.getHDDExistAndErrBitMap(devID);
        if (map.length != 80) {
            return null;
        }
        boolean isHddMap120 = false;
        try {
            this.getHDDInfoStructure((byte)121);
        }
        catch (IPMIException e) {
            isHddMap120 = true;
        }
        HDDMap hddMap = new HDDMap();
        hddMap.fromRaw(map);
        return hddMap;
    }

    public HDDLogicalMap getLogicalHDDMap() throws IPMIException {
        byte[] map = this.getLogicalHDDTargetIdExistBitMap();
        if (map.length != 8 && map.length != 32) {
            return null;
        }
        HDD_LOGICAL_MAP_RAW_LENGTH = map.length;
        HDDLogicalMap hddLogicalMap = new HDDLogicalMap();
        hddLogicalMap.fromRaw(map);
        return hddLogicalMap;
    }

    public HDDStatus getHDDInfoStructure(byte index) throws IPMIException {
        IPMIMessage resMessage = this.getHDDInfoStructureCommand(index, devId);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                HDDStatus hddStatus = new HDDStatus();
                if (hddStatus.fromRaw(resMessage.data)) {
                    return hddStatus;
                }
                return null;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getHDDExistAndErrBitMap failed");
    }

    public HDDStatus getHDDInfoStructure(byte index, byte devId) throws IPMIException {
        IPMIMessage resMessage = this.getHDDInfoStructureCommand(index, devId);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                HDDStatus hddStatus = new HDDStatus();
                if (hddStatus.fromRaw(resMessage.data)) {
                    return hddStatus;
                }
                return null;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getHDDExistAndErrBitMap failed");
    }

    public HDDStatus getAllHDDInfoStructure(byte index1, byte index2) throws IPMIException {
        return null;
    }

    public void ENTITY____________________() {
    }

    public void MAIN______________________() {
    }

    public static void main(String[] args) {
        IPMIHDDOEMCommand.main_status(args);
        IPMIHDDOEMCommand.main_logical_status(args);
    }

    public static void main_testDrawMap(String[] args) {
    }

    public static void main_status(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("172.31.42.109");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        IPMIHDDOEMCommand ipmiHDDOEMCommand = new IPMIHDDOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilege(config, ipmiHDDOEMCommand);
        if (ipmiHDDOEMCommand.getIPMIInterface() == null) {
            System.out.println("ip or password error");
            return;
        }
        try {
            String mapStr = ipmiHDDOEMCommand.drawExistAndErriBitMap();
            System.out.println(mapStr);
            byte[] map = ipmiHDDOEMCommand.getHDDExistAndErrBitMap();
            System.out.println("map =" + ByteUtility.bytesToHex(map));
            for (int i = 0; i < 100; ++i) {
                HDDStatus hddStatus = ipmiHDDOEMCommand.getHDDInfoStructure((byte)i, devId);
                if (hddStatus == null) continue;
                System.out.println("i = " + i);
                System.out.println(hddStatus.toString());
            }
        }
        catch (IPMIException iPMIException) {
            // empty catch block
        }
        sessionController.closeSession();
    }

    public static void main_logical_status(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("172.31.9.122");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        IPMIHDDOEMCommand ipmiHDDOEMCommand = new IPMIHDDOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilege(config, ipmiHDDOEMCommand);
        if (ipmiHDDOEMCommand.getIPMIInterface() == null) {
            System.out.println("ip or password error");
            return;
        }
        try {
            String mapStr = ipmiHDDOEMCommand.drawLogicalHDDTargetIdExistBitMap();
            System.out.println(mapStr);
            byte[] map = ipmiHDDOEMCommand.getLogicalHDDTargetIdExistBitMap();
            System.out.println("map =" + ByteUtility.bytesToHex(map));
            for (int i = 0; i < 5; ++i) {
                HDDStatusLogical hddStatusLogical = ipmiHDDOEMCommand.getLogicalHDDInfoStructure((byte)i);
                if (hddStatusLogical == null) continue;
                System.out.println("i = " + i);
                System.out.println(hddStatusLogical.toString());
            }
        }
        catch (IPMIException iPMIException) {
            // empty catch block
        }
        sessionController.closeSession();
    }

    public class HDDLogicalMap {
        byte[][] hddExistMap;

        public void fromRaw(byte[] raw) {
            if (raw.length != HDD_LOGICAL_MAP_RAW_LENGTH) {
                return;
            }
            if (HDD_LOGICAL_MAP_RAW_LENGTH == 32) {
                this.hddExistMap = new byte[16][2];
                int count = 0;
                for (int i = 0; i < 16; ++i) {
                    for (int j = 0; j < 2; ++j) {
                        this.hddExistMap[i][j] = raw[count];
                        ++count;
                    }
                }
            } else {
                this.hddExistMap = new byte[4][2];
                int count = 0;
                for (int i = 0; i < 4; ++i) {
                    for (int j = 0; j < 2; ++j) {
                        this.hddExistMap[i][j] = raw[count];
                        ++count;
                    }
                }
            }
        }

        public String toString() {
            return null;
        }

        public String drawAllMap() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.hddExistMap.length; ++i) {
                String map = this.drawMap(this.hddExistMap[i], i);
                stringBuffer.append(map + "\n");
            }
            stringBuffer.append("O: Present\n");
            stringBuffer.append("-: Not Present");
            return stringBuffer.toString();
        }

        public String drawMap(byte[] existMap, int index) {
            StringBuffer formatedString = new StringBuffer();
            String num = " %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s\n";
            String sep = "---------------------------------------------------------------\n";
            String map = " %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s";
            if (HDD_LOGICAL_MAP_RAW_LENGTH == 32) {
                num = " %3s  %3s  %3s  %3s  %3s  %3s  %3s  %3s  %3s  %3s  %3s  %3s  %3s  %3s  %3s  %3s\n";
                sep = "--------------------------------------------------------------------------------\n";
                map = " %3s  %3s  %3s  %3s  %3s  %3s  %3s  %3s  %3s  %3s  %3s  %3s  %3s  %3s  %3s  %3s";
            }
            formatedString.append(String.format(num, index * 16 + 0, index * 16 + 1, index * 16 + 2, index * 16 + 3, index * 16 + 4, index * 16 + 5, index * 16 + 6, index * 16 + 7, index * 16 + 8, index * 16 + 9, index * 16 + 10, index * 16 + 11, index * 16 + 12, index * 16 + 13, index * 16 + 14, index * 16 + 15));
            formatedString.append(sep);
            formatedString.append(String.format(map, this.c(existMap, 0), this.c(existMap, 1), this.c(existMap, 2), this.c(existMap, 3), this.c(existMap, 4), this.c(existMap, 5), this.c(existMap, 6), this.c(existMap, 7), this.c(existMap, 8), this.c(existMap, 9), this.c(existMap, 10), this.c(existMap, 11), this.c(existMap, 12), this.c(existMap, 13), this.c(existMap, 14), this.c(existMap, 15)));
            return formatedString.toString();
        }

        public String c(byte[] existMap, int index) {
            int existInt = ByteUtility.twoBytesToIntLSB(existMap);
            int existflag = existInt & 1 << index;
            if (existflag > 0) {
                return "O";
            }
            return "-";
        }

        public boolean isExist(int index) {
            if (index < 0 || index > 64) {
                return false;
            }
            int i = index / 16;
            int j = index % 16;
            int existLong = ByteUtility.twoBytesToIntLSB(this.hddExistMap[i]);
            int existflag = existLong & 1 << j;
            return existflag > 0;
        }
    }

    public class HDDMap {
        byte[][] hddExistMap;
        byte[][] hddErrorMap;
        boolean isHddMapReturnLength120 = true;
        int maxEnclosureSize;

        public void fromRaw(byte[] raw) {
            int j;
            int i;
            if (raw.length != 80) {
                return;
            }
            this.maxEnclosureSize = !this.isHddMapReturnLength120 ? 10 : 5;
            this.hddExistMap = new byte[this.maxEnclosureSize][4];
            this.hddErrorMap = new byte[this.maxEnclosureSize][4];
            int count = 0;
            for (i = 0; i < this.maxEnclosureSize; ++i) {
                for (j = 0; j < 4; ++j) {
                    this.hddExistMap[i][j] = raw[count];
                    ++count;
                }
            }
            if (this.isHddMapReturnLength120) {
                count += 20;
            }
            for (i = 0; i < this.maxEnclosureSize; ++i) {
                for (j = 0; j < 4; ++j) {
                    this.hddErrorMap[i][j] = raw[count];
                    ++count;
                }
            }
        }

        public boolean isHddMapReturnLength120() {
            return this.isHddMapReturnLength120;
        }

        public void setHddMapReturnLength120(boolean isHddMap120) {
            this.isHddMapReturnLength120 = isHddMap120;
        }

        public String toString() {
            return null;
        }

        public String drawAllMap() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.hddExistMap.length; ++i) {
                if (this.hddExistMap[i][0] == 0 && this.hddExistMap[i][1] == 0 && this.hddExistMap[i][2] == 0) continue;
                String map = this.drawMap(this.hddExistMap[i], this.hddErrorMap[i]);
                stringBuffer.append("\nDevice: Enclosure Set: " + (i + 1) + "\n");
                stringBuffer.append(map + "\n");
            }
            stringBuffer.append("\n");
            stringBuffer.append("X: Error\n");
            stringBuffer.append("O: Present\n");
            stringBuffer.append("-: Not Present");
            return stringBuffer.toString();
        }

        public String drawAllMap(int devID) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.hddExistMap.length; ++i) {
                if (this.hddExistMap[i][0] == 0 && this.hddExistMap[i][1] == 0 && this.hddExistMap[i][2] == 0) continue;
                String map = this.drawMap(this.hddExistMap[i], this.hddErrorMap[i]);
                stringBuffer.append("\nDevice: " + devID + ", Enclosure Set: " + (i + 1) + "\n");
                stringBuffer.append(map);
            }
            return stringBuffer.toString();
        }

        public String drawMap(byte[] existMap, byte[] errorMap) {
            StringBuffer formatedString = new StringBuffer();
            String num = "0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1\n";
            String sep = "---------------------------------------------------------------\n";
            String map = "%s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s";
            formatedString.append(num);
            formatedString.append(sep);
            formatedString.append(String.format(map, this.c(existMap, errorMap, 0), this.c(existMap, errorMap, 1), this.c(existMap, errorMap, 2), this.c(existMap, errorMap, 3), this.c(existMap, errorMap, 4), this.c(existMap, errorMap, 5), this.c(existMap, errorMap, 6), this.c(existMap, errorMap, 7), this.c(existMap, errorMap, 8), this.c(existMap, errorMap, 9), this.c(existMap, errorMap, 10), this.c(existMap, errorMap, 11), this.c(existMap, errorMap, 12), this.c(existMap, errorMap, 13), this.c(existMap, errorMap, 14), this.c(existMap, errorMap, 15), this.c(existMap, errorMap, 16), this.c(existMap, errorMap, 17), this.c(existMap, errorMap, 18), this.c(existMap, errorMap, 19), this.c(existMap, errorMap, 20), this.c(existMap, errorMap, 21), this.c(existMap, errorMap, 22), this.c(existMap, errorMap, 23), this.c(existMap, errorMap, 24), this.c(existMap, errorMap, 25), this.c(existMap, errorMap, 26), this.c(existMap, errorMap, 27), this.c(existMap, errorMap, 28), this.c(existMap, errorMap, 29), this.c(existMap, errorMap, 30), this.c(existMap, errorMap, 31), this.c(existMap, errorMap, 32)));
            return formatedString.toString();
        }

        public String c(byte[] existMap, byte[] errorMap, int index) {
            long existLong = ByteUtility.fourBytesToIntByLSBFirst(existMap);
            long errorLong = ByteUtility.fourBytesToIntByLSBFirst(errorMap);
            long existflag = existLong & (long)(1 << index);
            long errorflag = errorLong & (long)(1 << index);
            if (existflag > 0L) {
                if (errorflag > 0L) {
                    return "X";
                }
                return "O";
            }
            return "-";
        }

        public boolean isExist(int index) {
            if (index < 0 || index > 120) {
                return false;
            }
            int i = index / 32;
            int j = index % 32;
            long existLong = ByteUtility.fourBytesToIntByLSBFirst(this.hddExistMap[i]);
            long existflag = existLong & (long)(1 << j);
            return existflag > 0L;
        }

        public boolean isError(int index) {
            if (index < 0 || index > 120) {
                return false;
            }
            int i = index / 32;
            int j = index % 32;
            long errorLong = ByteUtility.fourBytesToIntByLSBFirst(this.hddErrorMap[i]);
            long errorflag = errorLong & (long)(1 << j);
            return errorflag > 0L;
        }
    }
}

