/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ACPIInfo;
import com.supermicro.ipmi.DeviceInfo;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.SelfTestResultInfo;

public class IPMIGlobalCommand
extends IPMICommand {
    public IPMIGlobalCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public IPMIMessage getDeviceIDCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)24, (byte)1, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public void dropGetDeviceIDCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)24, (byte)1, data);
        this.ipmiInterface.drop(ipmiMessage);
    }

    public IPMIMessage coldResetCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)24, (byte)2, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSelfTestResultsCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)24, (byte)4, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getACPIPowerStateCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)24, (byte)7, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public DeviceInfo getDevice() {
        IPMIMessage resMessage = this.getDeviceIDCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return DeviceInfo.fromRaw(resMessage.data);
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Get Device ID");
        return null;
    }

    public boolean coldReset() {
        IPMIMessage resMessage = this.coldResetCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Cold reset command");
        return false;
    }

    public SelfTestResultInfo getSelfTestResult() {
        IPMIMessage resMessage = this.getSelfTestResultsCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return SelfTestResultInfo.fromRaw(resMessage.data);
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get self test results command");
        return null;
    }

    public ACPIInfo getACPI() {
        IPMIMessage resMessage = this.getACPIPowerStateCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return ACPIInfo.fromRaw(resMessage.data);
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get ACPI Power state command");
        return null;
    }

    public boolean isPeppercon() {
        DeviceInfo deviceInfo = this.getDevice();
        return deviceInfo.manufacturerID != null && deviceInfo.manufacturerID[0] == -59 && deviceInfo.manufacturerID[1] == 40 && deviceInfo.manufacturerID[2] == 0;
    }

    public boolean isOSA() {
        DeviceInfo deviceInfo = this.getDevice();
        return deviceInfo.manufacturerID != null && deviceInfo.manufacturerID[0] == -39 && deviceInfo.manufacturerID[1] == 21 && deviceInfo.manufacturerID[2] == 0;
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.10.242");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setRetry(1);
        config.setTimeout(2);
        config.setCipherSuiteID((byte)3);
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        if (sessionController == null) {
            System.out.println("divice didn't exist");
            return;
        }
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiGlobalCommand.setIPMIInterface(rmcp);
        DeviceInfo deviceInfo = ipmiGlobalCommand.getDevice();
        System.out.println(deviceInfo.toString());
        SelfTestResultInfo selfTestResultInfo = ipmiGlobalCommand.getSelfTestResult();
        if (selfTestResultInfo != null) {
            System.out.println("self tset result =" + selfTestResultInfo.getResultInfo());
            System.out.println("self tset result desc =" + selfTestResultInfo.getDescriptionInfo());
        }
        ACPIInfo acpiInfo = ipmiGlobalCommand.getACPI();
        System.out.println("System state info = " + acpiInfo.getSystemStateInfo());
        System.out.println("System state desc = " + acpiInfo.getSystemStateDescription());
        System.out.println("Device state info = " + acpiInfo.getDeviceStateInfo());
        System.out.println("Device state desc = " + acpiInfo.getDeviceStateDescription());
        System.out.println("is peppercon = " + ipmiGlobalCommand.isPeppercon());
        System.out.println("is OSA       = " + ipmiGlobalCommand.isOSA());
        sessionController.closeSession();
    }
}

