/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.communication;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.communication.SSLWrapper;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public abstract class Client {
    public static final int RETRY_COUNT = 3;
    public static final int TIMEOUT = 1;
    protected SocketChannel m_sockCh = null;
    protected SocketChannel m_HIDsockCh = null;
    protected byte[] m_ipAddr;
    protected int m_port;
    protected int m_HIDport;
    protected SSLWrapper ssl_wrapper;
    protected SSLWrapper HIDssl_wrapper;

    public Client(byte[] ipAddr, int port, int hid_port) {
        this.m_ipAddr = ipAddr;
        this.m_port = port;
        this.m_HIDport = hid_port;
        this.ssl_wrapper = null;
        this.HIDssl_wrapper = null;
    }

    public SocketChannel getSockChannel() {
        return this.m_sockCh;
    }

    public SocketChannel getHIDSockChannel() {
        return this.m_HIDsockCh;
    }

    public int connect() throws IOException {
        this.m_sockCh = SocketChannel.open();
        this.m_sockCh.connect(new InetSocketAddress(InetAddress.getByAddress(this.m_ipAddr), this.m_port));
        this.m_sockCh.configureBlocking(false);
        int retry = 3;
        while (!this.m_sockCh.finishConnect()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (retry-- > 0) continue;
            return -1;
        }
        this.m_sockCh.socket().setTcpNoDelay(true);
        this.m_sockCh.socket().setKeepAlive(true);
        return 0;
    }

    public int HIDconnect() throws IOException {
        this.m_HIDsockCh = SocketChannel.open();
        this.m_HIDsockCh.connect(new InetSocketAddress(InetAddress.getByAddress(this.m_ipAddr), this.m_HIDport));
        this.m_HIDsockCh.configureBlocking(false);
        int retry = 3;
        while (!this.m_HIDsockCh.finishConnect()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (retry-- > 0) continue;
            return -1;
        }
        this.m_HIDsockCh.socket().setTcpNoDelay(true);
        this.m_HIDsockCh.socket().setKeepAlive(true);
        return 0;
    }

    public int sendMessage(byte[] msg, int len) {
        int numWr = 0;
        ByteBuffer bbMsg = ByteBuffer.wrap(msg);
        try {
            if (this.ssl_wrapper != null) {
                this.ssl_wrapper.write(bbMsg);
            } else {
                numWr = this.m_sockCh.write(bbMsg);
            }
        }
        catch (IOException e) {
            Debug.out.println("Send message failed");
        }
        return len;
    }

    public int sendHIDMessage(byte[] msg, int len) {
        int numWr = 0;
        ByteBuffer bbMsg = ByteBuffer.wrap(msg);
        try {
            if (this.HIDssl_wrapper != null) {
                this.HIDssl_wrapper.write(bbMsg);
            } else {
                numWr = this.m_HIDsockCh.write(bbMsg);
            }
        }
        catch (IOException e) {
            Debug.out.println("Send message failed");
        }
        return len;
    }

    public void close() {
        try {
            if (this.m_sockCh != null) {
                this.m_sockCh.close();
            }
            if (this.m_HIDsockCh != null) {
                this.m_HIDsockCh.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public abstract void onReadEvent();

    public abstract void onHIDReadEvent();

    public abstract boolean IsVideoDataAvailable();

    public abstract boolean IsHIDDataAvailable();
}

