/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishActAPI;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.RedfishTokenCommand;
import java.util.ArrayList;

public class LDAPAddSearchBaseCommand
extends RedfishTokenCommand {
    @Override
    public boolean preValidate() {
        if (this.parameters == null || this.parameters.length != 1) {
            this.printUsage();
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isBeforeX12(guid) && !IPMIMessagingCommand.isB3ST1GUID(guid)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        RedfishActAPI api = new RedfishActAPI(this.config);
        if (!api.checkIfDCMSSingleExist()) {
            MOut.G(this).println("Login failed. DCMS-single may need to be activated for this device.");
            MOut.G(this).println("Or user credentials may be wrong.");
            this.statusCode = 155;
            return;
        }
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/AccountService/";
        int result = this.sessionLoginClient.send_https_get(url);
        if (result >= 200 && result <= 210) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(this.sessionLoginClient.getResponseString());
            JsonNode LDAP = node.path("LDAP");
            JsonNode ServiceEnabled = LDAP.path("ServiceEnabled");
            JsonNode LDAPService = LDAP.path("LDAPService");
            JsonNode SearchSettings = LDAPService.path("SearchSettings");
            JsonNode Base = SearchSettings.path("BaseDistinguishedNames");
            boolean isEnable = ServiceEnabled.asBoolean();
            if (isEnable) {
                ArrayList<String> list = new ArrayList<String>();
                if (Base.isArray()) {
                    if (Base.size() == 3) {
                        MOut.G(this).println("List can only support up to 3 search bases");
                        this.statusCode = 149;
                        return;
                    }
                    for (int i = 0; i < Base.size(); ++i) {
                        list.add(Base.get(i).asText());
                    }
                }
                list.add(this.parameters[0]);
                String body = "{\"LDAP\": {\"LDAPService\":{\"SearchSettings\":{\"BaseDistinguishedNames\":[";
                for (int i = 0; i < list.size(); ++i) {
                    body = body + "\"" + (String)list.get(i) + "\",";
                    if (i != list.size() - 1) continue;
                    body = body.substring(0, body.length() - 2);
                }
                result = this.sessionLoginClient.send_https_patch(url, body = body + "\"]}}}}");
                if (result >= 200 && result <= 210) {
                    MOut.G(this).println("Done");
                } else {
                    this.printFailMessage(result, this.sessionLoginClient.getResponseString());
                    MOut.G(this).println("Failed");
                    this.statusCode = 149;
                }
            } else {
                MOut.G(this).println("LDAP Service is disabled");
            }
            this.statusCode = 0;
        } else {
            MOut.G(this).println("Fail to read LDAP information. ErrorCode:" + result);
            this.statusCode = 149;
        }
    }

    public void printUsage() {
        MOut.G(this).println("Usage: redfish accountService ldap addSearchBase <Search Base>");
    }
}

