/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.BasicAuthClient;
import com.supermicro.redfish.RedfishCommand;
import com.supermicro.redfish.RedfishHttpUtils;

public class AccountLockoutSettingCommand
extends RedfishCommand {
    int threshold = 3;
    int duration = 2;
    int counter = 2;

    @Override
    public boolean preValidate() {
        if (this.parameters != null && this.parameters.length != 3) {
            this.printUsage();
            return false;
        }
        if (this.parameters != null && this.parameters.length == 3) {
            try {
                this.threshold = Integer.parseInt(this.parameters[0]);
                this.counter = Integer.parseInt(this.parameters[1]);
                this.duration = Integer.parseInt(this.parameters[2]);
            }
            catch (NumberFormatException e) {
                this.printUsage();
                return false;
            }
            if (this.threshold < 0 || this.threshold > 5) {
                MOut.G(this).println("Threshold must be 0,1,2,3,4,5");
                return false;
            }
            if (this.duration < 0 || this.duration > 6) {
                MOut.G(this).println("Duration must be 0,1,2,3,4,5,6");
                return false;
            }
            if (this.counter < 0 || this.counter > 6) {
                MOut.G(this).println("Duration must be 0,1,2,3,4,5,6");
                return false;
            }
            if (this.counter > this.duration) {
                MOut.G(this).println("Failed Login Counter Reset value can not be greater than Account Lockout Duration");
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isBeforeX12(guid)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/AccountService/";
        BasicAuthClient bc = new BasicAuthClient(this.config);
        if (this.parameters == null) {
            int result = bc.send_https_get(url);
            if (result >= 200 && result <= 210) {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode node = mapper.readTree(bc.getResponseString());
                JsonNode AccountLockoutThreshold = node.path("AccountLockoutThreshold");
                JsonNode AccountLockoutDuration = node.path("AccountLockoutDuration");
                JsonNode AccountLockoutCounterResetAfter = node.path("AccountLockoutCounterResetAfter");
                this.threshold = AccountLockoutThreshold.asInt();
                this.duration = AccountLockoutDuration.asInt();
                this.counter = AccountLockoutCounterResetAfter.asInt();
                MOut.G(this).println("Failed Login Attemp Lockout Threshold: " + this.threshold);
                MOut.G(this).println("Failed Login Counter Reset           : " + (this.counter == 0 ? "Never" : this.counter + "s"));
                MOut.G(this).println("Account Lockout Duration             : " + (this.duration == 0 ? "Never" : this.duration + "s"));
                MOut.G(this).println("");
                this.printUsage();
                this.statusCode = 0;
            } else {
                this.statusCode = 149;
            }
        } else {
            String body = "{\"AccountLockoutThreshold\": " + this.threshold + ",\r\n\"AccountLockoutDuration\": " + this.counterTransfer(this.duration) + ",\r\n\"AccountLockoutCounterResetAfter\": " + this.counterTransfer(this.counter) + "}";
            int result = bc.send_https_patch(url, body);
            if (result >= 200 && result <= 210) {
                MOut.G(this).println("Done");
                this.statusCode = 0;
            } else {
                this.printFailMessage(result, bc.getResponseString());
                this.statusCode = 149;
            }
        }
    }

    public void printUsage() {
        MOut.G(this).println("Usage: redfish accountService lockoutSetting [<threshold> <resetCounter> <duration>]");
        MOut.G(this).println("       Allowable Threshold: 0,1,2,3,4,5");
        MOut.G(this).println("       Duration and resetCounter index");
        MOut.G(this).println("       0: Never");
        MOut.G(this).println("       1: 10s");
        MOut.G(this).println("       2: 30s");
        MOut.G(this).println("       3: 1m");
        MOut.G(this).println("       4: 5m");
        MOut.G(this).println("       5: 10m");
        MOut.G(this).println("       6: 30m");
    }

    public String counterTransfer(int index) {
        String s = null;
        switch (index) {
            case 0: {
                s = "0";
                break;
            }
            case 1: {
                s = "10";
                break;
            }
            case 2: {
                s = "30";
                break;
            }
            case 3: {
                s = "60";
                break;
            }
            case 4: {
                s = "300";
                break;
            }
            case 5: {
                s = "600";
                break;
            }
            case 6: {
                s = "1800";
            }
        }
        return s;
    }
}

