/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.BasicAuthClient;
import com.supermicro.redfish.RedfishActAPI;
import com.supermicro.redfish.RedfishCommand;
import com.supermicro.redfish.RedfishHttpUtils;

public class ADStatusCommand
extends RedfishCommand {
    boolean state;

    @Override
    public boolean preValidate() {
        if (this.parameters != null) {
            try {
                int status = Integer.parseInt(this.parameters[0]);
                if (status != 1 && status != 0) {
                    this.printUsage();
                    return false;
                }
                this.state = status != 0;
            }
            catch (Exception e) {
                this.printUsage();
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isBeforeX12(guid)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        RedfishActAPI api = new RedfishActAPI(this.config);
        if (!api.checkIfDCMSSingleExist()) {
            MOut.G(this).println("Login failed. DCMS-single may need to be activated for this device.");
            MOut.G(this).println("Or user credentials may be wrong.");
            this.statusCode = 155;
            return;
        }
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/AccountService/";
        BasicAuthClient bc = new BasicAuthClient(this.config);
        if (this.parameters == null) {
            int result = bc.send_https_get(url);
            if (result >= 200 && result <= 210) {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode node = mapper.readTree(bc.getResponseString());
                JsonNode ActiveDirectory = node.path("ActiveDirectory");
                JsonNode ServiceEnabled = ActiveDirectory.path("ServiceEnabled");
                boolean isEnable = ServiceEnabled.asBoolean();
                if (isEnable) {
                    MOut.G(this).println("ActiveDirectory enabled");
                } else {
                    MOut.G(this).println("ActiveDirectory disabled");
                }
                MOut.G(this).println("");
                this.printUsage();
                this.statusCode = 0;
            } else {
                MOut.G(this).println("Fail to read Active Directory information. ErrorCode:" + result);
                this.statusCode = 149;
            }
        } else {
            String body = "{\"ActiveDirectory\": {\"ServiceEnabled\":" + this.state + "}}";
            int result = bc.send_https_patch(url, body);
            if (result >= 200 && result <= 210) {
                MOut.G(this).println("Done");
                this.statusCode = 0;
            } else {
                this.printFailMessage(result, bc.getResponseString());
                this.statusCode = 149;
            }
        }
    }

    public void printUsage() {
        MOut.G(this).println("Usage: redfish accountService ad status [enabled]");
        MOut.G(this).println("       enable : 1");
        MOut.G(this).println("       disable :0");
    }
}

