/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.trap.privacy;

import com.supermicro.ipmi.trap.privacy.PrivacyGeneric;
import com.supermicro.ipmi.trap.traps.SNMPv3Trap;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PrivAES128
extends PrivacyGeneric {
    public static final String CIPHER_INSTANCE = "AES/CFB/NoPadding";
    public static final String PROTOCOL_CLASS = "AES";
    public static final int KEY_BYTES = 16;

    @Override
    public byte[] decrypt(SNMPv3Trap trap, byte[] decryptionKey) {
        byte[] initVect = new byte[16];
        long boots = trap.getMsgAuthoritativeEngineBoots();
        long times = trap.getMsgAuthoritativeEngineTime();
        initVect[0] = (byte)(boots >> 24 & 0xFFL);
        initVect[1] = (byte)(boots >> 16 & 0xFFL);
        initVect[2] = (byte)(boots >> 8 & 0xFFL);
        initVect[3] = (byte)(boots & 0xFFL);
        initVect[4] = (byte)(times >> 24 & 0xFFL);
        initVect[5] = (byte)(times >> 16 & 0xFFL);
        initVect[6] = (byte)(times >> 8 & 0xFFL);
        initVect[7] = (byte)(times & 0xFFL);
        System.arraycopy(trap.getMsgPrivacyParameters(), 0, initVect, 8, 8);
        return this.doDecrypt(trap.getMsgWholeMsg(), trap.getEncryptedPDUOffset(), trap.getEncryptedPDULength(), decryptionKey, initVect);
    }

    private byte[] doDecrypt(byte[] cryptedData, int offset, int length, byte[] decryptionKey, byte[] iv) {
        byte[] decryptedData = null;
        try {
            Cipher alg = this.reuseCipher(CIPHER_INSTANCE);
            SecretKeySpec key = new SecretKeySpec(decryptionKey, 0, 16, PROTOCOL_CLASS);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            alg.init(2, (Key)key, ivSpec);
            decryptedData = alg.doFinal(cryptedData, offset, length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return decryptedData;
    }
}

