/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text.pmbusStatus;

import com.supermicro.ipmi.IPMII2CPMBusCommand;
import com.supermicro.ipmi.text.pmbusStatus.Status;
import com.supermicro.ipmi.text.pmbusStatus.StatusFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class StatusManager {
    public IPMII2CPMBusCommand.PMBusHealth pmBusHealth;
    public Map<String, Status> statusInsts;
    private Map<String, Map<Integer, String>> allMsgMap = new TreeMap<String, Map<Integer, String>>();

    public StatusManager() {
    }

    public StatusManager(IPMII2CPMBusCommand.PMBusHealth pmBusHealth) {
        this.pmBusHealth = pmBusHealth;
    }

    public void setStatusInsts(Map<String, Status> statusInsts) {
        this.statusInsts = statusInsts;
    }

    public Map<String, Map<Integer, String>> getStatusDescription(boolean isSimple) {
        if (isSimple) {
            return this.getSimpleStatusDescription();
        }
        return this.getAllStatusDescription();
    }

    public Map<String, Map<Integer, String>> getAllStatusDescription() {
        int i;
        Status statusByteInst = this.statusInsts.get("Status Byte");
        Status statusWordInst = this.statusInsts.get("Status Word");
        if (statusByteInst.statusByte == 0 && statusWordInst.statusByte == 0) {
            return null;
        }
        if (statusByteInst.statusByte != 0) {
            Map<Integer, String> statusByteMsg = statusByteInst.getStatusDescription();
            if (statusByteMsg != null && statusByteMsg.size() > 0) {
                this.allMsgMap.put(statusByteInst.getStatusMsgTittle(), statusByteMsg);
            }
            int[] statusByteBinArr = statusByteInst.toStatusBinArr(statusByteInst.statusByte);
            for (i = 0; i < statusByteBinArr.length; ++i) {
                if (statusByteBinArr[i] != 1) continue;
                this.setStatusByteDetailDesc(i, false);
            }
        }
        if (statusWordInst.statusByte != 0) {
            Map<Integer, String> statusWordMsg = statusWordInst.getStatusDescription();
            if (statusWordMsg != null && statusWordMsg.size() > 0) {
                this.allMsgMap.put(statusWordInst.getStatusMsgTittle(), statusWordMsg);
            }
            int[] statusWordBinArr = statusWordInst.toStatusBinArr(statusWordInst.statusByte);
            for (i = 0; i < statusWordBinArr.length; ++i) {
                if (statusWordBinArr[i] != 1) continue;
                this.setStatusWordDetailDesc(i, false);
            }
        }
        return this.allMsgMap;
    }

    public Map<String, Map<Integer, String>> getSimpleStatusDescription() {
        int i;
        Status statusByteInst = this.statusInsts.get("Status Byte");
        Status statusWordInst = this.statusInsts.get("Status Word");
        if (statusByteInst.statusByte == 0 && statusWordInst.statusByte == 0) {
            return null;
        }
        if (statusByteInst.statusByte != 0) {
            Map<Integer, String> statusByteMsg = statusByteInst.getSimpleStatusDescription();
            if (statusByteMsg != null && statusByteMsg.size() > 0) {
                this.allMsgMap.put(statusByteInst.getStatusMsgTittle(), statusByteMsg);
            }
            int[] statusByteBinArr = statusByteInst.toStatusBinArr(statusByteInst.statusByte);
            for (i = 0; i < statusByteBinArr.length; ++i) {
                if (statusByteBinArr[i] != 1) continue;
                this.setStatusByteDetailDesc(i, true);
            }
        }
        if (statusWordInst.statusByte != 0) {
            Map<Integer, String> statusWordMsg = statusWordInst.getSimpleStatusDescription();
            if (statusWordMsg != null && statusWordMsg.size() > 0) {
                this.allMsgMap.put(statusWordInst.getStatusMsgTittle(), statusWordMsg);
            }
            int[] statusWordBinArr = statusWordInst.toStatusBinArr(statusWordInst.statusByte);
            for (i = 0; i < statusWordBinArr.length; ++i) {
                if (statusWordBinArr[i] != 1) continue;
                this.setStatusWordDetailDesc(i, true);
            }
        }
        return this.allMsgMap;
    }

    public Map<String, Status> getAllStatusFromPMBus() throws Exception {
        this.createStatusInsts();
        byte readCount = 1;
        int returnIndex = 0;
        for (Status statusInst : this.statusInsts.values()) {
            if (statusInst.getStatusCode() == 121) {
                readCount = 2;
                returnIndex = 1;
            } else {
                readCount = 1;
                returnIndex = 0;
            }
            try {
                byte detailStatusByte;
                statusInst.statusByte = detailStatusByte = this.pmBusHealth.getStatusDetailByte(readCount, statusInst.getStatusCode(), returnIndex);
            }
            catch (Exception exception) {}
        }
        return this.statusInsts;
    }

    private void setStatusByteDetailDesc(int index, Boolean isSimple) {
        Map<Integer, String> msgMap = null;
        Status statusInst = null;
        switch (index) {
            case 7: {
                break;
            }
            case 6: {
                break;
            }
            case 5: {
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                break;
            }
            case 2: {
                statusInst = this.statusInsts.get("Status Temperture");
                break;
            }
            case 1: {
                statusInst = this.statusInsts.get("Status CML");
                break;
            }
        }
        if (statusInst != null && (msgMap = isSimple != false ? statusInst.getSimpleStatusDescription() : statusInst.getStatusDescription()) != null && !msgMap.isEmpty()) {
            this.allMsgMap.put(statusInst.getStatusMsgTittle(), msgMap);
        }
    }

    private void setStatusWordDetailDesc(int index, Boolean isSimple) {
        Map<Integer, String> msgMap = null;
        Status statusInst = null;
        Status statusInst1 = null;
        switch (index) {
            case 7: {
                statusInst = this.statusInsts.get("Status Vout");
                break;
            }
            case 6: {
                statusInst = this.statusInsts.get("Status Iout");
                break;
            }
            case 5: {
                statusInst = this.statusInsts.get("Status Input");
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                break;
            }
            case 2: {
                statusInst = this.statusInsts.get("Status FAN_1_2");
                statusInst1 = this.statusInsts.get("Status FAN_3_4");
                break;
            }
            case 1: {
                statusInst = this.statusInsts.get("Status Other");
                break;
            }
        }
        if (statusInst != null && (msgMap = isSimple != false ? statusInst.getSimpleStatusDescription() : statusInst.getStatusDescription()) != null && !msgMap.isEmpty()) {
            this.allMsgMap.put(statusInst.getStatusMsgTittle(), msgMap);
        }
        if (statusInst1 != null && (msgMap = isSimple != false ? statusInst1.getSimpleStatusDescription() : statusInst1.getStatusDescription()) != null && !msgMap.isEmpty()) {
            this.allMsgMap.put(statusInst1.getStatusMsgTittle(), msgMap);
        }
    }

    private void createStatusInsts() {
        this.statusInsts = new HashMap<String, Status>();
        Status statusByteInst = StatusFactory.createStatusByte();
        Status statusWordInst = StatusFactory.createStatusWord();
        Status statusCMLInst = StatusFactory.createStatusCML();
        Status statusIoutInst = StatusFactory.createStatusIout();
        Status statusVoutInst = StatusFactory.createStatusVout();
        Status statusInputInst = StatusFactory.createStatusInput();
        Status statusFan12Inst = StatusFactory.createStatusFan12();
        Status statusTempertureInst = StatusFactory.createStatusTemperture();
        this.statusInsts.put("Status Byte", statusByteInst);
        this.statusInsts.put("Status Word", statusWordInst);
        this.statusInsts.put("Status CML", statusCMLInst);
        this.statusInsts.put("Status Iout", statusIoutInst);
        this.statusInsts.put("Status Vout", statusVoutInst);
        this.statusInsts.put("Status Input", statusInputInst);
        this.statusInsts.put("Status FAN_1_2", statusFan12Inst);
        this.statusInsts.put("Status Temperture", statusTempertureInst);
    }
}

