/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text.nm.suspendperiod;

import com.supermicro.ipmi.text.nm.suspendperiod.AbstractSuspenPeriodCommand;
import com.supermicro.ipmi.text.nm.suspendperiod.SuspendPeriodRaw;
import java.text.ParseException;

public class DeletePeriod
extends AbstractSuspenPeriodCommand {
    private int domainId;
    private int policyId;
    private int periodId;

    public DeletePeriod(String[] parameters) {
        super(parameters);
        try {
            this.validate(parameters);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid value: " + e.getMessage());
        }
    }

    protected void validate(String[] parameters) throws ParseException {
        if (parameters == null || parameters.length != 3) {
            this.help();
            throw new IllegalArgumentException();
        }
        this.domainId = Integer.parseInt(parameters[0]);
        this.policyId = Integer.parseInt(parameters[1]);
        this.periodId = Integer.parseInt(parameters[2]);
        if (this.domainId < 0 || this.policyId < 0 || this.policyId > 255 || this.periodId < 1 || this.periodId > 5) {
            throw new IllegalArgumentException("Invalid value");
        }
    }

    @Override
    public byte[] getNewPeriod(byte[] currentPeriod) {
        SuspendPeriodRaw period = new SuspendPeriodRaw(currentPeriod);
        return period.delete(this.periodId);
    }

    @Override
    public int getDomainId() {
        return this.domainId;
    }

    @Override
    public int getPolicyId() {
        return this.policyId;
    }

    @Override
    public void help() {
        System.out.println("delete <domainId> <policyId> <periodId>");
        System.out.println("domainId :");
        System.out.println("\t0 \u00a1V Entire platform");
        System.out.println("\t1 \u00a1V CPU subsystem");
        System.out.println("\t2 \u00a1V Memory subsystem");
        System.out.println("\t3 \u00a1V HW Protection (NM3.0)");
        System.out.println("\t4 \u00a1V High Power I/O subsystem");
        System.out.println("policyId : 0~255");
        System.out.println("periodId : 1~5");
    }
}

