/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text.nm.summary;

import com.supermicro.ipmi.text.NMPolicyDto;
import com.supermicro.ipmi.text.nm.summary.NMDomain;
import com.supermicro.ipmi.util.StringUtil;
import java.util.Map;

public class NMPolicyTable {
    private NMDomain domain;
    public static final String splitLine = "+-----------------------------------------------------------------+";
    public static final String splitLineD = "+=================================================================+";
    public static final String splitLineP = "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++";
    private String format = "|%4s|%8s|%8s|%42s|\n";
    private String[] fields = new String[]{"ID", "State", "Limit", "Trigger Type"};

    public void display(NMDomain domain) {
        this.domain = domain;
        this.printDomainTitle();
        this.printFieldName();
        this.printPolicy();
    }

    private void printDomainTitle() {
        String state = this.domain.getState() == 1 ? "Enable" : "Disable";
        String title = String.format("#%d %s (%d) [%s]", this.domain.domainId, this.domain.getDomain(), this.domain.getCount(), state);
        System.out.println(splitLineP);
        System.out.format("|%s|\n", StringUtil.center(title, splitLine.length() - 2));
        System.out.println(splitLine);
    }

    private void printFieldName() {
        System.out.format(this.format, this.fields);
    }

    private void printPolicy() {
        int id = -1;
        String state = null;
        String trigger = null;
        boolean first = true;
        for (Map.Entry<Integer, NMPolicyDto> p : this.domain.getPolicies().entrySet()) {
            NMPolicyDto pd = p.getValue();
            id = p.getKey();
            state = pd.isPolicyEnable() ? "Enable" : "Disable";
            trigger = this.getTriggerString(pd.getTriggerType(), pd.triggerLimitWithUnit());
            if (first) {
                first = false;
                System.out.println(splitLineD);
            } else {
                System.out.println(splitLine);
            }
            System.out.format(this.format, id, state, pd.targetLimitWithUnit(), trigger);
        }
    }

    private String getTriggerString(String type, String limit) {
        if ("N/A".equals(limit)) {
            return type;
        }
        return String.format("%s (%s)", type, limit);
    }
}

