/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text.nm.summary;

import com.supermicro.ipmi.IPMIDCMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.nm.dcmi.GetPowerLimit;
import com.supermicro.ipmi.nm.dcmi.PowerLimit;
import com.supermicro.ipmi.util.StringUtil;

public class DCMIInfo {
    private IPMIDCMICommand dcmi;
    private int limit;
    private boolean exception = false;
    private String message = null;
    private String splitLine = "+--------+";
    private String format = "|%8s|\n";
    private String[] fields = new String[]{"Limit"};

    public DCMIInfo(IPMIDCMICommand dcmi) {
        this.dcmi = dcmi;
        try {
            this.getInfo();
        }
        catch (IPMIException e) {
            this.exception = true;
            System.out.format("[Error] Get DCMI Information %s", e.getMessage() == null ? "" : ":" + e.getMessage());
        }
    }

    private void getInfo() throws IPMIException {
        try {
            GetPowerLimit command = new GetPowerLimit(this.dcmi);
            PowerLimit resp = command.execute();
            this.limit = resp.powerLimit;
        }
        catch (IPMIException e) {
            if ((e.getIPMIMessage().completionCode & 0xFF) != 128) {
                this.exception = true;
                throw e;
            }
            this.message = "Disabled or not set";
        }
    }

    public void lineDisplay() {
        if (this.exception) {
            return;
        }
        if (this.message != null) {
            System.out.println("DCMI Power Limit: " + this.message);
            return;
        }
        System.out.println("DCMI Power Limit (W):\t" + this.limit);
    }

    public void display() {
        if (this.exception) {
            return;
        }
        System.out.println(StringUtil.center("DCMI Power Limit", this.splitLine.length()));
        if (this.message != null) {
            System.out.println(this.message);
            return;
        }
        System.out.println(this.splitLine);
        System.out.format(this.format, this.fields);
        System.out.println(this.splitLine);
        System.out.format(this.format, this.limit);
        System.out.println(this.splitLine);
    }
}

