/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

public class UserAccountProperty {
    public static final byte USER_PRIVILEGE_BYTE_RESERVED = 0;
    public static final byte USER_PRIVILEGE_BYTE_CALLBACK = 1;
    public static final byte USER_PRIVILEGE_BYTE_USER = 2;
    public static final byte USER_PRIVILEGE_BYTE_OPERATOR = 3;
    public static final byte USER_PRIVILEGE_BYTE_ADMINISTRATOR = 4;
    public static final byte USER_PRIVILEGE_BYTE_OEM_PROPRIETARY = 5;
    public static final byte USER_PRIVILEGE_BYTE_NO_ACCESS = 15;
    public static final int USER_ACCOUNT_STATE_RESERVED = -1;
    public static final int USER_ACCOUNT_STATE_DISABLE = 0;
    public static final int USER_ACCOUNT_STATE_ENABLE = 1;
    public static final String USER_PRIVILEGE_RESERVED = "Reserved";
    public static final String USER_PRIVILEGE_CALLBACK = "Callback";
    public static final String USER_PRIVILEGE_USER = "User";
    public static final String USER_PRIVILEGE_OPERATOR = "Operator";
    public static final String USER_PRIVILEGE_ADMINISTRATOR = "Administrator";
    public static final String USER_PRIVILEGE_OEM_PROPRIETARY = "OEM Proprietary";
    public static final String USER_PRIVILEGE_NO_ACCESS = "NO ACCESS";
    public static final String USER_NAME_ANONYMOUS = "Anonymous";
    public static final String USER_NAME_ADMIN = "ADMIN";
    private byte userID = 1;
    private byte networkPrivilege = 0;
    private boolean isEnabledSOL = false;
    private int accountState = -1;
    private String username = "Anonymous";
    private String password = "";
    private boolean isUsernameValid = false;
    private boolean isPasswordValid = false;

    public byte getUserIDByte() {
        return this.userID;
    }

    public String getUserID() {
        return String.valueOf(this.userID);
    }

    public byte getNetworkPrivilegeByte() {
        return this.networkPrivilege;
    }

    public String getNetworkPrivilege() {
        return this.getNetworkPrivilege(this.networkPrivilege);
    }

    public boolean isEnabledSOL() {
        return this.isEnabledSOL;
    }

    public boolean isUserAccountPropertyValid() {
        return this.isUsernameValid && this.isPasswordValid;
    }

    public int getAccountState() {
        return this.accountState;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUserID(byte userID) {
        this.userID = userID;
    }

    public void setNetworkPrivilege(byte networkPrivilege) {
        this.networkPrivilege = networkPrivilege;
    }

    public void setEnabledSOL(boolean isEnabledSOL) {
        this.isEnabledSOL = isEnabledSOL;
    }

    public void setAccountState(int state) {
        this.accountState = state;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private String getNetworkPrivilege(byte privilege) {
        switch (privilege) {
            case 0: {
                return USER_PRIVILEGE_RESERVED;
            }
            case 1: {
                return USER_PRIVILEGE_CALLBACK;
            }
            case 2: {
                return USER_PRIVILEGE_USER;
            }
            case 3: {
                return USER_PRIVILEGE_OPERATOR;
            }
            case 4: {
                return USER_PRIVILEGE_ADMINISTRATOR;
            }
            case 5: {
                return USER_PRIVILEGE_OEM_PROPRIETARY;
            }
        }
        return USER_PRIVILEGE_NO_ACCESS;
    }
}

