/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMINVMECommand;
import com.supermicro.ipmi.IPMITASCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.util.ArrayList;

public class NVMEIBRemoveCommand
extends SuperBladeCommand {
    int option;
    byte aoc;
    byte slot;
    byte group;

    @Override
    public boolean preValidate() {
        if (this.parameters != null && this.parameters.length == 2) {
            this.option = 0;
            try {
                this.option = Byte.parseByte(this.parameters[1], 10);
            }
            catch (NumberFormatException e) {
                MOut.G(this).println(e.getMessage());
                this.statusCode = 147;
                return false;
            }
            return true;
        }
        if (this.parameters != null && this.parameters.length == 3) {
            this.aoc = 0;
            this.slot = 0;
            this.group = 0;
            try {
                this.aoc = Byte.parseByte(this.parameters[0], 10);
            }
            catch (NumberFormatException e) {
                MOut.G(this).println(e.getMessage());
                this.statusCode = 147;
                return false;
            }
            try {
                this.group = Byte.parseByte(this.parameters[1], 10);
            }
            catch (NumberFormatException e) {
                MOut.G(this).println(e.getMessage());
                this.statusCode = 147;
                return false;
            }
            try {
                this.slot = Byte.parseByte(this.parameters[2], 10);
            }
            catch (NumberFormatException e) {
                MOut.G(this).println(e.getMessage());
                this.statusCode = 147;
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        IPMITASCommand ipmiTasCommand = new IPMITASCommand(null);
        ipmiTasCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMINVMECommand ipmiNVMECommand = new IPMINVMECommand(null);
        ipmiNVMECommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.parameters == null) {
            this.printUsage();
            this.statusCode = 0;
            return;
        }
        if (this.parameters.length <= 0 || this.parameters.length >= 4) {
            this.printUsage();
            this.statusCode = 0;
            return;
        }
        if (this.parameters.length == 1) {
            boolean setOOBSlot = this.setAOCandSlotBySerial(ipmiNVMECommand, ipmiTasCommand);
            if (!ipmiTasCommand.isFlagAvailable()) {
                MOut.G(this).println("TAS command area has been occupied, please resend the command latter.");
                this.statusCode = 0;
                return;
            }
            if (this.remove(ipmiTasCommand)) {
                if (setOOBSlot) {
                    MOut.G().println("Waiting for 10 secs to remove device.......");
                    Thread.sleep(10000L);
                    this.eject(ipmiNVMECommand, false);
                } else {
                    MOut.G().println("OOB eject fail due to serial number missmatch");
                }
            }
        } else if (this.parameters.length == 2) {
            if (this.option == 0) {
                boolean setOOBSlot = this.setAOCandSlotBySerial(ipmiNVMECommand, ipmiTasCommand);
                if (!ipmiTasCommand.isFlagAvailable()) {
                    MOut.G(this).println("TAS command area has been occupied, please resend the command later.");
                    this.statusCode = 0;
                    return;
                }
                if (this.remove(ipmiTasCommand)) {
                    if (setOOBSlot) {
                        MOut.G().println("Waiting for 10 secs to remove device.......");
                        Thread.sleep(10000L);
                        this.eject(ipmiNVMECommand, false);
                    } else {
                        MOut.G().println("OOB eject fail due to serial number missmatch");
                    }
                }
            } else {
                if (!ipmiTasCommand.isFlagAvailable()) {
                    MOut.G(this).println("TAS command area has been occupied, please resend the command latter.");
                    this.statusCode = 0;
                    return;
                }
                this.remove(ipmiTasCommand);
            }
        } else if (this.parameters.length == 3) {
            this.eject(ipmiNVMECommand, true);
        }
        this.statusCode = 0;
    }

    public boolean remove(IPMITASCommand ipmiTasCommand) throws Exception {
        if (!ipmiTasCommand.checkTASAlive()) {
            this.statusCode = 0;
            return false;
        }
        int deviceCount = ipmiTasCommand.getNVMEDeviceCount();
        byte[] key = IPMITASCommand.getModifiedMacAsKey();
        char ch = this.parameters[0].charAt(this.parameters[0].length() - 2);
        int number = ch >= '0' && ch <= '9' ? Integer.parseInt(this.parameters[0].substring(this.parameters[0].length() - 2)) : Integer.parseInt(this.parameters[0].substring(this.parameters[0].length() - 1));
        for (int i = 0; i < deviceCount; ++i) {
            byte[] response;
            if (!this.parameters[0].equalsIgnoreCase(ipmiTasCommand.getNvmeDeviceName(i))) continue;
            MOut.G().println("Sending in band remove command...");
            ipmiTasCommand.setNvmeRemovebyKey(key, number);
            int j = 0;
            while ((response = ipmiTasCommand.getCommandResponse()) == null) {
                Thread.sleep(1000L);
                if (++j < 10) continue;
            }
            if (response == null) {
                MOut.G(this).println("Command timeOut, please try again.");
                this.statusCode = 149;
                return false;
            }
            if (IPMITASCommand.compareKeyFromResponse(key, response)) {
                MOut.G(this).println("Done");
                this.statusCode = 0;
                return true;
            }
            MOut.G(this).println("Command fail, please try again.");
            this.statusCode = 149;
            return false;
        }
        MOut.G().print("Can't find device name.");
        return false;
    }

    public void eject(IPMINVMECommand ipmiNVMECommand, boolean sendOnlyOOB) throws IPMIException {
        ArrayList<IPMINVMECommand.NVMEAOCInfo> nvmeAOCInfos = ipmiNVMECommand.getAll();
        if (nvmeAOCInfos == null) {
            this.statusCode = 153;
            MOut.G(this).println("No NVME info");
            return;
        }
        boolean nongroup = false;
        byte[] dropGroupStatus = null;
        try {
            dropGroupStatus = ipmiNVMECommand.getDropGroupStatus();
            if (dropGroupStatus[0] == 1) {
                nongroup = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("Sending OOB eject command...");
        if (nongroup) {
            ipmiNVMECommand.setLocate((byte)-1, this.slot, (byte)2, (byte)-1);
            MOut.G(this).println("Done");
            this.statusCode = 0;
            return;
        }
        if (ipmiNVMECommand.isGroupingWithCPU() && sendOnlyOOB) {
            this.group = (byte)(this.group - 1);
        } else {
            this.slot = nvmeAOCInfos.get((int)0).aocGroups.get((int)0).slotPerGroup == 24 ? (byte)(this.slot % 24) : (byte)(this.slot % 12);
        }
        ipmiNVMECommand.setLocate(this.aoc, this.slot, (byte)2, this.group);
        MOut.G(this).println("Done");
        this.statusCode = 0;
    }

    public void printUsage() {
        MOut.G(this).println("Usage1: nvme remove <HDD name> [option]");
        MOut.G(this).println("        option 0: Do eject after remove (Default)");
        MOut.G(this).println("        option 1: Do not eject after remove");
        MOut.G(this).println("Usage2: nvme remove <aoc> <group> <slot>");
    }

    public boolean setAOCandSlotBySerial(IPMINVMECommand ipmiNVMECommand, IPMITASCommand ipmiTasCommand) throws IPMIException {
        ArrayList<IPMINVMECommand.NVMEAOCInfo> nvmeAOCInfos = ipmiNVMECommand.getAll();
        int deviceCount = ipmiTasCommand.getNVMEDeviceCount();
        String result = new String();
        for (int i = 0; i < deviceCount; ++i) {
            if (!this.parameters[0].equalsIgnoreCase(ipmiTasCommand.getNvmeDeviceName(i))) continue;
            int offset = 0;
            int lengthCount = 0;
            byte currentLength = 0;
            int TotalLength = ipmiTasCommand.getSmartTotalDataLength(i);
            do {
                byte[] data = ipmiTasCommand.getSmartRetunInfo(i, offset);
                currentLength = data[6];
                byte[] smartInfo = new byte[currentLength];
                System.arraycopy(data, 7, smartInfo, 0, currentLength);
                offset += 32;
                result = result + new String(smartInfo);
            } while ((lengthCount += currentLength) < TotalLength);
            IPMITASCommand.SmartInfo smartStructure = ipmiTasCommand.createSmartStructure(result);
            result = "";
            IPMINVMECommand.VPD VPD2 = null;
            for (int j = 0; j < nvmeAOCInfos.size(); ++j) {
                for (int k = 0; k < nvmeAOCInfos.get((int)j).aocGroups.size(); ++k) {
                    VPD2 = nvmeAOCInfos.get((int)j).aocGroups.get(k).getMatchVPD(smartStructure.serialNumber);
                    if (VPD2 == null) continue;
                    this.aoc = (byte)j;
                    this.slot = VPD2.getSlot();
                    this.group = (byte)k;
                    return true;
                }
            }
        }
        return false;
    }
}

