/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMIDCMOEMCommand;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.SDRRecordC0h_NMOEMSDR;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class NMGetPolicyCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        byte id;
        IPMIDCMOEMCommand ipmiDCMOEMCommand = null;
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        SDRRecordC0h_NMOEMSDR nmOEMSDR = ipmiSDRCommand.getNMSDR();
        if (nmOEMSDR == null || !nmOEMSDR.isNMOEMSDR()) {
            MOut.G(this).println("This device does not support Node Manager");
            this.statusCode = 153;
            return;
        }
        if (nmOEMSDR.isIPMB()) {
            IPMB ipmb = new IPMB(this.ipmiCMMOEMCommand.getIPMIInterface());
            ipmb.setAddress(nmOEMSDR.getSlaveAddress());
            ipmb.setChannel(nmOEMSDR.getChannel());
            ipmb.setIpmbType(0);
            ipmiDCMOEMCommand = new IPMIDCMOEMCommand(ipmb);
        } else {
            ipmiDCMOEMCommand = new IPMIDCMOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        }
        if (this.parameters == null || this.parameters.length < 1) {
            MOut.G(this).println("getPolicy <id>");
            this.statusCode = 0;
            return;
        }
        try {
            id = Byte.parseByte(this.parameters[0]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).print(ex.getMessage());
            this.statusCode = 147;
            return;
        }
        IPMIDCMOEMCommand.NodeManagerPolicy policy = null;
        try {
            policy = ipmiDCMOEMCommand.getNodeManagerPolicy((byte)0, id);
        }
        catch (Exception ex) {
            MOut.G(this).print(ex.getMessage());
            this.statusCode = 148;
            return;
        }
        if (policy == null) {
            MOut.G(this).println("Call getNodeManagerStatistics failed");
        }
        MOut.G(this).println("Power Limit = " + ByteUtility.twoBytesToIntLSB(policy.powerLimit) + " w");
        MOut.G(this).println("Correction Time limit       = " + ByteUtility.fourBytesToIntByLSBFirst(policy.correctionTimeLimit) + " ms");
        MOut.G(this).println("Statistics Reporting Period = " + ByteUtility.twoBytesToIntLSB(policy.statisticsReportingPeriod) + " s");
        MOut.G(this).println("Policy state:");
        if ((policy.domainIDAndPolicyState & 0x10) == 16) {
            MOut.G(this).println("    Policy enabled");
        } else {
            MOut.G(this).println("    Policy is not enabled");
        }
        if ((policy.domainIDAndPolicyState & 0x20) == 32) {
            MOut.G(this).println("    Per Domain Node Manager policy control enabled");
        }
        if ((policy.domainIDAndPolicyState & 0x40) == 64) {
            MOut.G(this).println("    Global Node Manager policy control enabled");
        }
        MOut.G(this).println("Policy Exception action state:");
        if ((policy.policyException & 1) == 1) {
            MOut.G(this).println("    Send alert");
        }
        if ((policy.policyException & 2) == 2) {
            MOut.G(this).println("    Shutdown system");
        }
        this.statusCode = 0;
    }
}

