/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMIDCMOEMCommand;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.SDRRecordC0h_NMOEMSDR;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class NMCapabilitiesCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        IPMIDCMOEMCommand ipmiDCMOEMCommand = null;
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        SDRRecordC0h_NMOEMSDR nmOEMSDR = ipmiSDRCommand.getNMSDR();
        if (nmOEMSDR == null || !nmOEMSDR.isNMOEMSDR()) {
            MOut.G(this).println("This device does not support Node Manager");
            this.statusCode = 153;
            return;
        }
        if (nmOEMSDR.isIPMB()) {
            IPMB ipmb = new IPMB(this.ipmiCMMOEMCommand.getIPMIInterface());
            ipmb.setAddress(nmOEMSDR.getSlaveAddress());
            ipmb.setChannel(nmOEMSDR.getChannel());
            ipmb.setIpmbType(0);
            ipmiDCMOEMCommand = new IPMIDCMOEMCommand(ipmb);
        } else {
            ipmiDCMOEMCommand = new IPMIDCMOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        }
        IPMIDCMOEMCommand.NodeManagerCapabilities cap = null;
        try {
            cap = ipmiDCMOEMCommand.getNodeManagerCapabilities((byte)0, (byte)16);
        }
        catch (Exception ex) {
            MOut.G(this).println(ex.getMessage());
            this.statusCode = 148;
            return;
        }
        if (cap == null) {
            MOut.G(this).println("Call getNodeManagerCapabilities failed");
        }
        MOut.G(this).println("Max concurrent settings         = " + cap.maxCurrentSettings);
        MOut.G(this).println("Max Power limit value           = " + ByteUtility.twoBytesToIntLSB(cap.maxValue) + " w");
        MOut.G(this).println("Min Power limit value           = " + ByteUtility.twoBytesToIntLSB(cap.minValue) + " w");
        MOut.G(this).println("Max Correction Time settable    = " + ByteUtility.fourBytesToIntByLSBFirst(cap.maxCorrectionTime) + " ms");
        MOut.G(this).println("Min Correction Time settable    = " + ByteUtility.fourBytesToIntByLSBFirst(cap.minCorrectionTime) + " ms");
        MOut.G(this).println("Max Statistics Reporting period = " + ByteUtility.twoBytesToIntLSB(cap.maxStatisticsReportingPeriod) + " s");
        MOut.G(this).println("Min Statistics Reporting period = " + ByteUtility.twoBytesToIntLSB(cap.minStatisticsReportingPeriod) + " s");
        if (cap.domainLimitingScope == 0) {
            MOut.G(this).println("Limiting type                   = platform power limiting");
        } else if (cap.domainLimitingScope == 1) {
            MOut.G(this).println("Limiting type                   = CPU power limiting");
        }
        if ((byte)(cap.domainLimitingScope & 0x80) == -128) {
            MOut.G(this).println("Limiting based on               = Wall input power. PSU input power");
        } else {
            MOut.G(this).println("Limiting based on               = DC power - PSU output power or bladed system");
        }
        this.statusCode = 0;
    }
}

