/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.DeviceInfo;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.SDRRecordC0h_NMOEMSDR;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.io.IOException;

public abstract class NM40AbstractCommand
extends SuperBladeCommand {
    protected IPMIInterface ipmiInterfaceForNM = null;

    public abstract void runNM40Command() throws Exception;

    @Override
    public void runCommand() throws Exception {
        if (!this.isSupportedDevice()) {
            this.statusCode = 153;
            return;
        }
        GlobalDefine.PAUSE_DEBUG = true;
        try {
            this.setNMInterface();
        }
        catch (Exception e) {
            MOut.G(this).println("Exception:" + e.getMessage());
            return;
        }
        if (this.getNMVersion() < 4) {
            MOut.G(this).println("This device does not support Node Manager 4.0");
            this.statusCode = 153;
            return;
        }
        GlobalDefine.PAUSE_DEBUG = false;
        this.runNM40Command();
    }

    public IPMIInterface getNMInterface() throws IPMIException {
        if (this.ipmiInterfaceForNM == null) {
            throw new IPMIException("NM IPMI Interface not is null");
        }
        return this.ipmiInterfaceForNM;
    }

    private boolean isSupportedDevice() {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte[] guid = ipmiMessagingCommand.getSystemGUID();
        if (IPMIMessagingCommand.isH11GUID(guid) || IPMIMessagingCommand.isH12GUID(guid) || IPMIMessagingCommand.isH12RoTGUID(guid) || IPMIMessagingCommand.isH12SSFFGUID(guid) || IPMIMessagingCommand.isH12SSFRGUID(guid) || IPMIMessagingCommand.isH12SSGGUID(guid) || IPMIMessagingCommand.isH12DSGGUID(guid) || IPMIMessagingCommand.isM12GUID(guid) || IPMIMessagingCommand.isHGIMEZZGUID(guid)) {
            MOut.G(this).println("This device is not supported");
            return false;
        }
        return true;
    }

    private void setNMInterface() throws IPMIException, IOException {
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        SDRRecordC0h_NMOEMSDR nmOEMSDR = ipmiSDRCommand.getNMSDR();
        if (nmOEMSDR == null || !nmOEMSDR.isNMOEMSDR()) {
            MOut.G(this).println("This device does not support Node Manager");
            this.statusCode = 153;
            throw new IPMIException("NM is not spported");
        }
        if (nmOEMSDR.isIPMB()) {
            IPMB ipmb = new IPMB(this.ipmiCMMOEMCommand.getIPMIInterface());
            ipmb.setAddress(nmOEMSDR.getSlaveAddress());
            ipmb.setChannel(nmOEMSDR.getChannel());
            ipmb.setIpmbType(0);
            this.ipmiInterfaceForNM = ipmb;
        } else {
            this.ipmiInterfaceForNM = this.ipmiCMMOEMCommand.getIPMIInterface();
        }
    }

    private int getNMVersion() throws IPMIException {
        IPMINM20Command ipmiNM20Command = new IPMINM20Command(this.getNMInterface());
        DeviceInfo deviceID = ipmiNM20Command.getDeviceID();
        return deviceID.raw[11] & 0xF;
    }
}

