/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.microblade.SwitchInfo;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.MicroBladeCommand;

public class MicroBladeSwitchCommand
extends MicroBladeCommand {
    byte sIndex = (byte)-1;

    @Override
    public boolean preValidate() {
        if (this.parameters != null && this.parameters.length == 1) {
            String switchIndex = this.getParameters()[0];
            this.sIndex = (byte)SwitchInfo.getIndex(switchIndex);
            if (this.sIndex < 0) {
                MOut.G(this).println("The switch index must be A1-A2 or B1-B2");
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void runCommand() throws Exception {
        if (this.getParameters() != null) {
            if (this.getParameters().length != 1) {
                MOut.G(this).println("[switch index] is required");
                this.statusCode = 147;
                return;
            }
            SwitchInfo switchInfo = this.ipmiMicroBladeOEMCommand.getSwitch(this.sIndex, (byte)1);
            if (!switchInfo.isPresent()) {
                MOut.G(this).println("Switch " + this.parameters[0] + " is not presented");
                this.statusCode = 151;
                return;
            }
            MOut.G(this).print(switchInfo.toFormatedHeader());
            MOut.G(this).println(switchInfo.toFormatedString());
        } else {
            for (int i = 0; i < 4; ++i) {
                SwitchInfo switchInfo = this.ipmiMicroBladeOEMCommand.getSwitch((byte)i, (byte)1);
                if (switchInfo.isPresent()) {
                    MOut.G(this).print(switchInfo.toFormatedHeader());
                    MOut.G(this).println(switchInfo.toFormatedString());
                    continue;
                }
                MOut.G(this).println("Switch " + SwitchInfo.getIndex(i) + " is not presented");
            }
        }
        this.statusCode = 0;
    }
}

