/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIChassisCommand;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.SDRRecord;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.util.StringUtil;
import java.io.IOException;

public class IPMISensorDisplay
extends IPMICommand {
    IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(this.getIPMIInterface());
    IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(this.getIPMIInterface());
    private IPMIInterfaceConfig config;
    static final int READING_SAFE = 0;
    static final int READING_UNSAFE = 1;
    static final int READING_UNKNOWN = 2;
    String formatTemplate = "  %-6s | %-24s | %12s | %9s | %10s |\n";
    String formatTemplateValueOnly = "  %-6s | %-24s | %37s |\n";
    String formatTemplateThreshold = "  %-6s | %6s | %8s | %-24s | %12s | %8s | %8s | %9s | %9s |\n";
    String formatTemplateNonThreshold = "  %-6s | %6s | %8s | %-24s | %58s |\n";
    boolean threshold;
    boolean hasSensorData = false;

    public IPMISensorDisplay(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public String getSDR(SDRRecord item, boolean showThreshold, boolean ispowerOn, byte[] guid) throws IOException, IPMIException {
        MOut.G().enableBufferOutput();
        MOut.G().resetBuffer();
        MOut.G().isPrintToScreen = false;
        try {
            this.print(item, showThreshold, ispowerOn, guid);
        }
        catch (IPMIException | IOException exception) {
            // empty catch block
        }
        MOut.G().isPrintToScreen = true;
        MOut.G().disableBufferOutput();
        return MOut.G().getBufferContent();
    }

    public boolean print(SDRRecord item, boolean showThreshold, boolean ispowerOn, byte[] guid) throws IOException, IPMIException {
        if (GlobalDefine.THERMAL_TEAM_SCRIPT) {
            if (showThreshold) {
                this.formatTemplateThreshold = "  %-6s | %6s | %8s | %8s | %-24s | %12s | %8s | %8s | %9s | %9s |\n";
            }
            this.formatTemplateNonThreshold = "  %-6s | %6s | %8s | %-35s | %46s |\n";
        }
        this.threshold = showThreshold;
        boolean isAten = true;
        if (IPMIMessagingCommand.isCMMGUID(guid) || IPMIMessagingCommand.isOfficeBladeCMMGUID(guid) || IPMIMessagingCommand.isTwinBladeCMMGUID(guid) || IPMIMessagingCommand.isNormalBladeCMMGUID(guid) || IPMIMessagingCommand.isSIMBL(guid) || IPMIMessagingCommand.isPepperconGUID(guid) || IPMIMessagingCommand.isPepperconNoneKVMGUID(guid) || IPMIMessagingCommand.isOSAGUID(guid) || IPMIMessagingCommand.isAMIGUID(guid) || IPMIMessagingCommand.isAMISIMBLGUID(guid) || IPMIMessagingCommand.isAMIX9GUID(guid) || IPMIMessagingCommand.isAMIAspeedGUID(guid) || IPMIMessagingCommand.isCB3GUID(guid) || IPMIMessagingCommand.isAMIOnBoardGUID(guid) || IPMIMessagingCommand.isAMIAddOnGUID(guid) || IPMIMessagingCommand.isRenesasATENGUID(guid)) {
            isAten = false;
        }
        boolean isMicroNode = IPMIMessagingCommand.isMicroBladeNodeGUID(guid);
        if (item.getEventReadingTypeCode() == 3 || item.getEventReadingTypeCode() == 6 || item.getEventReadingTypeCode() == 9 || item.getEventReadingTypeCode() == 111) {
            int status = 2;
            byte discreteReading = this.getDiscreteOffset(item.getSensorNumber());
            int offset = -1;
            if (discreteReading != -1) {
                for (int i = 0; i < 8; ++i) {
                    if ((discreteReading >> i & 1) != 1) continue;
                    offset = (byte)i;
                }
            }
            String value = offset == -1 ? "N/A" : GlobalDefine.getDiscreteSensorReading(item.getEventReadingTypeCode(), item.getSensorType(), (byte)offset);
            if (item.getEventReadingTypeCode() != 111) {
                if (offset == 0) {
                    switch (item.getEventReadingTypeCode()) {
                        case 3: 
                        case 6: {
                            status = 0;
                        }
                    }
                } else if (offset == 1) {
                    switch (item.getEventReadingTypeCode()) {
                        case 3: 
                        case 9: {
                            status = 0;
                            break;
                        }
                        case 6: {
                            status = 1;
                        }
                    }
                } else if (offset == 5) {
                    switch (item.getEventReadingTypeCode()) {
                        case 9: {
                            status = 1;
                        }
                    }
                }
            } else if (item.getSensorType() == 5) {
                if (offset == -1) {
                    value = "OK";
                    status = 0;
                } else {
                    status = 1;
                }
            } else if (item.getSensorType() == 7) {
                if (offset == 7) {
                    status = 0;
                } else if (offset != -1) {
                    status = 1;
                }
            } else if (item.getSensorType() == 8) {
                status = offset == 0 ? 0 : 1;
            } else if (item.getSensorType() == 12) {
                if (offset == 6) {
                    status = 0;
                } else if (offset != -1) {
                    status = 1;
                }
            } else if (item.getSensorType() == 13) {
                if (offset == 0 || offset == 4) {
                    status = 0;
                } else if (offset != -1) {
                    status = 1;
                }
            } else if (item.getSensorType() == 41) {
                if (offset == 2) {
                    status = 0;
                } else if (offset == 1) {
                    status = 1;
                }
            } else if (item.getSensorType() == -61) {
                value = Byte.toString(discreteReading);
            } else if (item.getSensorType() == -60) {
                if (discreteReading == 0) {
                    value = "Normal";
                    status = 0;
                }
                if (discreteReading == 1) {
                    value = "Warning";
                    status = 1;
                } else if (discreteReading == 2) {
                    value = "Critical";
                    status = 1;
                } else if (discreteReading == 4) {
                    value = "Flashing";
                    status = 2;
                } else if (discreteReading == 5) {
                    value = "Initializing";
                    status = 2;
                }
            }
            if (!ispowerOn) {
                value = "N/A";
            }
            if (value == "N/A") {
                status = 2;
            }
            if (showThreshold) {
                this.addRawValueOnly(status, item, value);
            } else {
                this.addRawValueOnly(status, this.getSensornameAndNumber(item), value);
            }
            throw new IPMIException();
        }
        if (item.getSensorType() == 1 || item.getSensorType() == 2 || item.getSensorType() == 3 || item.getSensorType() == 4 || item.getSensorType() == 8 && item.getUnit().equals("Watts") || item.getSensorType() == 9 || item.getSensorType() == 11 || item.getSensorType() == -64 || item.getSensorType() == -62 || item.getSensorType() == -63) {
            int value = this.ipmiSDRCommand.getSensorReading(item.getSensorNumber(), item.getSensorType());
            String reading = "";
            String hi = "";
            String low = "";
            String lnr = "";
            String lct = "";
            String hct = "";
            String hnr = "";
            switch (item.getSensorType()) {
                case 1: {
                    if (value == -128) {
                        reading = "N/A";
                        hi = "N/A";
                        low = "N/A";
                        lnr = "N/A";
                        lct = "N/A";
                        hct = "N/A";
                        hnr = "N/A";
                        break;
                    }
                    reading = this.showCandF((int)item.calSensorReading(value));
                    hi = this.showCandF((int)item.getHiLimit());
                    low = this.showCandF((int)item.getLowLimit());
                    lnr = this.showCandF((int)item.getLowNR());
                    lct = this.showCandF((int)item.getLowCT());
                    hct = this.showCandF((int)item.getHighCT());
                    hnr = this.showCandF((int)item.getHighNR());
                    break;
                }
                case 2: {
                    reading = value == -1 || value == 0 ? "N/A" : item.doubleToString(item.calSensorReading(value & 0xFF)) + " V";
                    hi = item.doubleToString(item.getHiLimit()) + " V";
                    low = item.doubleToString(item.getLowLimit()) + " V";
                    lnr = item.doubleToString(item.getLowNR()) + " V";
                    lct = item.doubleToString(item.getLowCT()) + " V";
                    hct = item.doubleToString(item.getHighCT()) + " V";
                    hnr = item.doubleToString(item.getHighNR()) + " V";
                    if ((item.getDiscreteReadingMask_SettableThresholdMask_ReadableThreasholdMask()[0] & 1) != 1) {
                        low = "N/A";
                    }
                    if ((item.getDiscreteReadingMask_SettableThresholdMask_ReadableThreasholdMask()[0] & 2) != 2) {
                        lct = "N/A";
                    }
                    if ((item.getDiscreteReadingMask_SettableThresholdMask_ReadableThreasholdMask()[0] & 4) != 4) {
                        lnr = "N/A";
                    }
                    if ((item.getDiscreteReadingMask_SettableThresholdMask_ReadableThreasholdMask()[0] & 8) != 8) {
                        hi = "N/A";
                    }
                    if ((item.getDiscreteReadingMask_SettableThresholdMask_ReadableThreasholdMask()[0] & 0x10) != 16) {
                        hct = "N/A";
                    }
                    if ((item.getDiscreteReadingMask_SettableThresholdMask_ReadableThreasholdMask()[0] & 0x20) != 32) {
                        hnr = "N/A";
                    }
                    if (!isMicroNode || !item.getSensorName().contains("VBAT")) break;
                    hi = "N/A";
                    hct = "N/A";
                    hnr = "N/A";
                    break;
                }
                case 3: {
                    reading = value == -1 || value == 0 ? "N/A" : item.doubleToString(item.calSensorReading(value & 0xFF)) + " A";
                    hi = item.doubleToString(item.getHiLimit()) + " A";
                    low = item.doubleToString(item.getLowLimit()) + " A";
                    lnr = item.doubleToString(item.getLowNR()) + " A";
                    lct = item.doubleToString(item.getLowCT()) + " A";
                    hct = item.doubleToString(item.getHighCT()) + " A";
                    hnr = item.doubleToString(item.getHighNR()) + " A";
                    break;
                }
                case 4: {
                    reading = value == -1 || value == 0 ? "N/A" : "" + (int)item.calSensorReading(value & 0xFF) + " RPM";
                    hi = "" + (int)item.getHiLimit() + " RPM";
                    low = "" + (int)item.getLowLimit() + " RPM";
                    lnr = "" + (int)item.getLowNR() + " RPM";
                    lct = "" + (int)item.getLowCT() + " RPM";
                    hct = "" + (int)item.getHighCT() + " RPM";
                    hnr = "" + (int)item.getHighNR() + " RPM";
                    break;
                }
                case -62: 
                case 8: 
                case 9: 
                case 11: {
                    reading = value == -1 ? "N/A" : (int)item.calSensorReading(value & 0xFF) + " " + item.getUnit();
                    hi = item.getHiLimit() == 0.0 ? "N/A" : "" + item.getHiLimit();
                    low = item.getLowLimit() == 0.0 ? "N/A" : "" + item.getLowLimit();
                    lnr = item.getLowNR() == 0.0 ? "N/A" : "" + item.getLowNR();
                    lct = item.getLowCT() == 0.0 ? "N/A" : "" + item.getLowCT();
                    hct = item.getHighCT() == 0.0 ? "N/A" : "" + item.getHighCT();
                    hnr = item.getHighNR() == 0.0 ? "N/A" : "" + item.getHighCT();
                    break;
                }
                case -63: {
                    reading = value == -1 || value == 0 ? "N/A" : (int)item.calSensorReading(value & 0xFF) + " " + item.getUnit();
                    hi = "N/A";
                    low = "N/A";
                    lnr = "N/A";
                    lct = "N/A";
                    hct = "N/A";
                    hnr = "N/A";
                    break;
                }
                case -64: {
                    byte[] values = this.ipmiSDRCommand.getFullSensorValue(item.getSensorNumber());
                    reading = "N/A";
                    if (values == null) {
                        throw new IPMIException();
                    }
                    if (values != null) {
                        value = values[2];
                        if ((values[1] & 0x20) > 0) {
                            value = 7;
                        }
                        switch (value) {
                            case 0: {
                                reading = "Low";
                                break;
                            }
                            case 1: {
                                reading = "Medium";
                                break;
                            }
                            case 2: {
                                reading = "High";
                                break;
                            }
                            case 4: {
                                reading = "Overheat";
                                break;
                            }
                            default: {
                                reading = "N/A";
                            }
                        }
                    }
                    hi = item.getHiLimit() == 0.0 ? "N/A" : "" + item.getHiLimit();
                    low = item.getLowLimit() == 0.0 ? "N/A" : "" + item.getLowLimit();
                    lnr = item.getLowNR() == 0.0 ? "N/A" : "" + item.getLowNR();
                    lct = item.getLowCT() == 0.0 ? "N/A" : "" + item.getLowCT();
                    hct = item.getHighCT() == 0.0 ? "N/A" : "" + item.getHighCT();
                    String string = hnr = item.getHighNR() == 0.0 ? "N/A" : "" + item.getHighCT();
                }
            }
            if (!ispowerOn) {
                reading = "N/A";
                hi = "N/A";
                low = "N/A";
                lnr = "N/A";
                lct = "N/A";
                hct = "N/A";
                hnr = "N/A";
            }
            boolean failNa = false;
            if (reading.equalsIgnoreCase("N/A") && isAten && ispowerOn && item.isIsValueAvailable() && (item.getHiLimit() != 0.0 || item.getLowLimit() != 0.0) && item.getSensorType() != -63) {
                failNa = true;
            }
            if (showThreshold) {
                if (failNa) {
                    this.addRaw(1, item, "0", lnr, lct, hct, hnr);
                } else {
                    this.addRaw(this.checkSensorValue((byte)value, item), item, reading, lnr, lct, hct, hnr);
                }
            } else if (failNa) {
                this.addRaw(1, this.getSensornameAndNumber(item), "0", low, hi);
            } else {
                this.addRaw(this.checkSensorValue((byte)value, item), this.getSensornameAndNumber(item), reading, low, hi);
            }
            this.hasSensorData = true;
        } else if (item.getSensorType() == 5 || item.getSensorType() == 8 || item.getSensorType() == 21 || item.getSensorType() == 7) {
            byte[] value = this.ipmiSDRCommand.getFullSensorValue(item.getSensorNumber());
            if (value != null && ispowerOn) {
                int status = 0;
                status = value[2] == 0 ? 0 : 1;
                if (item.getSensorType() == 8 && value[2] == 1) {
                    status = 0;
                }
                if (item.getSensorType() == 8 && guid != null && IPMIMessagingCommand.isOSAGUID(guid)) {
                    status = value[2] == 2 ? 0 : (value[2] == 0 ? 1 : 2);
                }
                if (showThreshold) {
                    this.addRaw(status, item, ByteUtility.bytesToHex(value), "N/A", "N/A", "N/A", "N/A");
                } else {
                    this.addRaw(status, this.getSensornameAndNumber(item), ByteUtility.bytesToHex(value), "N/A", "N/A");
                }
            } else if (showThreshold) {
                this.addRaw(2, item, "N/A", "N/A", "N/A", "N/A", "N/A");
            } else {
                this.addRaw(2, this.getSensornameAndNumber(item), "N/A", "N/A", "N/A");
            }
            this.hasSensorData = true;
        } else if (item.getSensorType() == -16 || item.getSensorType() == -15 || item.getSensorType() == -14 || item.getSensorType() == -13) {
            byte value = 0;
            value = this.ipmiSDRCommand.getSensorReading(item.getSensorNumber());
            int status = 0;
            switch (item.getSensorType()) {
                case -16: {
                    if (value == 0) {
                        status = 0;
                        if (showThreshold) {
                            this.addRaw(status, item, "OK", "N/A", "N/A", "N/A", "N/A");
                            break;
                        }
                        this.addRaw(status, this.getSensornameAndNumber(item), "OK", "N/A", "N/A");
                        break;
                    }
                    if (value == 1) {
                        status = 1;
                        if (showThreshold) {
                            this.addRaw(status, item, "Error", "N/A", "N/A", "N/A", "N/A");
                            break;
                        }
                        this.addRaw(status, this.getSensornameAndNumber(item), "Error", "N/A", "N/A");
                        break;
                    }
                    status = 2;
                    if (showThreshold) {
                        this.addRaw(status, item, ByteUtility.byteToHex(value), "N/A", "N/A", "N/A", "N/A");
                        break;
                    }
                    this.addRaw(status, this.getSensornameAndNumber(item), ByteUtility.byteToHex(value), "N/A", "N/A");
                    break;
                }
                case -15: {
                    if (value == 0) {
                        status = 2;
                        if (showThreshold) {
                            this.addRaw(status, item, "Not Presence", "N/A", "N/A", "N/A", "N/A");
                            break;
                        }
                        this.addRaw(status, this.getSensornameAndNumber(item), "Not Presence", "N/A", "N/A");
                        break;
                    }
                    if (value == 1) {
                        status = 0;
                        if (showThreshold) {
                            this.addRaw(status, item, "Presence", "N/A", "N/A", "N/A", "N/A");
                            break;
                        }
                        this.addRaw(status, this.getSensornameAndNumber(item), "Presence", "N/A", "N/A");
                        break;
                    }
                    status = 2;
                    if (showThreshold) {
                        this.addRaw(status, item, ByteUtility.byteToHex(value), "N/A", "N/A", "N/A", "N/A");
                        break;
                    }
                    this.addRaw(status, this.getSensornameAndNumber(item), ByteUtility.byteToHex(value), "N/A", "N/A");
                    break;
                }
                case -14: {
                    if (value == 0) {
                        status = 0;
                        if (showThreshold) {
                            this.addRaw(status, item, "OK", "N/A", "N/A", "N/A", "N/A");
                            break;
                        }
                        this.addRaw(status, this.getSensornameAndNumber(item), "OK", "N/A", "N/A");
                        break;
                    }
                    if (value == 1) {
                        status = 1;
                        if (showThreshold) {
                            this.addRaw(status, item, "Over Temp", "N/A", "N/A", "N/A", "N/A");
                            break;
                        }
                        this.addRaw(status, this.getSensornameAndNumber(item), "Over Temp", "N/A", "N/A");
                        break;
                    }
                    status = 2;
                    if (showThreshold) {
                        this.addRaw(status, item, ByteUtility.byteToHex(value), "N/A", "N/A", "N/A", "N/A");
                        break;
                    }
                    this.addRaw(status, this.getSensornameAndNumber(item), ByteUtility.byteToHex(value), "N/A", "N/A");
                    break;
                }
                case -13: {
                    if (value == 0) {
                        status = 0;
                        if (showThreshold) {
                            this.addRaw(status, item, "OK", "N/A", "N/A", "N/A", "N/A");
                            break;
                        }
                        this.addRaw(status, this.getSensornameAndNumber(item), "OK", "N/A", "N/A");
                        break;
                    }
                    if (value == 1) {
                        status = 2;
                        if (showThreshold) {
                            this.addRaw(status, item, "Warp around", "N/A", "N/A", "N/A", "N/A");
                            break;
                        }
                        this.addRaw(status, this.getSensornameAndNumber(item), "Warp around", "N/A", "N/A");
                        break;
                    }
                    status = 2;
                    if (showThreshold) {
                        this.addRaw(status, item, ByteUtility.byteToHex(value), "N/A", "N/A", "N/A", "N/A");
                        break;
                    }
                    this.addRaw(status, this.getSensornameAndNumber(item), ByteUtility.byteToHex(value), "N/A", "N/A");
                    break;
                }
                default: {
                    if (showThreshold) {
                        this.addRaw(status, item, ByteUtility.byteToHex(value), "N/A", "N/A", "N/A", "N/A");
                        break;
                    }
                    this.addRaw(status, this.getSensornameAndNumber(item), ByteUtility.byteToHex(value), "N/A", "N/A");
                }
            }
            this.hasSensorData = true;
        } else if (item.getSensorType() == 13) {
            byte[] value = this.ipmiSDRCommand.getFullSensorValue(item.getSensorNumber());
            int status = 1;
            String reading = "";
            if (value == null || value.length < 4) {
                status = 2;
                reading = "No reading";
            } else if ((byte)(value[2] & 1) == 1) {
                reading = "Drive Presence";
                status = 0;
            } else if ((byte)(value[2] & 2) == 2) {
                reading = "Drive Fault";
            } else if ((byte)(value[2] & 4) == 4) {
                reading = "Predictive Failure";
            } else if ((byte)(value[2] & 8) == 8) {
                reading = "Hot Spare";
            } else if ((byte)(value[2] & 0x10) == 16) {
                reading = "Consistency Check/Parity Check in progress";
                status = 0;
            } else if ((byte)(value[2] & 0x20) == 32) {
                reading = "In Critical Array";
            } else if ((byte)(value[2] & 0x40) == 64) {
                reading = "In Failed Array";
            } else if ((byte)(value[2] & 0x80) == -128) {
                reading = "Rebuild/Remap in progress";
            } else if ((byte)(value[3] & 1) == 1) {
                reading = "Rebuild/Remap Aborted (was not completed normally)";
            } else if (value[2] == 0 && value[3] == 0) {
                reading = "Not Present";
                status = 2;
            } else {
                reading = "Unknown";
            }
            if (showThreshold) {
                this.addRaw(status, item.getSensorName(), reading);
            } else {
                this.addRawValueOnly(status, this.getSensornameAndNumber(item), reading);
            }
        } else if (item.getSensorType() == 35) {
            byte value = 0;
            value = this.ipmiSDRCommand.getSensorReading(item.getSensorNumber());
            String reading = "";
            switch (value) {
                case 1: {
                    reading = "Tr. to Idle";
                    break;
                }
                case 2: {
                    reading = "Tr. to Active";
                    break;
                }
                case 4: {
                    reading = "Tr. to Busy";
                    break;
                }
                default: {
                    reading = "N/A";
                }
            }
            if (showThreshold) {
                if (reading.equalsIgnoreCase("N/A")) {
                    this.addRaw(2, item, reading, "N/A", "N/A", "N/A", "N/A");
                } else {
                    this.addRaw(0, item, reading, "N/A", "N/A", "N/A", "N/A");
                }
            } else if (reading.equalsIgnoreCase("N/A")) {
                this.addRaw(2, this.getSensornameAndNumber(item), reading, "N/A", "N/A");
            } else {
                this.addRaw(0, this.getSensornameAndNumber(item), reading, "N/A", "N/A");
            }
        }
        return this.hasSensorData;
    }

    public byte getDiscreteOffset(byte sensorNumber) {
        IPMIMessage resMessage = this.ipmiSDRCommand.getSensorReadingCommand(sensorNumber);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[2];
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return -1;
        }
        MessageCenter.getInstance().put(this, (Object)"Cannot execute Get Sensor Reading.");
        return -1;
    }

    private String getSensornameAndNumber(SDRRecord item) {
        String sensorNameAndNumber = "(" + item.getRecordID() + ") " + item.getSensorName();
        return sensorNameAndNumber;
    }

    public int checkSensorValue(byte reading, SDRRecord item) {
        double value;
        if (item.getSensorType() == -64) {
            if (reading == 0 || reading == 1 || reading == 2) {
                return 0;
            }
            if (reading == 4) {
                return 1;
            }
            return 2;
        }
        if (item.getSensorType() == -63) {
            if (reading == 0 || reading == -1) {
                return 2;
            }
            return 0;
        }
        if (item.getSensorType() == 1) {
            if (reading == -128) {
                return 2;
            }
            value = item.calSensorReading(reading);
        } else {
            if (reading == -1 || reading == 0) {
                return 2;
            }
            value = item.calSensorReading(reading & 0xFF);
        }
        double hi = item.getHiLimit();
        double low = item.getLowLimit();
        if (hi == 0.0 && low == 0.0) {
            return 0;
        }
        if (value < hi && value > low) {
            return 0;
        }
        return 1;
    }

    protected void addRaw(int checkedResult, String name, String value) {
        String result = null;
        switch (checkedResult) {
            case 0: {
                result = "OK";
                break;
            }
            case 1: {
                result = "Fail";
                break;
            }
            case 2: {
                result = "";
                break;
            }
            default: {
                result = "Unknown";
            }
        }
        if (GlobalDefine.THERMAL_TEAM_SCRIPT) {
            MOut.G().print(String.format(this.formatTemplateNonThreshold, result, "", "", StringUtil.center(name, 35), StringUtil.center(value, 46)));
        } else {
            MOut.G().print(String.format(this.formatTemplateNonThreshold, result, "", "", name, StringUtil.center(value, 58)));
        }
    }

    protected void addRaw(int checkedResult, String name, String value, String low, String high) {
        String result = null;
        switch (checkedResult) {
            case 0: {
                result = "OK";
                break;
            }
            case 1: {
                result = "Fail";
                break;
            }
            case 2: {
                result = "";
                break;
            }
            default: {
                result = "Unknown";
            }
        }
        MOut.G().print(String.format(this.formatTemplate, result, name, value, low, high));
    }

    protected void addRaw(int checkedResult, SDRRecord item, String value, String lnr, String lct, String hct, String hnr) {
        String result = null;
        switch (checkedResult) {
            case 0: {
                result = "OK";
                break;
            }
            case 1: {
                result = "Fail";
                break;
            }
            case 2: {
                result = "";
                break;
            }
            default: {
                result = "Unknown";
            }
        }
        if (GlobalDefine.THERMAL_TEAM_SCRIPT) {
            byte[] duty = null;
            try {
                duty = this.ipmiSDRCommand.getDutyCycle(item.getSensorNumber());
            }
            catch (Exception exception) {
                // empty catch block
            }
            MOut.G().print(String.format(this.formatTemplateThreshold, result, item.getRecordID(), ByteUtility.byteToHex(item.getSensorNumber()), duty == null ? "N/A" : Byte.valueOf(duty[1]), item.getSensorName(), value, lnr, lct, hct, hnr));
        } else {
            MOut.G().print(String.format(this.formatTemplateThreshold, result, item.getRecordID(), ByteUtility.byteToHex(item.getSensorNumber()), item.getSensorName(), value, lnr, lct, hct, hnr));
        }
    }

    protected void addRawValueOnly(int checkedResult, String name, String value) {
        String result = null;
        switch (checkedResult) {
            case 0: {
                result = "OK";
                break;
            }
            case 1: {
                result = "Fail";
                break;
            }
            case 2: {
                result = "";
                break;
            }
            default: {
                result = "Unknown";
            }
        }
        MOut.G().print(String.format(this.formatTemplateValueOnly, result, name, StringUtil.center(value, 37)));
    }

    protected void addRawValueOnly(int checkedResult, SDRRecord item, String value) {
        String result = null;
        switch (checkedResult) {
            case 0: {
                result = "OK";
                break;
            }
            case 1: {
                result = "Fail";
                break;
            }
            case 2: {
                result = "";
                break;
            }
            default: {
                result = "Unknown";
            }
        }
        if (GlobalDefine.THERMAL_TEAM_SCRIPT) {
            MOut.G().print(String.format(this.formatTemplateNonThreshold, result, item.getRecordID(), ByteUtility.byteToHex(item.getSensorNumber()), StringUtil.center(item.getSensorName(), 35), StringUtil.center(value, 46)));
        } else {
            MOut.G().print(String.format(this.formatTemplateNonThreshold, result, item.getRecordID(), ByteUtility.byteToHex(item.getSensorNumber()), item.getSensorName(), StringUtil.center(value, 58)));
        }
    }

    protected String showCandF(int c) {
        long f = Math.round(1.8 * (double)c + 32.0);
        if (GlobalDefine.THERMAL_TEAM_SCRIPT) {
            return "" + c;
        }
        return c + "C/" + f + "F";
    }
}

