/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMII2CPMBusCommand;
import com.supermicro.ipmi.IPMIPowerSupplyFWUpdater;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMIPSUCheckCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        IPMII2CPMBusCommand ipmiI2CPMBusCommand = new IPMII2CPMBusCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMIPowerSupplyFWUpdater ipmiPowerSupplyFWUpdater = new IPMIPowerSupplyFWUpdater(this.ipmiCMMOEMCommand.getIPMIInterface());
        ipmiI2CPMBusCommand.detectBusID();
        ipmiI2CPMBusCommand.detectSlaveAddress();
        if (ipmiI2CPMBusCommand.getBusID() == 0) {
            MOut.G(this).println("Cannot detect BusID");
            this.statusCode = 147;
            return;
        }
        if (ipmiI2CPMBusCommand.getAvailableSlaveAddrs() == null) {
            MOut.G(this).println("Cannot detect slave address");
            this.statusCode = 147;
            return;
        }
        byte[] slaveAddrs = ipmiI2CPMBusCommand.getAvailableSlaveAddrs();
        for (int i = 0; i < slaveAddrs.length; ++i) {
            boolean result = ipmiPowerSupplyFWUpdater.checkIfSupportFWUpdate(slaveAddrs[i]);
            MOut.G(this).println("[slaveAddress = " + ByteUtility.byteToHex(slaveAddrs[i]) + "h] Support firmware update : " + (result ? "Yes" : "No"));
            if (!result) continue;
            MOut.G(this).println(ipmiPowerSupplyFWUpdater.getPWSInfo(slaveAddrs[i]).toString());
        }
        this.statusCode = 0;
    }
}

