/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.stunnel.StunnelUtility;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMILanIPV6AddCommand
extends SuperBladeCommand {
    int index;
    int prefix = 64;

    @Override
    public boolean preValidate() {
        if (this.parameters == null || this.parameters.length != 2 && this.parameters.length != 3) {
            this.printUsage();
            return false;
        }
        try {
            this.index = Integer.parseInt(this.parameters[0]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("Invalid id");
            return false;
        }
        if (!StunnelUtility.isIPv6(this.parameters[1])) {
            MOut.G(this).println("Not a valid IPv6 address.");
            MOut.G(this).println("You may try standard IPv6 address format:");
            MOut.G(this).println("0000:0000:0000:0000:0000:0000:0000:0000");
            return false;
        }
        if (this.parameters.length == 3) {
            try {
                this.prefix = Integer.parseInt(this.parameters[2]);
            }
            catch (NumberFormatException ex) {
                MOut.G(this).println("Invalid prefix");
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (this.checkIfSystemLockdown()) {
            return;
        }
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ipmiLanCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (ipmiLanCommand.getIPProtocol() == 0) {
            MOut.G(this).println("Current protocol is IPv4 only");
            this.statusCode = 156;
            return;
        }
        int max = ipmiLanCommand.getMaxStaticIPv6Number();
        if (this.index >= max) {
            MOut.G(this).println("ID must < " + (max - 1));
            this.statusCode = 147;
            return;
        }
        String standardIPv6 = this.parameters[1];
        if (!IPMILanCommand.isStandardIPv6Address(this.parameters[1])) {
            standardIPv6 = IPMILanCommand.StandardIPv6Converter(this.parameters[1]);
        }
        if (ipmiLanCommand.addIPv6Address((byte)this.index, standardIPv6, (byte)this.prefix)) {
            MOut.G(this).println("Done");
            this.statusCode = 0;
        } else {
            this.statusCode = 148;
        }
    }

    public void printUsage() {
        MOut.G(this).println("Usage: ipmi lan ipv6 add <id> <ip> [prefix]");
    }
}

