/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIMicroBladeOEMCommand;
import com.supermicro.ipmi.microblade.NodeSensorInfo;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.util.ArrayList;

public class BladeBurstAbstractCommand
extends SuperBladeCommand {
    byte type;
    byte[] b;

    public boolean getBladeIndexes() {
        int i;
        int maxBlade = this.getBladeMaxSize();
        ArrayList<Byte> list = new ArrayList<Byte>();
        for (i = 0; i < this.parameters.length; ++i) {
            try {
                byte value = Byte.parseByte(this.parameters[i]);
                if (value <= 0 || value > maxBlade) continue;
                list.add(value);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (list.size() == 0) {
            return false;
        }
        this.b = new byte[list.size()];
        for (i = 0; i < list.size(); ++i) {
            this.b[i] = (Byte)list.get(i);
        }
        return true;
    }

    public boolean getMicroBladeIndexes() {
        int i;
        ArrayList<Byte> list = new ArrayList<Byte>();
        for (i = 0; i < this.parameters.length; ++i) {
            byte bIndex = (byte)NodeSensorInfo.getBladeIndex(this.parameters[i]);
            if (bIndex == -1) continue;
            list.add(bIndex);
        }
        if (list.size() == 0) {
            return false;
        }
        this.b = new byte[list.size()];
        for (i = 0; i < list.size(); ++i) {
            this.b[i] = (Byte)list.get(i);
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isMicroBladeCMMGUID(guid) || IPMIMessagingCommand.isMicroBladeCMM64MBGUID(guid)) {
            IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
            ipmiMicroBladeOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
            for (int i = 0; i < this.b.length; ++i) {
                try {
                    boolean result = ipmiMicroBladeOEMCommand.cmmBurst(this.b[i], (byte)0, this.type);
                    if (result) continue;
                    MOut.G(this).println("Error happened when executing on blade " + NodeSensorInfo.getBladeIndex(this.b[i]));
                    continue;
                }
                catch (IPMIException e) {
                    MOut.G(this).println("Error happened when executing on blade " + NodeSensorInfo.getBladeIndex(this.b[i]));
                }
            }
            MOut.G(this).println("Done");
            this.statusCode = 0;
            return;
        }
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        try {
            byte result = this.ipmiCMMOEMCommand.burstPowerControl(this.type, this.b);
            if (result == 0) {
                MOut.G(this).println("Done");
                this.statusCode = 0;
            } else if (result == 1) {
                MOut.G(this).println("No enough power");
                this.statusCode = 149;
            } else {
                MOut.G(this).println("Unknown error (" + ByteUtility.byteToHex(result) + "h)");
                this.statusCode = 149;
            }
        }
        catch (IPMIException ex) {
            MOut.G(this).println("Not a supported command");
            this.statusCode = 153;
        }
    }
}

