/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.smbpbi.payload;

import java.nio.ByteBuffer;

public class PayloadSMBPBI {
    public static final int PAYLOAD_SIZE = 4;
    private byte opCode;
    private byte argument1;
    private byte argument2;
    private byte argument3;

    public PayloadSMBPBI() {
        this.opCode = 0;
        this.argument1 = 0;
        this.argument2 = 0;
        this.argument3 = (byte)-128;
    }

    public PayloadSMBPBI(byte code, byte arg1, byte arg2, byte arg3) {
        this.opCode = code;
        this.argument1 = arg1;
        this.argument2 = arg2;
        this.argument3 = arg3;
    }

    public boolean setOPCode(byte code) {
        if ((code & 0xFF) <= 245) {
            this.opCode = code;
            return true;
        }
        return false;
    }

    public boolean setArgument1(byte arg) {
        this.argument1 = arg;
        return true;
    }

    public boolean setArgument2(byte arg) {
        this.argument2 = arg;
        return true;
    }

    public boolean setArgument3(byte arg) {
        if ((arg & 0xFF) == 128) {
            this.argument3 = arg;
            return true;
        }
        return false;
    }

    public byte getOPCode() {
        return this.opCode;
    }

    public byte getArgument1() {
        return this.argument1;
    }

    public byte getArgument2() {
        return this.argument2;
    }

    public byte getArgument3() {
        return this.argument3;
    }

    public ByteBuffer getPayloadByteBuffer() {
        byte[] barry = new byte[]{this.opCode, this.argument1, this.argument2, this.argument3};
        ByteBuffer buffer = ByteBuffer.wrap(barry);
        return buffer;
    }
}

