/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.smbios;

import com.supermicro.ipmi.smbios.TypeStruct;
import java.util.Arrays;
import nn.pp.drvredir.ByteUtility;
import org.apache.commons.lang3.StringUtils;

public class SystemInfo
extends TypeStruct {
    byte[] manufacturer;
    byte[] productName;
    byte[] version;
    byte[] serialNumber;
    byte[] uuid;
    byte[] wakeupType;
    byte[] skuNumber;
    byte[] family;

    public SystemInfo(byte[] dataByte) {
        super(dataByte);
        this.manufacturer = this.getTypeLength(this.BYTE);
        this.productName = this.getTypeLength(this.BYTE);
        this.version = this.getTypeLength(this.BYTE);
        this.serialNumber = this.getTypeLength(this.BYTE);
        this.uuid = this.getTypeLength(16);
        this.wakeupType = this.getTypeLength(this.BYTE);
        this.skuNumber = this.getTypeLength(this.BYTE);
        this.family = this.getTypeLength(this.BYTE);
        this.strFieldCount = 8;
    }

    int getManufacturer() {
        return this.manufacturer[0];
    }

    int getProductName() {
        return this.productName[0];
    }

    int getVersion() {
        return this.version[0];
    }

    int getSerialNumber() {
        return this.serialNumber[0];
    }

    String getUUID() {
        byte[] nodeBytes;
        StringBuffer timeLow = new StringBuffer();
        timeLow.append(ByteUtility.byteToHex((byte)this.uuid[3]));
        timeLow.append(ByteUtility.byteToHex((byte)this.uuid[2]));
        timeLow.append(ByteUtility.byteToHex((byte)this.uuid[1]));
        timeLow.append(ByteUtility.byteToHex((byte)this.uuid[0]));
        StringBuffer timeMid = new StringBuffer();
        timeMid.append(ByteUtility.byteToHex((byte)this.uuid[5]));
        timeMid.append(ByteUtility.byteToHex((byte)this.uuid[4]));
        StringBuffer timeHigh = new StringBuffer();
        timeHigh.append(ByteUtility.byteToHex((byte)this.uuid[7]));
        timeHigh.append(ByteUtility.byteToHex((byte)this.uuid[6]));
        StringBuffer clockHigh = new StringBuffer();
        clockHigh.append(ByteUtility.byteToHex((byte)this.uuid[8]));
        StringBuffer clockLow = new StringBuffer();
        clockLow.append(ByteUtility.byteToHex((byte)this.uuid[9]));
        StringBuffer node = new StringBuffer();
        for (byte nodeByte : nodeBytes = Arrays.copyOfRange(this.uuid, 10, 16)) {
            node.append(ByteUtility.byteToHex((byte)nodeByte));
        }
        String repreUUID = timeLow + "-" + timeMid + "-" + timeHigh + "-" + clockHigh + clockLow + "-" + node;
        return repreUUID;
    }

    String getWakeupType() {
        switch (this.wakeupType[0]) {
            case 0: {
                return "Reserved";
            }
            case 1: {
                return "Other";
            }
            case 2: {
                return "Unknown";
            }
            case 3: {
                return "APM Timer";
            }
            case 4: {
                return "Modem Ring";
            }
            case 5: {
                return "LAN Remote";
            }
            case 6: {
                return "Power Switch";
            }
            case 7: {
                return "PCI PME";
            }
            case 8: {
                return "AC Power Restored";
            }
        }
        return null;
    }

    int getSKUNumber() {
        return this.skuNumber[0];
    }

    int getFamily() {
        return this.family[0];
    }

    @Override
    public String toFormatedHeader() {
        String formatTemplate = " %-30s | %40s \n";
        StringBuffer header = new StringBuffer();
        header.append(String.format("\n", new Object[0]));
        header.append(String.format(formatTemplate, "Item", "Value"));
        header.append(String.format(formatTemplate, "-------------------------", "------------------------------------"));
        return header.toString();
    }

    @Override
    public String toFormatedString() {
        String format = " %-30s | %40s \n";
        StringBuffer fStr = new StringBuffer();
        fStr.append(String.format(format, "Type", (this.type & 0xFF) + " (0x" + this.getType() + ")"));
        fStr.append(String.format(format, "Structure", "System Information"));
        if (this.debug) {
            fStr.append(String.format(format, "Length", (this.length & 0xFF) + " (0x" + this.getLength() + ")"));
            fStr.append(String.format(format, "Handle", "0x" + this.getHandle()));
        }
        fStr.append(String.format(format, "Manufacturer", this.strField[this.getManufacturer()] != null ? this.strField[this.getManufacturer()] : "N/A"));
        fStr.append(String.format(format, "Product Name", this.strField[this.getProductName()] != null ? this.strField[this.getProductName()] : "N/A"));
        fStr.append(String.format(format, "Version", this.strField[this.getVersion()] != null ? this.strField[this.getVersion()] : "N/A"));
        fStr.append(String.format(format, "Serial Number", this.strField[this.getSerialNumber()] != null ? this.strField[this.getSerialNumber()] : "N/A"));
        fStr.append(String.format(format, "UUID", StringUtils.isNotBlank((CharSequence)this.getUUID()) ? this.getUUID() : "N/A"));
        fStr.append(String.format(format, "Wakeup Type", StringUtils.isNotBlank((CharSequence)this.getWakeupType()) ? this.getWakeupType() : "N/A"));
        fStr.append(String.format(format, "SKU Number", StringUtils.isNotBlank((CharSequence)this.strField[this.getSKUNumber()]) ? this.strField[this.getSKUNumber()] : "N/A"));
        fStr.append(String.format(format, "Family", StringUtils.isNotBlank((CharSequence)this.strField[this.getFamily()]) ? this.strField[this.getFamily()] : "N/A"));
        fStr.append(String.format("\n", new Object[0]));
        return fStr.toString();
    }
}

