/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.nm.sensor;

public class SensorThreshold {
    private static final int BIT_MASK_LOWER_NC = 1;
    private static final int BIT_MASK_LOWER_C = 2;
    private static final int BIT_MASK_LOWER_NR = 4;
    private static final int BIT_MASK_UPPER_NC = 8;
    private static final int BIT_MASK_UPPER_C = 16;
    private static final int BIT_MASK_UPPER_NR = 32;
    private static final int OFF_READABLE = 0;
    private static final int OFF_LOWER_NC = 1;
    private static final int OFF_LOWER_C = 2;
    private static final int OFF_LOWER_NR = 3;
    private static final int OFF_UPPER_NC = 4;
    private static final int OFF_UPPER_C = 5;
    private static final int OFF_UPPER_NR = 6;
    private int lowerNC = -1;
    private int lowerC = -1;
    private int lowerNR = -1;
    private int upperNC = -1;
    private int upperC = -1;
    private int upperNR = -1;
    private byte readable;
    private byte[] raw;

    public SensorThreshold(byte[] threshold) {
        this.raw = threshold;
        this.readable = threshold[0];
    }

    public SensorThreshold() {
    }

    public int getLowerNC() {
        if ((this.readable & 1) == 1) {
            this.lowerNC = this.raw[1] & 0xFF;
        }
        return this.lowerNC;
    }

    public int getLowerC() {
        if ((this.readable & 2) == 2) {
            this.lowerC = this.raw[2] & 0xFF;
        }
        return this.lowerC;
    }

    public int getLowerNR() {
        if ((this.readable & 4) == 4) {
            this.lowerNR = this.raw[3] & 0xFF;
        }
        return this.lowerNR;
    }

    public int getUpperNC() {
        if ((this.readable & 8) == 8) {
            this.upperNC = this.raw[4] & 0xFF;
        }
        return this.upperNC;
    }

    public int getUpperC() {
        if ((this.readable & 0x10) == 16) {
            this.upperC = this.raw[5] & 0xFF;
        }
        return this.upperC;
    }

    public int getUpperNR() {
        if ((this.readable & 0x20) == 32) {
            this.upperNR = this.raw[6] & 0xFF;
        }
        return this.upperNR;
    }
}

