/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.nm;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.nm.Common;
import java.util.HashMap;
import java.util.Map;

public class SetTurboSynchronizationRatio {
    private static final Map<String, String> completionCodeToString = new HashMap<String, String>();
    private IPMINM20Command ipmiCommand;
    private byte socketNumber;
    private byte activeCoresConfig;
    private byte turboRatioLimit;

    public SetTurboSynchronizationRatio(IPMINM20Command ipmiCommand, byte socketNumber, byte core, byte turboRatioLimit) {
        this.ipmiCommand = ipmiCommand;
        this.socketNumber = socketNumber;
        this.activeCoresConfig = core;
        this.turboRatioLimit = turboRatioLimit;
    }

    public void execute() throws IPMIException {
        IPMIMessage resMessage = this.ipmiCommand.setTurboSynchronizationRatioCommand(this.socketNumber, this.activeCoresConfig, this.turboRatioLimit);
        if (resMessage != null) {
            if (resMessage.completionCode != 0) {
                throw Common.cCodeToException(completionCodeToString, resMessage);
            }
        } else {
            throw new IPMIException("Call SetTurboSynchronizationRatio failed");
        }
    }

    static {
        completionCodeToString.put("A1", "Wrong CPU socket number.");
        completionCodeToString.put("A2", "Command response timeout.");
        completionCodeToString.put("A4", "Bad read FSC in the response.");
        completionCodeToString.put("A5", "Bad write FCS field in the response.");
        completionCodeToString.put("AC", "CPU not present.");
        completionCodeToString.put("D5", "Platform not in S0/S1 state.");
        completionCodeToString.put("C9", "Incorrect active cores configuration. Unsupported number of active cores.");
        completionCodeToString.put("CC", "When Turbo Ratio Limit out of range.");
        completionCodeToString.put("FF", "Other error encountered.");
    }
}

