/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.microblade;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMicroBladeOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.microblade.BladeRemoteInfo;
import com.supermicro.ipmi.microblade.MicroBladeModuleConfig;
import com.supermicro.ipmi.microblade.NodeRemoteInfo;
import java.util.Observable;

public class MicroBladeInfoManager
extends Observable {
    public String ip;
    public String username;
    public String password;
    public MicroBladeModuleConfig microBladeModuleConfig = new MicroBladeModuleConfig();
    public BladeRemoteInfo[] bladeRemoteInfos;
    private static MicroBladeInfoManager instance = new MicroBladeInfoManager();

    public MicroBladeInfoManager() {
    }

    public MicroBladeInfoManager(String ip, String username, String password) {
        this.ip = ip;
        this.username = username;
        this.password = password;
    }

    public static MicroBladeInfoManager getInstance() {
        return instance;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int[] availableBladeIndex() {
        return null;
    }

    public int firstAvailableBladeIndex() {
        for (int i = 0; i < this.bladeRemoteInfos.length; ++i) {
            if (!this.bladeRemoteInfos[i].isPresent()) continue;
            return i;
        }
        return -1;
    }

    public int nextAvailableBladeIndex(int index) {
        return 0;
    }

    public int prevAvailableBladeIndex(int index) {
        return 0;
    }

    public BladeRemoteInfo getBladeRemoteInfo(int index) {
        return this.bladeRemoteInfos[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getData() {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.ip);
        config.setUserName(this.username);
        config.setPassword(this.password);
        config.setPrivilege((byte)4);
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiMicroBladeOEMCommand);
        if (sessionController == null) {
            return;
        }
        try {
            BladeRemoteInfo[] tempBladeRemoteInfos = ipmiMicroBladeOEMCommand.getAllBladeRemoteInfo(this.microBladeModuleConfig.maxBladeSize);
            MicroBladeInfoManager microBladeInfoManager = this;
            synchronized (microBladeInfoManager) {
                this.bladeRemoteInfos = tempBladeRemoteInfos;
            }
        }
        catch (IPMIException ex1) {
            ex1.printStackTrace();
        }
        sessionController.closeSession();
        this.setChanged();
        this.notifyObservers();
    }

    public static void main(String[] args) {
        MicroBladeInfoManager manager = MicroBladeInfoManager.getInstance();
        manager.setIp("10.133.176.153");
        manager.setUsername("ADMIN");
        manager.setPassword("ADMIN");
        System.out.println("getData() started");
        manager.getData();
        System.out.println("getData() end");
        int index = manager.firstAvailableBladeIndex();
        NodeRemoteInfo nodeRemoteInfo = manager.getBladeRemoteInfo(23).getNodeRemoteInfo(0);
        System.out.println(nodeRemoteInfo.toString());
    }
}

