/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.text.MOut;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

public class PCIeCableDataCommand
extends IPMICommand {
    final byte intelRSDSpec = (byte)4;
    final byte memPageSelect = 0;
    final byte offset = (byte)-60;
    final byte lengthData = (byte)16;
    byte completionCode;
    byte length;
    byte[] cableMemory;
    boolean isLength = false;
    boolean isCableMemory = false;
    int count;
    int found;

    public PCIeCableDataCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public String getLength() {
        return this.length + " (0x" + ByteUtility.byteToHex(this.length) + ")";
    }

    public String getCableMemory() {
        return ByteUtility.bytesToHex(this.cableMemory);
    }

    public String getCableMemoryString() {
        return new String(this.cableMemory);
    }

    public void getPCIeCableData(byte[] slotID, byte portIndex, boolean debug) {
        for (int id = 0; id < ByteUtility.twoBytesToInt(slotID); ++id) {
            Byte index = 0;
            while (index < portIndex) {
                IPMIMessage ipmiMessage = new IPMIMessage();
                ArrayList<Byte> list = new ArrayList<Byte>();
                list.add((byte)4);
                Byte[] slotByte = ArrayUtils.toObject((byte[])PCIeCableDataCommand.intTo2BytesLSB(id));
                ArrayList<Byte> arrayList = new ArrayList<Byte>(Arrays.asList(slotByte));
                list.addAll(arrayList);
                list.add(index);
                list.add((byte)0);
                list.add((byte)-60);
                list.add((byte)16);
                byte[] data = ArrayUtils.toPrimitive((Byte[])list.toArray(new Byte[7]));
                ipmiMessage.setCommandAndData((byte)-80, (byte)55, data);
                IPMIMessage resMessage = this.getIPMIInterface().send(ipmiMessage);
                PCIeCableDataCommand pcieCableData = new PCIeCableDataCommand(this.getIPMIInterface());
                if (resMessage != null) {
                    pcieCableData.completionCode = resMessage.completionCode;
                    switch (this.completionCode) {
                        case -128: {
                            MOut.G().print("PCIe Slot ID specified is invalid (0x80)");
                            break;
                        }
                        case -127: {
                            MOut.G().print("Cable port index specified is invalid (0x81)");
                            break;
                        }
                        case -126: {
                            MOut.G().print("No Cable present for the specified Cable Port Index (0x82)");
                            break;
                        }
                        case -62: {
                            MOut.G().print("No Cabled PCIe ports available in the platform (0xC2)");
                            break;
                        }
                        case -57: {
                            MOut.G().print("Invalid Length (0xC7)");
                            break;
                        }
                        case -44: {
                            MOut.G().print("Insufficient privilege level (0xD4)");
                            break;
                        }
                        case 0: {
                            try {
                                pcieCableData.length = resMessage.data[2];
                                pcieCableData.isLength = true;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                pcieCableData.cableMemory = Arrays.copyOfRange(resMessage.data, 2, resMessage.data.length - 1);
                                pcieCableData.isCableMemory = true;
                                break;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (pcieCableData.length > 0) {
                    MOut.G().print(pcieCableData.toFormatedString(id, index, debug));
                    ++this.found;
                }
                Byte by = index;
                Byte by2 = index = Byte.valueOf((byte)(index + 1));
            }
        }
        if (this.found == 0) {
            String formatTemplate = " %-18s | %1s \n";
            StringBuffer header = new StringBuffer();
            header.append(String.format(formatTemplate, "None", "None"));
            MOut.G().print(header.toString());
        }
    }

    public static byte[] intTo2BytesLSB(int value) {
        byte[] byteArray = new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF)};
        return byteArray;
    }

    public String toFormatedHeader() {
        String formatTemplate = " %-18s | %1s \n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatTemplate, "Item", "Value"));
        header.append(String.format(formatTemplate, "----", "-----"));
        return header.toString();
    }

    public String toFormatedFString(boolean debug) {
        String format = " %-18s | %1s \n";
        StringBuffer fStr = new StringBuffer();
        if (debug) {
            fStr.append(String.format(format, "Length", this.isLength ? this.getLength() : "N/A"));
            fStr.append(String.format(format, "Cable raw data", this.isCableMemory ? this.getCableMemory() : "N/A"));
        }
        fStr.append(String.format(format, "Cable memory data", this.isCableMemory ? this.getCableMemoryString() : "N/A"));
        return fStr.toString();
    }

    public String toFormatedString(int id, byte index, boolean debug) {
        String format = " %-18s | %1s \n";
        StringBuffer fStr = new StringBuffer();
        if (debug) {
            fStr.append(String.format(format, "Length", this.isLength ? this.getLength() : "N/A"));
            fStr.append(String.format(format, "SlotID:" + ByteUtility.byteToHex((byte)id) + " PortIndex:" + ByteUtility.byteToHex(index), this.isCableMemory ? this.getCableMemory() : "N/A"));
        }
        fStr.append(String.format(format, "SlotID:" + ByteUtility.byteToHex((byte)id) + " PortIndex:" + ByteUtility.byteToHex(index), this.isCableMemory ? this.getCableMemoryString() : "N/A"));
        return fStr.toString();
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.5.31");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        PCIeCableDataCommand pcieCableData = new PCIeCableDataCommand(rmcp);
        byte[] slotID = PCIeCableDataCommand.intTo2BytesLSB(15);
        byte portIndex = 4;
        MOut.G().print(pcieCableData.toFormatedHeader());
        pcieCableData.getPCIeCableData(slotID, portIndex, false);
    }
}

