/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

public class CRC8 {
    static final byte[] crcTbl = new byte[256];
    private static char[] hexDigits;

    public static byte crc8(byte[] data) {
        byte crcReg = 0;
        for (int i = 0; i < data.length; ++i) {
            crcReg = crcTbl[(crcReg ^ data[i]) & 0xFF];
        }
        return crcReg;
    }

    private static String hexString(byte b) {
        return hexDigits[0xF & b >> 4] + "" + hexDigits[b & 0xF];
    }

    private static void test(byte[] vec) {
        System.out.println(CRC8.hexString(CRC8.crc8(vec)));
    }

    public static void main(String[] args) {
        CRC8.test(new byte[]{84});
        CRC8.test(new byte[]{3, 115});
        CRC8.test(new byte[]{1, 63});
    }

    static {
        int polynomial = 7;
        for (int i = 0; i < 256; ++i) {
            byte j = (byte)i;
            for (int k = 0; k < 8; ++k) {
                j = (byte)(j < 0 ? j << 1 ^ polynomial : j << 1);
            }
            CRC8.crcTbl[i] = j;
        }
        hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

