/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.cpnm.boot.internal.compression.codec;

import com.cisco.cpnm.boot.internal.compression.codec.Util;
import java.util.Stack;
import java.util.Vector;

public class MoveToFront {
    private static final Byte[] ALPHABET_OBJECTS = new Byte[256];
    private Vector mStack = new Stack();

    public static void main(String[] args) {
        MoveToFront mtf = new MoveToFront();
        byte[] cleartext = new byte[]{2, 2, 1, -32, 0, 2, -128, -55, 15, 117, 3, 2, -63, 1, 0};
        System.out.println("cleartext = ");
        int i = 0;
        while (i < cleartext.length) {
            System.out.print("\t" + cleartext[i]);
            ++i;
        }
        System.out.println();
        byte[] codedtext = mtf.encode(cleartext);
        System.out.println("codedtext = ");
        int i2 = 0;
        while (i2 < codedtext.length) {
            System.out.print("\t" + codedtext[i2]);
            ++i2;
        }
        System.out.println();
        byte[] mtfVector = mtf.toByteArray();
        mtf = new MoveToFront(mtfVector);
        byte[] decodedtext = mtf.decode(codedtext);
        System.out.println("decodedtext = ");
        int i3 = 0;
        while (i3 < decodedtext.length) {
            System.out.print("\t" + decodedtext[i3]);
            ++i3;
        }
        System.out.println();
    }

    public MoveToFront() {
        int ch = 0;
        while (ch < ALPHABET_OBJECTS.length) {
            this.mStack.add(ALPHABET_OBJECTS[ch]);
            ++ch;
        }
    }

    public MoveToFront(byte[] mtf) {
        Byte bObj;
        int i;
        int ch = 0;
        while (ch < ALPHABET_OBJECTS.length) {
            this.mStack.add(ALPHABET_OBJECTS[ch]);
            ++ch;
        }
        try {
            i = 0;
            while (i < mtf.length) {
                bObj = ALPHABET_OBJECTS[(int)Util.unsignedLong(mtf[i])];
                int idx = this.mStack.indexOf(bObj);
                if (idx == -1) {
                    throw new RuntimeException();
                }
                this.mStack.removeElementAt(idx);
                ++i;
            }
            if (this.mStack.size() != 0) {
                throw new RuntimeException();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Argument mtf does not contain exactly the alphabet.");
        }
        this.mStack.clear();
        i = 0;
        while (i < mtf.length) {
            bObj = ALPHABET_OBJECTS[(int)Util.unsignedLong(mtf[i])];
            this.mStack.add(bObj);
            ++i;
        }
    }

    public byte[] encode(byte[] cleartext) {
        byte[] rv = new byte[cleartext.length];
        int i = 0;
        while (i < rv.length) {
            rv[i] = this.encodeSymbol(cleartext[i]);
            ++i;
        }
        return rv;
    }

    public byte[] decode(byte[] codedtext) {
        byte[] rv = new byte[codedtext.length];
        int i = rv.length - 1;
        while (i >= 0) {
            rv[i] = this.decodeSymbol(codedtext[i]);
            --i;
        }
        return rv;
    }

    public byte encodeSymbol(byte b) {
        byte rv = -1;
        int rvInt = -1;
        Byte bObj = ALPHABET_OBJECTS[(int)Util.unsignedLong(b)];
        rvInt = this.mStack.indexOf(bObj);
        if (rvInt == -1) {
            throw new RuntimeException("Couldn't find symbol " + b + " in the MTF queue.\n\r" + this.mStack);
        }
        this.mStack.removeElementAt(rvInt);
        this.mStack.add(0, bObj);
        rv = Util.toSignedByte(rvInt);
        return rv;
    }

    public byte decodeSymbol(byte b) {
        Byte rvObj = (Byte)this.mStack.elementAt(0);
        byte rv = rvObj;
        int newIdx = (int)Util.unsignedLong(b);
        this.mStack.removeElementAt(0);
        this.mStack.add(newIdx, rvObj);
        return rv;
    }

    public byte[] toByteArray() {
        Byte[] byteObjs = this.mStack.toArray(new Byte[0]);
        byte[] rv = new byte[byteObjs.length];
        int i = 0;
        while (i < rv.length) {
            rv[i] = byteObjs[i];
            ++i;
        }
        return rv;
    }

    static {
        int ch = 0;
        while (ch < ALPHABET_OBJECTS.length) {
            MoveToFront.ALPHABET_OBJECTS[ch] = new Byte(Util.toSignedByte(ch));
            ++ch;
        }
    }
}

