<!-- Copyright (c) 2004, 2006-2008 by Cisco Systems, Inc. -->
// smartports.js - Will create the frontPanel for 2950 devices.
// <include a list of SKUs here>

function createDevice(deviceType, uiPortDataArr) {
	var device = null;
   //	alert ("deviceType is:" + deviceType);
   
   	if(deviceType == null)
		return device;
	if((deviceType == "WS-C3560-24PS") || (deviceType == "WS-C3560-24TS")) {
		device = new WSC356024PS(uiPortDataArr);
	} else if ((deviceType == "WS-C3560G-24TS") || (deviceType == "WS-C3560G-24PS")) {
		device = new WSC3560G244(uiPortDataArr);
	} else if ( (deviceType == "WS-C3560G-48TS") || (deviceType == "WS-C3560-48PS") 
			|| (deviceType == "WS-C3560G-48PS") || (deviceType == "WS-C3560-48TS")) {
		device = new WSC3560G484(uiPortDataArr);
	} else if(deviceType == "WS-C3560-8PC") {
		device = new WSC35608PC(uiPortDataArr);	
	} else if(deviceType == "WS-C3560E-24TD" || deviceType == "WS-C3560E-24PD") {
		device = new WSC3560E24(uiPortDataArr);
	} else if(deviceType == "WS-C3560E-48TD" || deviceType == "WS-C3560E-48PD") {
		device = new WSC3560E48(uiPortDataArr);
	}else if(deviceType.indexOf("WS-C3560E-12D") != -1){
		device = new WSC3560E12DS(uiPortDataArr);
	}else if(deviceType.indexOf("WS-C3560E-12SD") != -1){
		device = new WSC3560E12SD(uiPortDataArr);
	}else if(deviceType.indexOf("WS-C3560-12PC-S") != -1){
		device = new WSC356012PCS(uiPortDataArr);
	}
}
/*
 *  This is unit tested.
 */

function WSC3560G484(uiPortDataArr) {
	portCount = uiPortDataArr.length;

	document.writeln('\
				  <tr><td colspan= "36" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')	  
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount-4 ; portId++) {
  		// This is extra space between port 15 and 17
		if( (portId) % 16 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
			}
		}
		
		document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  
		for (var portId = portCount-4; portId < portCount ; portId++) {
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
				document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  
			}
		}				  

		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('\
				  </tr>')
		document.writeln('\
				  <tr><td colspan= "36" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')				  				  
	   document.writeln('\
				  <tr>')
		writeSpaceCell();
								  
	    for (var portId = 0; portId < portCount-4 ; portId++) {
	  		// This is extra space between port 16 and 18
			if( (portId) % 16 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
			}
		}
		document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  
		for (var portId = portCount - 4; portId < portCount ; portId++) {
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
				document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  					
			}
		}
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();                                                  
		document.writeln('\
			  </tr>')
		document.writeln('\
				  <tr><td colspan= "36" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')			
}


/*
 *  This is unit tested.
 */

function WSC3560G244(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "36" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')	  
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount-4 ; portId++) {
  		// This is extra space between port 15 and 17
		if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
			}
		}
		
		document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  
		for (var portId = portCount-4; portId < portCount ; portId++) {
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
				document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  
			}
		}				  

		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('\
				  </tr>')
		document.writeln('\
				  <tr><td colspan= "36" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')				  				  
	   document.writeln('\
				  <tr>')
		writeSpaceCell();
								  
	    for (var portId = 0; portId < portCount-4 ; portId++) {
	  		// This is extra space between port 16 and 18
			if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
			}
		}
		document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  
		for (var portId = portCount - 4; portId < portCount ; portId++) {
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
				document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  					
			}
		}
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();                                                  
		document.writeln('\
			  </tr>')
		document.writeln('\
				  <tr><td colspan= "36" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')			
}


/*
 *  This is unit tested.
 */

function WSC356024PS(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "25" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount -2 ; portId++) {
  		// This is extra space between port 12 and 13
		if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
			}
		}
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		writeSpaceCell();
		
		document.writeln('\
				  </tr>')
	    document.writeln('\
				  <tr><td colspan= "25" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')

	   document.writeln('\
				  <tr>')
		writeSpaceCell();
								  
	    for (var portId = 0; portId < portCount-2 ; portId++) {
	  		// This is extra space between port 12 and 13
			if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
			}
		}
		document.writeln('\
				  <td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>') 
		document.writeln('\
				  <td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>') 
		document.writeln('\
				  <td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>') 				  				   
		for (var portId = portCount - 2; portId < portCount ; portId++) {
			document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>') 				  				   
			document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
		}
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();                                                       
		document.writeln('\
				  </tr>')
	    document.writeln('\
				  <tr><td colspan= "25" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')		
}

function WSC35608PC(uiPortDataArr){
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "30" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	document.writeln('<tr>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
	
		for (var portId=0; portId<portCount-1; portId++) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
	}
	
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();
	for (var portId = portCount-1; portId < portCount ; portId++) {
		document.writeln('\
		<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
		face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
		</font><a href="javascript:void(0)"\
		onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
		onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
		onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
		onMouseUp="window.status=\'\'; return true"\
		onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
		src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
		border="0"\
		width="21" height="21" name="cell', '_', portId, '"></a></td>');
		writeSpaceCell();writeSpaceCell();
	}
	
	writeSpaceCell();writeSpaceCell();
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "28" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}

function WSC356012PCS(uiPortDataArr){
	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "25" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount -1 ; portId++) {
  		// This is extra space between port 12 and 13
		if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
			}
		}
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		writeSpaceCell();
		
		document.writeln('\
				  </tr>')
	    document.writeln('\
				  <tr><td colspan= "25" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')

	   document.writeln('\
				  <tr>')
		writeSpaceCell();
								  
	    for (var portId = 0; portId < portCount-1 ; portId++) {
	  		// This is extra space between port 12 and 13
			if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
			}
		}
		document.writeln('\
				  <td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>') 
		document.writeln('\
				  <td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>') 
		document.writeln('\
				  <td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>') 				  				   
		for (var portId = portCount - 1; portId < portCount ; portId++) {
			document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>') 				  				   
			document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
		}
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();                                                       
		document.writeln('\
				  </tr>')
	    document.writeln('\
				  <tr><td colspan= "25" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')		
}

function WSC3560E24(uiPortDataArr) {
	var MAX_PORTS = 28;
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "32" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	document.writeln('<tr>');
	//document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
	
	for (var portId=0; portId<24; portId++) {
  		// This is extra space between port groups
		if(portId == 11) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Odd numbered ports in first row
		if (portId % 2 == 0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
			}
		}
		
		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		
		var tmp_count = 0;
		for (var portId=portCount-4; portId<portCount; portId++) {
			if(uiPortDataArr[portId].portName.indexOf("/25") > 0 || uiPortDataArr[portId].portName.indexOf("/26") > 0 || (portCount < MAX_PORTS && uiPortDataArr[portId].portName.indexOf("Te") == 0 && uiPortDataArr[portId].portName.indexOf("/1") > 0)) {
				tmp_count++;
				document.writeln('\
						<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
						face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
						</font><a href="javascript:void(0)"\
						onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
						onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
						onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
						onMouseUp="window.status=\'\'; return true"\
						onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
						src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
						border="0"\
					    width="21" height="21" name="cell', '_', portId, '"></a></td>');
				writeSpaceCell();writeSpaceCell();
			}
		}
		
		if(tmp_count == 1 && portCount == 27) {
			document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
			writeSpaceCell();	writeSpaceCell();
		}
		
		writeSpaceCell();writeSpaceCell();writeSpaceCell();
		document.writeln('</tr>');
		
		document.writeln('<tr><td colspan= "32" height="5" bgcolor="#f4f4f4"></td></tr>');
		document.writeln('<tr><td colspan= "32" height="3" bgcolor="#f4f4f4"></td></tr>');
		
		//Second row ports
		document.writeln('<tr>');
		writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
		//document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		
		
		for (var portId=0; portId<24; portId++) {
			// This is extra space between port groups
			if(portId == 12) {
				document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
			}
			//Even numbered ports in second row
			if (portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>');
			}
		}				  

		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		
		var tmp_count = 0;
		for (var portId=portCount-4; portId<portCount; portId++) {
			if(uiPortDataArr[portId].portName.indexOf("/27") > 0 || uiPortDataArr[portId].portName.indexOf("/28") > 0 || (portCount < MAX_PORTS && uiPortDataArr[portId].portName.indexOf("Te") == 0 && uiPortDataArr[portId].portName.indexOf("/2") > 0)) {
				tmp_count++;
				document.writeln('\
						<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
						face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
						</font><a href="javascript:void(0)"\
						onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
						onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
						onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
						onMouseUp="window.status=\'\'; return true"\
						onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
						src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
						border="0"\
					    width="21" height="21" name="cell', '_', portId, '"></a></td>');
				writeSpaceCell();writeSpaceCell();
			}
		}
		
		if(tmp_count == 1 && portCount == 27) {
			document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
			writeSpaceCell();	writeSpaceCell();
		}
		
		writeSpaceCell();writeSpaceCell();writeSpaceCell();
		document.writeln('</tr>');
		document.writeln('<tr><td colspan= "32" height="5" bgcolor="#f4f4f4">');
    	document.writeln('</td></tr>');
}

function WSC3560E48(uiPortDataArr) {
	var MAX_PORTS = 52;
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "50" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	//First row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<48; portId++) {
  		// This is extra space between port groups
		if(portId == 11 || portId == 23 || portId == 35) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}

		//Odd numbered ports in first row
		if ( portId % 2 ==0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	
	var tmp_count = 0;
	for (var portId = portCount-4; portId<portCount ; portId++) {
		if(uiPortDataArr[portId].portName.indexOf("/49") > 0 || uiPortDataArr[portId].portName.indexOf("/50") > 0 || (portCount < MAX_PORTS && uiPortDataArr[portId].portName.indexOf("Te") == 0 && uiPortDataArr[portId].portName.indexOf("/1") > 0)) {
			tmp_count++;
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
				writeSpaceCell();writeSpaceCell();writeSpaceCell();
		}
	}
	
	if(tmp_count == 1 && portCount == 51) {
		document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();writeSpaceCell();writeSpaceCell();
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
		
	//Padding rows
	document.writeln('<tr><td colspan= "50" height="5" bgcolor="#f4f4f4"></td></tr>');
	document.writeln('<tr><td colspan= "50" height="3" bgcolor="#f4f4f4"></td></tr>');
		
	//Second row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<48; portId++) {
		// This is extra space between port groups
		if(portId == 12 || portId == 24 || portId == 36) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Even numbered ports in second row
		if ( portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');

	var tmp_count = 0;
	for (var portId = portCount-4; portId<portCount; portId++) {
		if(uiPortDataArr[portId].portName.indexOf("/51") > 0 || uiPortDataArr[portId].portName.indexOf("/52") > 0 || (portCount < MAX_PORTS && uiPortDataArr[portId].portName.indexOf("Te") == 0 && uiPortDataArr[portId].portName.indexOf("/2") > 0)) {
			tmp_count++;
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
				writeSpaceCell();writeSpaceCell();writeSpaceCell();
		}
	}
	
	if(tmp_count == 1 && portCount == 51) {
		document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();writeSpaceCell();writeSpaceCell();
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "50" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}

function getPortLabel(intName) {
	var intNumber = intName.substring(intName.indexOf('/')+1);
	return parseInt(intNumber)
}

function isExtVlanSupported() {
	return true;
}

function getMaxVlans() {
  	return 250;	
}

function WSC3560E12DS(uiPortDataArr){
	
	portCount = uiPortDataArr.length;
	var intNam = new Array();
	var indxArray = new Array();
	for (var t=0; t< uiPortDataArr.length; t++){
		intNam[t] = uiPortDataArr[t].portName;
		indxArray[uiPortDataArr[t].portName]=t;
	}
	var prtString = "#"+intNam.join('#')+"#";
	document.writeln('<tr><td colspan= "246" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	document.writeln('<tr bgcolor="#f4f4f4">');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
	var portId =0;
	for (var t=1; t<13; t++){
		if(prtString.indexOf("#Te0/"+t+"#")!= -1){
			var prtIndx = "Te0/" + t;
			portId = indxArray[prtIndx];
			document.writeln('\
				<td align="center" width="23" bgcolor="#f4f4f4" valign="top"><font style="font-size:9px"\
				face="Helvetica">X2-', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
				writeSpaceCell();
		}else{
			var prtIndx_1 = "Gi0/"+((t*2)-1);
			portId = indxArray[prtIndx_1];
				document.writeln('\
				<td><table border="0" cellspacing ="0" cellpadding ="0"><tr><td width="21" bgcolor="#f4f4f4" align="center" valign="middle"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td></tr>');
				writeSpaceRow(1);
			
			prtIndx_1 = "Gi0/"+((t*2));
			portId = indxArray[prtIndx_1];
				document.writeln('\
				<tr><td align="center" width="21" bgcolor="#f4f4f4" valign="middle" ><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a><br><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
				</font></td></tr></table></td>');
				writeSpaceCell();		
		}
		}
		writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
		document.writeln('</tr>');
		document.writeln('<tr><td colspan= "246" height="5" bgcolor="#f4f4f4">');
    	document.writeln('</td></tr>');
		
}
function WSC3560E12SD(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "38" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount ; portId++) {
		document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>')
				if(portId == 3 || portId == 7 || portId == 11){
						writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
				}
	}
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('\
		  </tr>')
	document.writeln('\
			  <tr><td colspan= "38" height="9" bgcolor="#f4f4f4">')
	document.writeln('\
			  </td></tr>')					
}
