/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.io.Serializable;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Locale;
import javachart.chart.AxisInterface;
import javachart.chart.Dataset;
import javachart.chart.Gc;
import javachart.chart.Globals;
import javachart.chart.Plotarea;
import javachart.chart.Transform;

public class Axis
implements AxisInterface,
Serializable {
    boolean autoScale = true;
    protected double axisStart = 0.0;
    protected double axisEnd = 10.0;
    boolean majTickVis = true;
    boolean minTickVis = false;
    boolean gridVis = false;
    boolean labelVis = true;
    boolean lineVis = true;
    boolean titleRotation = false;
    String titleString = null;
    Color titleColor;
    Font titleFont = Gc.defaultFont;
    boolean useDisplayList = true;
    Color labelColor;
    Font labelFont = Gc.defaultFont;
    int labelPrecision = 2;
    int labelAngle = 0;
    int labelFormat = 0;
    Gc lineGc;
    Gc gridGc;
    Gc tickGc;
    protected int numMajTicks = 5;
    protected int numGrids = 5;
    protected int numMinTicks = 10;
    protected int numLabels = 5;
    int majTickLength = 5;
    int minTickLength = 2;
    int side = 1;
    boolean logScaling = false;
    Format userFormat = null;
    NumberFormat numberFormat = NumberFormat.getInstance();
    protected Globals globals;
    boolean isXAxis = false;
    boolean barScaling = false;
    protected int numAxLabels = 0;
    protected Dataset[] datasets;
    protected double stepSize = 2.0;
    protected Plotarea plotarea;
    public static final double AUTO_SCALE = Double.NEGATIVE_INFINITY;
    public static final int BOTTOM = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 3;
    public static final int TOP = 2;
    protected Point startPoint;
    protected Point endPoint;
    protected float increment;
    protected static final int axisLabels = 1;
    protected static final int gridLines = 2;
    protected static final int minTicks = 3;
    protected static final int majTicks = 4;
    protected Double userAxisStart = null;
    protected Double userAxisEnd = null;
    final double NODIV = 5.0;
    private int axMagnitude;
    static double[] twoFiveSteps = new double[]{0.0, 0.903, 2.097};
    static double[] oneTwoSteps = new double[]{0.0, 3.01, 4.771, 6.02, 6.989, 7.781000000000001, 8.451, 9.031, 9.542, 10.0};

    public Axis() {
        this(null, false, null);
    }

    public Axis(Dataset[] datasetArray, boolean bl, Plotarea plotarea) {
        this.isXAxis = bl;
        if (this.isXAxis) {
            this.side = 0;
        }
        this.plotarea = plotarea;
        this.datasets = datasetArray;
        this.globals = this.plotarea != null ? this.plotarea.globals : null;
        this.titleColor = Color.black;
        this.labelColor = Color.black;
        this.lineGc = new Gc(this.globals);
        this.gridGc = new Gc(this.globals);
        this.tickGc = new Gc(this.globals);
    }

    public synchronized void addLabels(String[] stringArray) {
    }

    protected void buildDisplayList() {
        switch (this.side) {
            case 0: {
                this.globals.displayList.addRectangle(this, this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY), this.plotarea.transform.point(this.plotarea.urX, 0.0));
                break;
            }
            case 1: {
                this.globals.displayList.addRectangle(this, this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY), this.plotarea.transform.point(0.0, this.plotarea.urY));
                break;
            }
            case 2: {
                this.globals.displayList.addRectangle(this, this.plotarea.transform.point(this.plotarea.llX, this.plotarea.urY), this.plotarea.transform.point(this.plotarea.urX, 1.0));
                break;
            }
            case 3: {
                this.globals.displayList.addRectangle(this, this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY), this.plotarea.transform.point(1.0, this.plotarea.llY));
            }
        }
    }

    private int checkItemQ(int n, int n2, int n3) {
        n = n >= n2 ? n2 : (n >= n3 ? n3 : this.axMagnitude);
        return n;
    }

    private void checkLogAx() {
        this.axisStart = Math.floor(this.axisStart);
        this.axisEnd = Math.ceil(this.axisEnd);
        this.axMagnitude = (int)(this.axisEnd - this.axisStart);
        int n = this.axMagnitude * 10;
        int n2 = this.axMagnitude * 3;
        this.numLabels = this.checkItemQ(this.numLabels, n, n2);
        this.numGrids = this.checkItemQ(this.numGrids, n, n2);
        this.numMinTicks = this.checkItemQ(this.numMinTicks, n, n2);
        this.numMajTicks = this.checkItemQ(this.numMajTicks, n, n2);
    }

    protected synchronized int datasetsInUse() {
        int n = 0;
        while (n < this.datasets.length) {
            if (this.datasets[n] == null) {
                return n;
            }
            ++n;
        }
        return n;
    }

    public synchronized void draw(Graphics graphics) {
        if (this.autoScale) {
            this.scale();
        } else if (this.logScaling) {
            this.checkLogAx();
        }
        if (this.lineVis) {
            this.drawLine(graphics);
        }
        this.drawTicks(graphics);
        if (this.gridVis) {
            if (!this.globals.threeD) {
                this.drawGrids(graphics);
            } else {
                this.draw3Dgrids(graphics);
            }
        }
        if (this.labelVis) {
            this.drawLabels(graphics);
        }
        if (this.useDisplayList && this.globals.useDisplayList) {
            this.buildDisplayList();
        }
    }

    protected void draw3Dgrids(Graphics graphics) {
        this.startPoint = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY);
        this.endPoint = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY);
        switch (this.side) {
            case 0: 
            case 2: {
                this.increment = this.getIncrement(this.endPoint.x, this.startPoint.x, this.numGrids);
                int n = 0;
                while (n < this.numGrids) {
                    this.gridGc.drawLine(graphics, this.whereOnAxis(n, 2), this.startPoint.y, this.whereOnAxis(n, 2) + this.globals.xOffset, this.startPoint.y + this.globals.yOffset);
                    ++n;
                }
                this.gridGc.drawLine(graphics, this.endPoint.x, this.startPoint.y, this.endPoint.x + this.globals.xOffset, this.startPoint.y + this.globals.yOffset);
                n = 0;
                while (n < this.numGrids) {
                    this.gridGc.drawLine(graphics, this.whereOnAxis(n, 2) + this.globals.xOffset, this.startPoint.y + this.globals.yOffset, this.whereOnAxis(n, 2) + this.globals.xOffset, this.endPoint.y + this.globals.yOffset);
                    ++n;
                }
                this.gridGc.drawLine(graphics, this.endPoint.x + this.globals.xOffset, this.startPoint.y + this.globals.yOffset, this.endPoint.x + this.globals.xOffset, this.endPoint.y + this.globals.yOffset);
                break;
            }
            case 1: 
            case 3: {
                this.increment = this.getIncrement(this.endPoint.y, this.startPoint.y, this.numGrids);
                int n = 0;
                while (n < this.numGrids) {
                    this.gridGc.drawLine(graphics, this.startPoint.x, this.whereOnAxis(n, 2), this.startPoint.x + this.globals.xOffset, this.whereOnAxis(n, 2) + this.globals.yOffset);
                    ++n;
                }
                this.gridGc.drawLine(graphics, this.startPoint.x, this.endPoint.y, this.startPoint.x + this.globals.xOffset, this.endPoint.y + this.globals.yOffset);
                n = 0;
                while (n < this.numGrids) {
                    this.gridGc.drawLine(graphics, this.startPoint.x + this.globals.xOffset, this.whereOnAxis(n, 2) + this.globals.yOffset, this.endPoint.x + this.globals.xOffset, this.whereOnAxis(n, 2) + this.globals.yOffset);
                    ++n;
                }
                this.gridGc.drawLine(graphics, this.startPoint.x + this.globals.xOffset, this.endPoint.y + this.globals.yOffset, this.endPoint.x + this.globals.xOffset, this.endPoint.y + this.globals.yOffset);
                break;
            }
        }
    }

    protected void drawGrids(Graphics graphics) {
        this.startPoint = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY);
        this.endPoint = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY);
        switch (this.side) {
            case 0: 
            case 2: {
                this.increment = this.getIncrement(this.endPoint.x, this.startPoint.x, this.numGrids);
                int n = 0;
                while (n < this.numGrids) {
                    this.gridGc.drawLine(graphics, this.whereOnAxis(n, 2), this.startPoint.y, this.whereOnAxis(n, 2), this.endPoint.y);
                    ++n;
                }
                this.gridGc.drawLine(graphics, this.endPoint.x, this.startPoint.y, this.endPoint.x, this.endPoint.y);
                break;
            }
            case 1: 
            case 3: {
                this.increment = this.getIncrement(this.endPoint.y, this.startPoint.y, this.numGrids);
                int n = 0;
                while (n < this.numGrids) {
                    this.gridGc.drawLine(graphics, this.startPoint.x, this.whereOnAxis(n, 2), this.endPoint.x, this.whereOnAxis(n, 2));
                    ++n;
                }
                this.gridGc.drawLine(graphics, this.startPoint.x, this.endPoint.y, this.endPoint.x, this.endPoint.y);
                break;
            }
        }
    }

    protected void drawLabels(Graphics graphics) {
        graphics.setFont(this.labelFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.setColor(this.labelColor);
        int n = 0;
        switch (this.side) {
            case 0: {
                String string;
                this.startPoint = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY);
                int n2 = this.startPoint.y - this.majTickLength - 2;
                this.endPoint = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.llY);
                this.increment = this.getIncrement(this.endPoint.x, this.startPoint.x, this.numLabels);
                double d = (this.axisEnd - this.axisStart) / (double)this.numLabels;
                int n3 = 0;
                while (n3 < this.numLabels) {
                    int n4;
                    string = this.getLabel(this.axisStart + d * (double)n3, n3);
                    this.lineGc.drawSmartString(graphics, this.whereOnAxis(n3, 1), n2, this.side, this.labelAngle, fontMetrics, string);
                    if (this.labelAngle != 0 && (n4 = fontMetrics.stringWidth(string)) > n) {
                        n = n4;
                    }
                    ++n3;
                }
                if (this.barScaling && this.isXAxis) break;
                string = this.getLabel(this.axisEnd, n3);
                this.lineGc.drawSmartString(graphics, this.whereOnAxis(n3, 1), n2, this.side, this.labelAngle, fontMetrics, string);
                break;
            }
            case 1: {
                int n5;
                String string;
                this.startPoint = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY);
                this.endPoint = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.urY);
                this.increment = this.getIncrement(this.endPoint.y, this.startPoint.y, this.numLabels);
                double d = (this.axisEnd - this.axisStart) / (double)this.numLabels;
                int n6 = 0;
                while (n6 < this.numLabels) {
                    string = this.getLabel(this.axisStart + d * (double)n6, n6);
                    int n7 = fontMetrics.stringWidth(string);
                    if (n7 > n) {
                        n = n7;
                    }
                    n5 = this.startPoint.x - this.majTickLength - 2;
                    this.lineGc.drawSmartString(graphics, n5, this.whereOnAxis(n6, 1), this.side, this.labelAngle, fontMetrics, string);
                    ++n6;
                }
                if (this.barScaling && this.isXAxis) break;
                string = this.getLabel(this.axisEnd, n6);
                n5 = this.startPoint.x - this.majTickLength - 2;
                this.lineGc.drawSmartString(graphics, n5, this.whereOnAxis(n6, 1), this.side, this.labelAngle, fontMetrics, string);
                break;
            }
            case 2: {
                int n8;
                String string;
                this.startPoint = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.urY);
                int n9 = this.startPoint.y + this.majTickLength + 2 + fontMetrics.getMaxDescent();
                this.endPoint = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY);
                this.increment = this.getIncrement(this.endPoint.x, this.startPoint.x, this.numLabels);
                double d = (this.axisEnd - this.axisStart) / (double)this.numLabels;
                int n10 = 0;
                while (n10 < this.numLabels) {
                    string = this.getLabel(this.axisStart + d * (double)n10, n10);
                    this.lineGc.drawSmartString(graphics, this.whereOnAxis(n10, 1), n9, this.side, this.labelAngle, fontMetrics, string);
                    ++n10;
                }
                if (this.barScaling && this.isXAxis) break;
                string = this.getLabel(this.axisEnd, n10);
                this.lineGc.drawSmartString(graphics, this.whereOnAxis(n10, 1), n9, this.side, this.labelAngle, fontMetrics, string);
                if (this.labelAngle == 0 || (n8 = fontMetrics.stringWidth(string)) <= n) break;
                n = n8;
                break;
            }
            case 3: {
                String string;
                this.startPoint = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.llY);
                this.endPoint = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY);
                this.increment = this.getIncrement(this.endPoint.y, this.startPoint.y, this.numLabels);
                double d = (this.axisEnd - this.axisStart) / (double)this.numLabels;
                int n11 = this.startPoint.x + this.majTickLength + 2;
                int n12 = 0;
                while (n12 < this.numLabels) {
                    string = this.getLabel(this.axisStart + d * (double)n12, n12);
                    int n13 = fontMetrics.stringWidth(string);
                    if (n13 > n) {
                        n = n13;
                    }
                    this.lineGc.drawSmartString(graphics, n11, this.whereOnAxis(n12, 1), this.side, this.labelAngle, fontMetrics, string);
                    ++n12;
                }
                if (this.barScaling && this.isXAxis) break;
                string = this.getLabel(this.axisEnd, n12);
                n11 = this.startPoint.x + this.majTickLength + 2;
                this.lineGc.drawSmartString(graphics, n11, this.whereOnAxis(n12, 1), this.side, this.labelAngle, fontMetrics, string);
                break;
            }
        }
        if (n == 0) {
            n = fontMetrics.getMaxAscent();
        }
        if (this.titleString != null) {
            this.drawTitle(graphics, n);
        }
    }

    protected void drawLine(Graphics graphics) {
        switch (this.side) {
            case 0: {
                this.lineGc.drawLine(graphics, this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY), this.plotarea.transform.point(this.plotarea.urX, this.plotarea.llY));
                break;
            }
            case 1: {
                this.lineGc.drawLine(graphics, this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY), this.plotarea.transform.point(this.plotarea.llX, this.plotarea.urY));
                break;
            }
            case 2: {
                this.lineGc.drawLine(graphics, this.plotarea.transform.point(this.plotarea.llX, this.plotarea.urY), this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY));
                break;
            }
            case 3: {
                this.lineGc.drawLine(graphics, this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY), this.plotarea.transform.point(this.plotarea.urX, this.plotarea.llY));
            }
        }
    }

    protected void drawTicks(Graphics graphics) {
        int n;
        int n2;
        if (this.majTickVis) {
            switch (this.side) {
                case 0: {
                    this.startPoint = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY);
                    n2 = this.startPoint.y;
                    this.endPoint = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.llY);
                    this.increment = this.getIncrement(this.endPoint.x, this.startPoint.x, this.numMajTicks);
                    n = 0;
                    while (n < this.numMajTicks) {
                        this.tickGc.drawLine(graphics, this.whereOnAxis(n, 4), n2, this.whereOnAxis(n, 4), n2 - this.majTickLength);
                        ++n;
                    }
                    this.tickGc.drawLine(graphics, this.endPoint.x, n2, this.endPoint.x, n2 - this.majTickLength);
                    break;
                }
                case 1: {
                    this.startPoint = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY);
                    n2 = this.startPoint.x;
                    this.endPoint = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.urY);
                    this.increment = this.getIncrement(this.endPoint.y, this.startPoint.y, this.numMajTicks);
                    n = 0;
                    while (n < this.numMajTicks) {
                        this.tickGc.drawLine(graphics, n2, this.whereOnAxis(n, 4), n2 - this.majTickLength, this.whereOnAxis(n, 4));
                        ++n;
                    }
                    this.tickGc.drawLine(graphics, n2, this.endPoint.y, n2 - this.majTickLength, this.endPoint.y);
                    break;
                }
                case 2: {
                    this.startPoint = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.urY);
                    n2 = this.startPoint.y;
                    this.endPoint = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY);
                    this.increment = this.getIncrement(this.endPoint.x, this.startPoint.x, this.numMajTicks);
                    n = 0;
                    while (n <= this.numMajTicks) {
                        this.tickGc.drawLine(graphics, this.whereOnAxis(n, 4), n2, this.whereOnAxis(n, 4), n2 + this.majTickLength);
                        ++n;
                    }
                    this.tickGc.drawLine(graphics, this.endPoint.x, n2, this.endPoint.x, n2 + this.majTickLength);
                    break;
                }
                case 3: {
                    this.startPoint = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.llY);
                    n2 = this.startPoint.x;
                    this.endPoint = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY);
                    this.increment = this.getIncrement(this.endPoint.y, this.startPoint.y, this.numMajTicks);
                    n = 0;
                    while (n <= this.numMajTicks) {
                        this.tickGc.drawLine(graphics, n2, this.whereOnAxis(n, 4), n2 + this.majTickLength, this.whereOnAxis(n, 4));
                        ++n;
                    }
                    this.tickGc.drawLine(graphics, n2, this.endPoint.y, n2 + this.majTickLength, this.endPoint.y);
                    break;
                }
            }
        }
        if (this.minTickVis) {
            switch (this.side) {
                case 0: {
                    this.startPoint = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY);
                    n2 = this.startPoint.y;
                    this.endPoint = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.llY);
                    this.increment = this.getIncrement(this.endPoint.x, this.startPoint.x, this.numMinTicks);
                    n = 0;
                    while (n < this.numMinTicks) {
                        this.tickGc.drawLine(graphics, this.whereOnAxis(n, 3), n2, this.whereOnAxis(n, 3), n2 - this.minTickLength);
                        ++n;
                    }
                    this.tickGc.drawLine(graphics, this.endPoint.x, n2, this.endPoint.x, n2 - this.minTickLength);
                    break;
                }
                case 1: {
                    this.startPoint = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY);
                    n2 = this.startPoint.x;
                    this.endPoint = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.urY);
                    this.increment = this.getIncrement(this.endPoint.y, this.startPoint.y, this.numMinTicks);
                    n = 0;
                    while (n < this.numMinTicks) {
                        this.tickGc.drawLine(graphics, n2, this.whereOnAxis(n, 3), n2 - this.minTickLength, this.whereOnAxis(n, 3));
                        ++n;
                    }
                    this.tickGc.drawLine(graphics, n2, this.endPoint.y, n2 - this.minTickLength, this.endPoint.y);
                    break;
                }
                case 2: {
                    this.startPoint = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.urY);
                    n2 = this.startPoint.y;
                    this.endPoint = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY);
                    this.increment = this.getIncrement(this.endPoint.x, this.startPoint.x, this.numMinTicks);
                    n = 0;
                    while (n < this.numMinTicks) {
                        this.tickGc.drawLine(graphics, this.whereOnAxis(n, 3), n2, this.whereOnAxis(n, 3), n2 + this.minTickLength);
                        ++n;
                    }
                    break;
                }
                case 3: {
                    this.startPoint = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.llY);
                    n2 = this.startPoint.x;
                    this.endPoint = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY);
                    this.increment = this.getIncrement(this.endPoint.y, this.startPoint.y, this.numMinTicks);
                    n = 0;
                    while (n < this.numMinTicks) {
                        this.tickGc.drawLine(graphics, n2, this.whereOnAxis(n, 3), n2 + this.minTickLength, this.whereOnAxis(n, 3));
                        ++n;
                    }
                    this.tickGc.drawLine(graphics, n2, this.endPoint.y, n2 + this.minTickLength, this.endPoint.y);
                    break;
                }
            }
        }
    }

    protected void drawTitle(Graphics graphics, int n) {
        graphics.setFont(this.titleFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.setColor(this.titleColor);
        switch (this.side) {
            case 0: 
            case 2: {
                if (this.labelAngle == 0) break;
                n = (int)((double)n * Math.sin((double)this.labelAngle / 180.0 * Math.PI));
                if (this.labelAngle == 90) break;
                n += 4;
                break;
            }
            case 1: 
            case 3: {
                if (this.labelAngle == 0) break;
                n = (int)((double)n * Math.cos((double)this.labelAngle / 180.0 * Math.PI));
                if (this.labelAngle == 90) break;
                n += 4;
            }
        }
        n = Math.abs(n) + this.majTickLength + 4;
        switch (this.side) {
            case 0: {
                Point point = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY);
                Point point2 = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.llY);
                this.lineGc.drawString(graphics, point.x + (point2.x - point.x) / 2 - fontMetrics.stringWidth(this.titleString) / 2, point.y - n - fontMetrics.getHeight(), this.titleString);
                break;
            }
            case 1: {
                Point point = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY);
                Point point3 = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.urY);
                if (!this.titleRotation) {
                    this.lineGc.drawString(graphics, point.x - fontMetrics.stringWidth(this.titleString) / 2, point3.y + 4, this.titleString);
                    break;
                }
                this.lineGc.drawSmartString(graphics, point.x - n, point.y + (point3.y - point.y) / 2, this.side, 90, fontMetrics, this.titleString);
                break;
            }
            case 2: {
                Point point = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.urY);
                Point point4 = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY);
                this.lineGc.drawString(graphics, point.x + (point4.x - point.x) / 2 - fontMetrics.stringWidth(this.titleString) / 2, point.y + n + 3, this.titleString);
                break;
            }
            case 3: {
                Point point = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.llY);
                Point point5 = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY);
                if (!this.titleRotation) {
                    this.lineGc.drawString(graphics, point.x - fontMetrics.stringWidth(this.titleString) / 2, point5.y + 4, this.titleString);
                    break;
                }
                this.lineGc.drawSmartString(graphics, point.x + n + fontMetrics.getMaxAscent(), point.y + (point5.y - point.y) / 2, this.side, 90, fontMetrics, this.titleString);
                break;
            }
        }
    }

    private String fmtLabel(double d) {
        if (this.userFormat != null) {
            return this.userFormat.format(new Double(d));
        }
        return this.numberFormat.format(d);
    }

    public boolean getAutoScale() {
        return this.autoScale;
    }

    public double getAxisEnd() {
        return this.axisEnd;
    }

    public double getAxisStart() {
        return this.axisStart;
    }

    public boolean getBarScaling() {
        return this.barScaling;
    }

    public Dataset[] getDatasets() {
        return this.datasets;
    }

    public Globals getGlobals() {
        return this.globals;
    }

    public Gc getGridGc() {
        return this.gridGc;
    }

    public boolean getGridVis() {
        return this.gridVis;
    }

    protected float getIncrement(int n, int n2, int n3) {
        return ((float)n - (float)n2) / (float)n3;
    }

    protected String getLabel(double d, int n) {
        if (this.logScaling) {
            return this.getLogLabel(d, n);
        }
        return this.fmtLabel(d);
    }

    public int getLabelAngle() {
        return this.labelAngle;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public Format getLabelFormat() {
        return this.userFormat;
    }

    public int getLabelPrecision() {
        return this.labelPrecision;
    }

    public boolean getLabelVis() {
        return this.labelVis;
    }

    public Gc getLineGc() {
        return this.lineGc;
    }

    public boolean getLineVis() {
        return this.lineVis;
    }

    private String getLogLabel(double d, int n) {
        double d2;
        if (this.numLabels > this.axMagnitude * 3) {
            double d3 = Math.pow(10.0, (double)(n / 10) + this.axisStart);
            int n2 = n % 10;
            d2 = d3 * (double)(n2 + 1);
        } else if (this.numLabels > this.axMagnitude) {
            double d4 = Math.pow(10.0, (double)(n / 3) + this.axisStart);
            int n3 = n % 3;
            switch (n3) {
                case 0: {
                    d2 = d4;
                    break;
                }
                case 1: {
                    d2 = d4 * 2.0;
                    break;
                }
                case 2: {
                    d2 = d4 * 5.0;
                    break;
                }
                default: {
                    d2 = d4;
                    break;
                }
            }
        } else {
            d2 = Math.pow(10.0, this.axisStart + (double)n);
        }
        return this.fmtLabel(d2);
    }

    public boolean getLogScaling() {
        return this.logScaling;
    }

    public int getMajTickLength() {
        return this.majTickLength;
    }

    public boolean getMajTickVis() {
        return this.majTickVis;
    }

    protected double getMaxValsFromData(int n) {
        double d = Double.NEGATIVE_INFINITY;
        if (this.userAxisEnd != null) {
            return this.userAxisEnd;
        }
        if (!this.isXAxis) {
            int n2 = 0;
            while (n2 < n) {
                d = Math.max(d, this.datasets[n2].maxY());
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                d = Math.max(d, this.datasets[n3].maxX());
                ++n3;
            }
        }
        return d;
    }

    public int getMinTickLength() {
        return this.minTickLength;
    }

    public boolean getMinTickVis() {
        return this.minTickVis;
    }

    protected double getMinValsFromData(int n) {
        double d = Double.POSITIVE_INFINITY;
        if (this.userAxisStart != null) {
            return this.userAxisStart;
        }
        if (!this.isXAxis) {
            int n2 = 0;
            while (n2 < n) {
                double d2 = d;
                if ((d = Math.min(d, this.datasets[n2].minY())) == Double.NEGATIVE_INFINITY) {
                    d = d2;
                }
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                double d3 = d;
                if ((d = Math.min(d, this.datasets[n3].minX())) == Double.NEGATIVE_INFINITY) {
                    d = d3;
                }
                ++n3;
            }
        }
        return d;
    }

    private synchronized double getNormalizedIncrement(double d, double d2) {
        if (this.inRange(d, 0.0, 0.1)) {
            return 0.1 * d2;
        }
        if (this.inRange(d, 0.1, 0.25)) {
            return 0.25 * d2;
        }
        if (this.inRange(d, 0.25, 0.5)) {
            return 0.5 * d2;
        }
        if (this.inRange(d, 0.5, 1.0)) {
            return d2;
        }
        if (this.inRange(d, 1.0, 9.0)) {
            return 2.0 * d2;
        }
        return d2;
    }

    public int getNumGrids() {
        return this.numGrids;
    }

    public int getNumLabels() {
        return this.numLabels;
    }

    public int getNumMajTicks() {
        return this.numMajTicks;
    }

    public int getNumMinTicks() {
        return this.numMinTicks;
    }

    public Plotarea getPlotarea() {
        return this.plotarea;
    }

    public int getSide() {
        return this.side;
    }

    public Gc getTickGc() {
        return this.tickGc;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public String getTitleString() {
        return this.titleString;
    }

    public boolean getUseDisplayList() {
        return this.useDisplayList;
    }

    private synchronized boolean inRange(double d, double d2, double d3) {
        return d <= d3 && d >= d2;
    }

    public boolean isTitleRotated() {
        return this.titleRotation;
    }

    public boolean isXAxis() {
        return this.isXAxis;
    }

    private synchronized boolean linearScale() {
        double d;
        double d2 = 9.0E35;
        double d3 = -9.0E35;
        boolean bl = true;
        int n = this.datasetsInUse();
        if (n == 0) {
            return false;
        }
        double d4 = this.getMaxValsFromData(n);
        double d5 = this.getMinValsFromData(n);
        if (n > 1 || this.datasets[0].data.size() > 1) {
            bl = false;
        }
        if (this.barScaling) {
            if (d5 > 0.0) {
                d5 = 0.0;
            }
            if (d4 < 0.0) {
                d4 = 0.0;
            }
        }
        double d6 = (bl || d4 == d5) && this.userAxisStart == null && this.userAxisEnd == null ? (d5 != 0.0 ? Math.abs(d5 * 2.0) : (d4 == 0.0 ? 2.0 : d4)) : d4 - d5;
        double d7 = Transform.log10(d6);
        double d8 = d7 < 0.0 ? Math.pow(10.0, Math.ceil(d7)) : Math.pow(10.0, Math.floor(d7));
        double d9 = d6 / (5.0 * d8);
        this.stepSize = d = this.getNormalizedIncrement(d9, d8);
        d2 = Math.floor(d5 / d) * d;
        while ((d2 += d) <= d5) {
        }
        d3 = d2 -= d;
        while ((d3 += d) < d4) {
        }
        this.axisStart = d2;
        this.axisEnd = d3;
        this.numMajTicks = this.numLabels = (int)((d3 - d2) / this.stepSize);
        this.numGrids = this.numLabels;
        this.numMinTicks = 2 * this.numMajTicks;
        return true;
    }

    private synchronized boolean logScale() {
        int n = this.datasetsInUse();
        if (n == 0) {
            return false;
        }
        double d = this.getMaxValsFromData(n);
        double d2 = this.getMinValsFromData(n);
        if (d <= 0.0 || d2 <= 0.0) {
            return false;
        }
        try {
            this.axisStart = Math.floor(Transform.log10(d2));
            this.axisEnd = Math.ceil(Transform.log10(d));
            this.axMagnitude = (int)(this.axisEnd - this.axisStart);
            if (this.axMagnitude < 2) {
                this.numMajTicks = this.numMinTicks = 10 * this.axMagnitude;
                this.numGrids = this.numMinTicks;
                this.numLabels = this.numMinTicks;
            } else if (this.axMagnitude < 3) {
                this.numGrids = this.numMajTicks = 3 * this.axMagnitude;
                this.numLabels = this.numMajTicks;
                this.numMinTicks = 10 * this.axMagnitude;
            } else {
                this.numMajTicks = this.numMinTicks = this.axMagnitude;
                this.numGrids = this.numMinTicks;
                this.numLabels = this.numMinTicks;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void scale() {
        if (!this.logScaling) {
            this.linearScale();
        } else if (!this.logScale()) {
            this.logScaling = false;
            this.linearScale();
        }
    }

    public void setAutoScale(boolean bl) {
        this.autoScale = bl;
    }

    public void setAxisEnd(double d) {
        if (d == Double.NEGATIVE_INFINITY) {
            this.userAxisEnd = null;
        } else {
            this.userAxisEnd = new Double(d);
            this.axisEnd = d;
        }
    }

    public void setAxisStart(double d) {
        if (d == Double.NEGATIVE_INFINITY) {
            this.userAxisStart = null;
        } else {
            this.axisStart = d;
            this.userAxisStart = new Double(d);
        }
    }

    public void setBarScaling(boolean bl) {
        this.barScaling = bl;
    }

    public void setDatasets(Dataset[] datasetArray) {
        this.datasets = datasetArray;
        if (this.globals == null) {
            return;
        }
        int n = 0;
        while (n < this.datasets.length) {
            if (this.datasets[n] != null && this.datasets[n].globals != this.globals) {
                this.datasets[n].setGlobals(this.globals);
            }
            ++n;
        }
    }

    public void setGlobals(Globals globals) {
        if (globals == null) {
            return;
        }
        this.globals = globals;
        this.lineGc.globals = globals;
        this.tickGc.globals = globals;
        this.gridGc.globals = globals;
        this.plotarea.globals = globals;
        if (this.datasets != null) {
            int n = 0;
            while (n < this.datasets.length) {
                if (this.datasets[n] != null && this.datasets[n].globals != globals) {
                    this.datasets[n].setGlobals(globals);
                }
                ++n;
            }
        }
    }

    public void setGridGc(Gc gc) {
        this.gridGc = gc;
        gc.globals = this.globals;
    }

    public void setGridVis(boolean bl) {
        this.gridVis = bl;
    }

    public void setIsXAxis(boolean bl) {
        this.isXAxis = bl;
    }

    public void setLabelAngle(int n) {
        this.labelAngle = n;
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
    }

    public void setLabelFormat(int n) {
        if (n == 2) {
            this.numberFormat = NumberFormat.getNumberInstance(Locale.FRANCE);
        }
        if (n == 1) {
            this.numberFormat = NumberFormat.getNumberInstance(Locale.US);
        }
        if (n == 0) {
            this.numberFormat = NumberFormat.getNumberInstance();
        }
    }

    public void setLabelFormat(Format format) {
        this.userFormat = format;
    }

    public void setLabelPrecision(int n) {
        this.labelPrecision = n;
        if (n != -1) {
            this.numberFormat.setMinimumFractionDigits(n);
            this.numberFormat.setMaximumFractionDigits(n);
        } else {
            this.numberFormat = NumberFormat.getInstance();
        }
    }

    public void setLabelVis(boolean bl) {
        this.labelVis = bl;
    }

    public void setLineGc(Gc gc) {
        this.lineGc = gc;
        this.lineGc.globals = this.globals;
    }

    public void setLineVis(boolean bl) {
        this.lineVis = bl;
    }

    public void setLogScaling(boolean bl) {
        this.logScaling = bl;
    }

    public void setMajTickLength(int n) {
        this.majTickLength = n;
    }

    public void setMajTickVis(boolean bl) {
        this.majTickVis = bl;
    }

    public void setMinTickLength(int n) {
        this.minTickLength = n;
    }

    public void setMinTickVis(boolean bl) {
        this.minTickVis = bl;
    }

    public void setNumGrids(int n) {
        this.numGrids = n;
    }

    public void setNumLabels(int n) {
        this.numLabels = n;
    }

    public void setNumMajTicks(int n) {
        this.numMajTicks = n;
    }

    public void setNumMinTicks(int n) {
        this.numMinTicks = n;
    }

    public void setPlotarea(Plotarea plotarea) {
        this.plotarea = plotarea;
        if (this.globals == null && plotarea != null) {
            this.globals = plotarea.globals;
        }
    }

    public void setSide(int n) {
        this.side = n;
    }

    public void setTickGc(Gc gc) {
        this.tickGc = gc;
        this.tickGc.globals = this.globals;
    }

    public void setTitleColor(Color color) {
        this.titleColor = color;
    }

    public void setTitleFont(Font font) {
        this.titleFont = font;
    }

    public void setTitleRotated(boolean bl) {
        this.titleRotation = bl;
    }

    public void setTitleString(String string) {
        this.titleString = string;
    }

    public void setUseDisplayList(boolean bl) {
        this.useDisplayList = bl;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + " xAxis? " + this.isXAxis + " stepSize " + this.stepSize + " axisStart " + this.axisStart + " axisEnd " + this.axisEnd + " numMajTicks " + this.numMajTicks + " numMinTicks " + this.numMinTicks + " numLabels " + this.numLabels + " ]";
    }

    protected int whereOnAxis(int n, int n2) {
        if (this.logScaling) {
            return this.whereOnLogAxis(n, n2);
        }
        if (this.side == 0 || this.side == 2) {
            return this.startPoint.x + (int)(this.increment * (float)n);
        }
        return this.startPoint.y + (int)(this.increment * (float)n);
    }

    private int whereOnLogAxis(int n, int n2) {
        boolean bl = false;
        boolean bl2 = false;
        int cfr_ignored_0 = this.axMagnitude * 3;
        int n3 = 0;
        switch (n2) {
            case 1: {
                if (this.numLabels > this.axMagnitude * 3) {
                    bl2 = true;
                    break;
                }
                if (this.numLabels <= this.axMagnitude) break;
                bl = true;
                break;
            }
            case 2: {
                if (this.numGrids > this.axMagnitude * 3) {
                    bl2 = true;
                    break;
                }
                if (this.numGrids <= this.axMagnitude) break;
                bl = true;
                break;
            }
            case 3: {
                if (this.numMinTicks > this.axMagnitude * 3) {
                    bl2 = true;
                    break;
                }
                if (this.numMinTicks <= this.axMagnitude) break;
                bl = true;
                break;
            }
            case 4: {
                if (this.numMajTicks > this.axMagnitude * 3) {
                    bl2 = true;
                    break;
                }
                if (this.numMajTicks <= this.axMagnitude) break;
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        n3 = bl2 ? (int)((double)((float)(n - n % 10) * this.increment) + (double)this.increment * oneTwoSteps[n % 10]) : (bl ? (int)((double)((float)(n - n % 3) * this.increment) + (double)this.increment * twoFiveSteps[n % 3]) : (int)(this.increment * (float)n));
        if (this.side == 0 || this.side == 2) {
            return this.startPoint.x + n3;
        }
        return this.startPoint.y + n3;
    }
}

