/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.cpnm.boot.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class CSIProperties
extends Properties {
    private static final String CSI_PROPERTIES_FILE = ".cms_csi.cfg";
    private boolean existed = false;
    private String propertyFile;

    public CSIProperties() {
        StringBuffer filename = new StringBuffer();
        filename.append(System.getProperty("user.home"));
        filename.append(System.getProperty("file.separator"));
        filename.append(CSI_PROPERTIES_FILE);
        this.propertyFile = filename.toString();
        this.load();
    }

    public boolean existed() {
        return this.existed;
    }

    public boolean isEnabled() {
        Boolean enabled = new Boolean(this.getProperty("enabled", "false"));
        return enabled;
    }

    public void setEnabled(boolean v) {
        if (v) {
            this.setProperty("enabled", "true");
        } else {
            this.setProperty("enabled", "false");
        }
    }

    public String getRepository() {
        return this.getProperty("repository");
    }

    public void setRepository(String v) {
        this.setProperty("repository", v);
    }

    public String getPropertyFileName() {
        return this.propertyFile;
    }

    private void load() {
        try {
            FileInputStream inStream = new FileInputStream(new File(this.propertyFile));
            this.load(inStream);
            this.existed = true;
        }
        catch (IOException ex) {
            if (this.getProperty("enabled") == null) {
                this.setProperty("enabled", "false");
            }
            if (this.getProperty("repository") == null) {
                this.setProperty("repository", this.getDefaultRepositoryName());
            }
            this.existed = false;
        }
    }

    public String getDefaultRepositoryName() {
        StringBuffer repository = new StringBuffer();
        repository.append(System.getProperty("user.home"));
        repository.append("/CiscoCMS");
        return repository.toString();
    }

    public void save() {
        try {
            FileOutputStream outStream = new FileOutputStream(new File(this.propertyFile));
            this.store(outStream, "CMS Client Side Install Properties");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

