/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.cpnm.boot.internal;

import com.cisco.cpnm.boot.internal.BootDebug;
import com.cisco.cpnm.boot.internal.SgzReader;
import com.cisco.cpnm.boot.internal.Verifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

class JarLoader
implements BootDebug {
    private Hashtable _entryTab = new Hashtable();
    private long _bytesRead;
    boolean _isSigned;
    private String _awaitingName;
    private boolean _loadingCompleted;

    JarLoader() {
    }

    static JarLoader New(boolean traceLoading) {
        JarLoader jl = null;
        jl = !traceLoading ? new JarLoader() : new Tracer();
        return jl;
    }

    private int read(InputStream inp, byte[] buf, int ofs, int nofBytes) throws IOException {
        int bytesRead = 0;
        while (nofBytes > 0) {
            int n = inp.read(buf, ofs, nofBytes);
            if (n < 0) break;
            bytesRead += n;
            ofs += n;
            nofBytes -= n;
        }
        this._bytesRead += (long)bytesRead;
        return bytesRead;
    }

    void loadFromStream(InputStream inp, String inpname) {
        if (inpname.endsWith(".sgz")) {
            this.loadFromSgzStream(inp);
        }
    }

    void loadFromSgzStream(InputStream inp) {
        SgzReader sgz = null;
        try {
            String fn;
            sgz = new SgzReader(inp);
            while ((fn = sgz.getNextElement()) != null) {
                byte[] data = sgz.getElementData();
                StoredJarEntry e = new StoredJarEntry();
                e._data = data;
                this.storeEntry(fn, e);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            if (sgz != null) {
                sgz.close();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    synchronized void loadingCompleted() {
        this._loadingCompleted = true;
        if (this._awaitingName != null) {
            this.notify();
            this._awaitingName = null;
        }
    }

    private synchronized void storeEntry(String name, JarEntry entry) {
        if (name.equals("SIG")) {
            if (Verifier.init(entry.getStream())) {
                this._isSigned = true;
                System.out.println("ADP Loader: ADP is signed");
            }
        } else {
            if (this._isSigned && !Verifier.verify(entry._data)) {
                this._isSigned = false;
                System.out.println("ADP Loader: signing failed for " + name);
            }
            if (this._entryTab.get(name) != null) {
                return;
            }
            this._entryTab.put(name, entry);
            if (name.equals(this._awaitingName)) {
                this.notify();
            }
        }
    }

    synchronized JarEntry retrieveEntry(String name) {
        Object o = this._entryTab.get(name);
        if (this._loadingCompleted || o != null) {
            return (JarEntry)o;
        }
        this._awaitingName = name;
        try {
            this.wait();
        }
        catch (Exception ex) {
            // empty catch block
        }
        this._awaitingName = null;
        return (JarEntry)this._entryTab.get(name);
    }

    byte[] getEntryBytes(String name) {
        return this.retrieveEntry(name).getBytes();
    }

    InputStream getEntryStream(String name) {
        return this.retrieveEntry(name).getStream();
    }

    void removeEntry(String name) {
        this._entryTab.remove(name);
    }

    static class DeflatedJarEntry
    extends JarEntry {
        int _uncomprLen;

        DeflatedJarEntry() {
        }

        byte[] getBytes() {
            try {
                byte[] data = new byte[this._uncomprLen];
                InputStream inp = this.getStream();
                int dst = 0;
                while (dst < this._uncomprLen) {
                    int n = inp.read(data, dst, this._uncomprLen - dst);
                    if (n < 0) break;
                    dst += n;
                }
                inp.close();
                return data;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        InputStream getStream() {
            return new InflaterInputStream(new ByteArrayInputStream(this._data), new Inflater(true));
        }
    }

    static class StoredJarEntry
    extends JarEntry {
        StoredJarEntry() {
        }

        byte[] getBytes() {
            return this._data;
        }

        InputStream getStream() {
            return new ByteArrayInputStream(this._data);
        }
    }

    static abstract class JarEntry {
        byte[] _data;

        JarEntry() {
        }

        abstract byte[] getBytes();

        abstract InputStream getStream();
    }

    static class Tracer
    extends JarLoader {
        Vector msgVec = new Vector();

        Tracer() {
        }

        private void appMsg(String method, String msg) {
            String s = "JarLoader." + method + "@" + System.currentTimeMillis() + ": " + msg;
            if (this.msgVec == null) {
                System.out.println(s);
            } else {
                this.msgVec.addElement(s);
            }
        }

        void loadFromStream(InputStream inp, String inpname) {
            this.appMsg("loadFromStream", inpname);
            super.loadFromStream(inp, inpname);
        }

        synchronized JarEntry retrieveEntry(String name) {
            this.appMsg("retrieveEntry", name);
            return super.retrieveEntry(name);
        }

        synchronized void loadingCompleted() {
            super.loadingCompleted();
            this.appMsg("loadingCompleted", "done");
            Enumeration e = this.msgVec.elements();
            while (e.hasMoreElements()) {
                System.out.println(e.nextElement());
            }
            this.msgVec = null;
        }
    }
}

