<!-- Copyright (c) 2004 by Cisco Systems, Inc. -->
// discover.js for c2970 devices.

// c2970 models.
// WS-C2970G-24TS-E, WS-C2970G-24T

function WSC2970G24T(int_status, media_type) {
	var dev = new top.device();

	dev.noofports = 24;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c2970g_24_0.gif";

	drawLeds(dev);

	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 84;
	var xPortStartPos = 147;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) {       
		if(i%2 == 0) {
			yPortCoord = 25;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 41;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }
	
    dev.modes = new Array("STATUS", "DUPLEX", "SPEED");
	return dev;
}



function WSC2970G24TSE(int_status, media_type) {
	var dev = new top.device();

	dev.noofports = 28;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c2970g_24_4.gif";

	drawLeds_smallPanel(dev);
	
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 84;
	var xPortStartPos = 147;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) {       
		if(i%2 == 0) {
			yPortCoord = 40; 
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 56; 
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	// Add the 2 GBIC ports.
	xPortCoord = 549;
	xPortGap = 3;
	for(i=24; i<28; i++) {       
		yPortCoord = 51; 		
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}	
	dev.modes = new Array("STATUS", "DUPLEX", "SPEED");
	return dev;
}

function drawLeds(dev) {

	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/c2970_mode.gif");
	modeBtn.x = 37;
	modeBtn.y = 67;
	modeBtn.height = 9;
	modeBtn.width = 17;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;		

	// Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 26;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 34;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;
		
	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 42;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 50;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 58;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
}


function drawLeds_smallPanel(dev) {

	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/c2970_mode.gif");
	modeBtn.x = 36;
	modeBtn.y = 77;
	modeBtn.height = 9;
	modeBtn.width = 17;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;		

	// Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 42;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 48;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;
		
	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 56;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 63;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 70;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
}


function createDevice(int_status, media_type, deviceType) {
	var device = null;
	if(deviceType == null)
		return device;
	if(deviceType == "WS-C2970G-24TS-E") {
		device = new WSC2970G24TSE(int_status, media_type);
	} else if(deviceType.indexOf ("WS-C2970G-24T") != -1) {
		device = new WSC2970G24T(int_status, media_type);
	} 

	if(device != null) {
		device.type = deviceType;
		device.family = "2970";
	}

	return device;
}
