/**
 Description: Ports Monitoring Controller
 Copyright (c) 2016 by Cisco Systems, Inc.
 All rights reserved.
 */
app.controller('PortsMonitorCtrl', ['$scope','$rootScope','gridCrudService', '$filter','requestRoutingService', '$timeout',
    function ($scope,$rootScope,gridCrudService, $filter,requestRoutingService, $timeout) {

        var translate = $filter("translate");
        angular.extend($scope, {
            currentPort: ''
        });
        var interfaceStatusInfo;
        $scope.showInterfaceStatusInfo = function(){
            interfaceStatusInfo = requestRoutingService.getShowCmdOutput("show interface status", "portsMonStatus");
            interfaceStatusInfo = interfaceStatusInfo.Port.InterfaceStatus.entry;
            interfaceStatusInfo = $filter("filter")(interfaceStatusInfo);
            var portTypeDetails = requestRoutingService.getShowCmdOutput("show running-config", "portsMonPortType");
            portTypeDetails = portTypeDetails.showRun.wnwebdata;
            var vlanIdDetails = new kendo.data.ObservableArray([]);
            for (var i in interfaceStatusInfo) {
                vlanIdDetails.push(interfaceStatusInfo[i].Vlan);
            }

            var deviceInterface=null;
            for (var i in interfaceStatusInfo){
                for (var j in portTypeDetails) {                	
                	deviceInterface=portTypeDetails[j].PortName;
                	if(deviceInterface.indexOf("TenGigabitEthernet")!=-1){
                		deviceInterface=deviceInterface.replace("TenGigabitEthernet","Te")
                	} else if(deviceInterface.indexOf("GigabitEthernet")!=-1){
                		deviceInterface=deviceInterface.replace("GigabitEthernet","Gi")
                	}else if(deviceInterface.indexOf("FastEthernet")!=-1){
                		deviceInterface=deviceInterface.replace("FastEthernet","Fa")
                	}      
                	
                	if(deviceInterface==interfaceStatusInfo[i].Port){
	                    if(portTypeDetails[j].mode === "trunk" || interfaceStatusInfo[i].Vlan=="trunk") {  	
	                    	interfaceStatusInfo[i].PortType = "Trunk";
	                    	interfaceStatusInfo[i].Vlan= portTypeDetails[j].vlan;
	                    } else {
	                    	if(portTypeDetails[j].isRouted==="no"){
	                    		interfaceStatusInfo[i].PortType = "Routed";
	                    		interfaceStatusInfo[i].Vlan=portTypeDetails[j].ipAddress;
	                    	}else{
		                    	if(deviceInterface.indexOf("Fa0")!=-1){
		                    		interfaceStatusInfo[i].PortType = "Routed";
		                    		interfaceStatusInfo[i].Vlan=portTypeDetails[j].ipAddress;
		                    	}else{
		                            interfaceStatusInfo[i].PortType = "Access";
		                    	}
	                      }
	                 }
                  }
                	
                }
                if (interfaceStatusInfo[i].Status == "notconnect") {
                    interfaceStatusInfo[i].Status = "not connected";
                }

            }



            var portsPowerInfo = requestRoutingService.getShowCmdOutput("show power inline", "portsMonPower");
            portsPowerInfo = portsPowerInfo.ShowPowerInline.PowerTable.entry;

            var powerData = new kendo.data.ObservableArray([]);
            for (var c in portsPowerInfo) {
                powerData.push(portsPowerInfo[c].Power);
            }
            powerData.shift();
            for (var d in interfaceStatusInfo) {
                interfaceStatusInfo[d].Power = powerData[d];
            }
            
            //setting the packet drop for each interfaces
            var portsPacketDropInfo = requestRoutingService.getShowCmdOutput("show interfaces", "showInterfaceDetails");
            portsPacketDropInfo = portsPacketDropInfo.ShowInterface.wnwebdata.entry;            
            var deviceInterface=null;
            for (var i in interfaceStatusInfo){
                for (var j in portsPacketDropInfo) {                	
	                	deviceInterface=portsPacketDropInfo[j].interfaceName;
	                	if(deviceInterface.indexOf("TenGigabitEthernet")!=-1){
	                		deviceInterface=deviceInterface.replace("TenGigabitEthernet","Te")
	                	} else if(deviceInterface.indexOf("GigabitEthernet")!=-1){
	                		deviceInterface=deviceInterface.replace("GigabitEthernet","Gi")
	                	}else if(deviceInterface.indexOf("FastEthernet")!=-1){
	                		deviceInterface=deviceInterface.replace("FastEthernet","Fa")
	                	}               	
	                	if(deviceInterface==interfaceStatusInfo[i].Port){
	                		interfaceStatusInfo[i].PktDrop=portsPacketDropInfo[j].totalDrop;
	                	}	                   
                }         
            }                       
          
            var arrTotalInByteInterface=[],arrTotalOutByteInterface=[],arrTotalInByte=[],arrTotalOutByte=[],inBytesCount=0;     
            var strCLIOutput = deviceCommunicator.getExecCmdOutput("show interfaces counters");                       
			var arrRxTxBytes=strCLIOutput.split("\n");	
            for (var i=0; i < arrRxTxBytes.length; i++) {
            	if(arrRxTxBytes[i].indexOf("InOctets")!=-1){
            		inBytesCount=1;
            		continue;
            	}
            	if(arrRxTxBytes[i].indexOf("OutOctets")!=-1){
            		inBytesCount=0;
            		continue;
            	}
				var arrInnerWords = arrRxTxBytes[i].split(" ");				  		    
				for (var k=0,j=1; k < arrInnerWords.length; k++) {			
					if(arrInnerWords[k] == "") {
			 			continue;
		 			}	 				 					
					if (j == 1) {				
						if(inBytesCount==1){
							arrTotalInByteInterface.push(arrInnerWords[k]);
		 				}else{
		 					arrTotalOutByteInterface.push(arrInnerWords[k]);
		 				}			
		 			} else if (j == 2) {
		 				if(inBytesCount==1){
		 					arrTotalInByte.push(arrInnerWords[k]);
		 				}else{
		 					arrTotalOutByte.push(arrInnerWords[k]);
		 				}		 				
		 			} 	 				 					
		 		   	j++;	 	
				}
            }          
            for (var i in interfaceStatusInfo){
            	 for (var j=0; j < arrTotalInByteInterface.length; j++) {               	         	
                	if(arrTotalInByteInterface[j]==interfaceStatusInfo[i].Port){
                		interfaceStatusInfo[i].TxBytes= arrTotalOutByte[j];
                		interfaceStatusInfo[i].RxBytes= arrTotalInByte[j];
                	}
                }
            }
	          
        };
        $scope.showInterfaceStatusInfo();
        $scope.portsDataSource = new kendo.data.DataSource({
            pageSize: 10,
            data: interfaceStatusInfo
        });

        var portsPacketTableInfo = [{
            "PortPackets": translate("ports_monitoring_total")
        }, {
            "PortPackets": translate("ports_monitoring_broadcast")
        }, {
            "PortPackets": translate("ports_monitoring_multicast")
        }, {
            "PortPackets": translate("ports_monitoring_crc_errors")
        }, {
            "PortPackets": translate("ports_monitoring_runts")
        }, {
            "PortPackets": translate("ports_monitoring_errors")
        }];

        var portsStatusTableInfo = [{
            "PortOtherStatus": translate("ports_monitoring_unidirectional_links")
        }, {
            "PortOtherStatus": translate("ports_monitoring_buffer_overflow")
        }, {
            "PortOtherStatus": translate("ports_monitoring_queue_drops")
        }, {
            "PortOtherStatus": translate("ports_monitoring_optics_intserted")
        }, {
            "PortOtherStatus": translate("ports_monitoring_loopback_enabled")
        }];        
        var populateGridData = function(newport){
			$scope.currentPort = newport;
			$rootScope.portNumIdentity = newport;
			if (!$scope.$$phase){
				$scope.$apply();
            }
            var portsInterfacesInfo = requestRoutingService.getShowCmdOutput("show interfaces " + newport, "portsMonShowInterfaces");
            portsInterfacesInfo = portsInterfacesInfo.ShowInterfaces.InterfacesDetail.line;   
            
            var ethernetControllerInfo = deviceCommunicator.getExecCmdOutput("show interfaces "+ newport +" counters ");
            var receiveOctets,receiveUcastPkts,receiveMcastPkts,receiveBcastPkts,sentOctets,sentUcastPkts,sentMcastPkts,sentBcastPkts;
            if(ethernetControllerInfo.indexOf("Counters information is not available")!=-1){
            	receiveOctets="NA",receiveUcastPkts="NA",receiveMcastPkts="NA",receiveBcastPkts="NA",sentOctets="NA",sentUcastPkts="NA",sentMcastPkts="NA",sentBcastPkts="NA";
             }else{
            	var arrPort=ethernetControllerInfo.split("\n");	
    			var dataIn = arrPort[1].split(" ");
    			var dataOut = arrPort[4].split(" ");				
    			
    			for(var index=0,fields=1;index<dataIn.length;index++){					
    				if(dataIn[index] == "")  {
    					continue;		
    				}
    				if(fields == 2){
    					receiveOctets=dataIn[index];
    				} else if (fields == 3){
    					receiveUcastPkts=dataIn[index];
    				} else if(fields == 4){
    					receiveMcastPkts=dataIn[index];
    				} else if(fields == 5){
    					receiveBcastPkts=dataIn[index];
    				}
    				fields++;
    			}								
    			for(var index=0,fields=1;index<dataOut.length;index++){				
    				if(dataOut[index]== "")  {
    					continue;					
    				}
    				if(fields == 2){
    					sentOctets=dataOut[index];
    				} else if (fields == 3){
    					sentUcastPkts=dataOut[index];
    				} else if(fields == 4){
    					sentMcastPkts=dataOut[index];
    				} else if(fields == 5){
    					sentBcastPkts=dataOut[index];
    				}
    				fields++;
    			}
            }
						
		    var counterErrorsInfo= requestRoutingService.getShowCmdOutput("show interfaces "+ newport +" counters errors ", "portsMonCounterErrors");
		    var counterErrorsInfo1 = deviceCommunicator.getExecCmdOutput("show interfaces "+ newport +" counters errors");
		    if(counterErrorsInfo1.indexOf("Counters information is not available")!=-1){
		    	counterErrorsInfo.crcReceived="NA";
	            counterErrorsInfo.runtsReceived="NA";
		    }else{
	            counterErrorsInfo = counterErrorsInfo.Port;
	            counterErrorsInfo.crcReceived=counterErrorsInfo.InterfaceCounters1.entry.crcReceived;
	            counterErrorsInfo.runtsReceived=counterErrorsInfo.InterfaceCounters2.entry.runtsReceived;
            }

            var udldInfo = requestRoutingService.getShowCmdOutput("show udld " + newport, "portsMonUdld");
            udldInfo = udldInfo.ShowUdld.Port;
            
            var sfpInf="Not Present";
            var deviceInterface=null;
            var portsInventoryInfo = requestRoutingService.getShowCmdOutput("show inventory", "portsMonInventory");
            if(portsInventoryInfo.ShowInventory.name){
	            if (portsInventoryInfo.ShowInventory.name.length > 0) {
	               for (var i in portsInventoryInfo.ShowInventory.name) {                	
	                    intname = portsInventoryInfo.ShowInventory.name[i].interfaceName.replace(/\,/g,"");
	                    sfpInfo = portsInventoryInfo.ShowInventory.name[i].sfpInfo.replace(/\,/g,"");
	                    pid = portsInventoryInfo.ShowInventory.name[i].pid.replace(/\,/g,"");
	                    
	                    intname = portsInventoryInfo.ShowInventory.name[i].interfaceName.replace(/"/g,"");
	                    intname = intname.replace(",","");
	                    sfpInfo = portsInventoryInfo.ShowInventory.name[i].sfpInfo.replace(/"/g,"");
	                    pid = portsInventoryInfo.ShowInventory.name[i].pid.replace(/"/g,"");
	                    
	                    deviceInterface=intname;
	                    if(deviceInterface.indexOf("TenGigabitEthernet")!=-1){
	                		deviceInterface=deviceInterface.replace("TenGigabitEthernet","Te")
	                	}else if(deviceInterface.indexOf("GigabitEthernet")!=-1){
	                		deviceInterface=deviceInterface.replace("GigabitEthernet","Gi")
	                	}else if(deviceInterface.indexOf("FastEthernet")!=-1){
	                		deviceInterface=deviceInterface.replace("FastEthernet","Fa")
	                	}      
	                  	                    
	                    if (deviceInterface ==newport){
	                         sfpInf=sfpInfo;
	                    }     
	              }
	            }else{
	            	 intname = portsInventoryInfo.ShowInventory.name.interfaceName.replace(/\,/g,"");
	                 sfpInfo = portsInventoryInfo.ShowInventory.name.sfpInfo.replace(/\,/g,"");
	                 pid     = portsInventoryInfo.ShowInventory.name.pid.replace(/\,/g,"");
	                 
	                 intname = portsInventoryInfo.ShowInventory.name.interfaceName.replace(/"/g,"");
	                 intname = intname.replace(",","");
	                 sfpInfo = portsInventoryInfo.ShowInventory.name.sfpInfo.replace(/"/g,"");
	                 pid     = portsInventoryInfo.ShowInventory.name.pid.replace(/"/g,"");
	                 
	                 deviceInterface=intname;
	                 if(deviceInterface.indexOf("TenGigabitEthernet")!=-1){
	                		deviceInterface=deviceInterface.replace("TenGigabitEthernet","Te")
	                 }else if(deviceInterface.indexOf("GigabitEthernet")!=-1){
	                		deviceInterface=deviceInterface.replace("GigabitEthernet","Gi")
	                 }else if(deviceInterface.indexOf("FastEthernet")!=-1){
	                		deviceInterface=deviceInterface.replace("FastEthernet","Fa")
	                 }      
	                  	                    
	                 if (deviceInterface ==newport){
	                         sfpInf=sfpInfo;
	                 }        
	            }
            }
            portsInterfacesInfo.totalErrors = parseInt(portsInterfacesInfo.inputErrors) + parseInt(portsInterfacesInfo.outputErrors);  
            
            var packetsTotal,broadcastFramesTotalData,multicastFramesTotalData;
            if(receiveOctets=="NA"){
            	packetsTotal="NA";
            	broadcastFramesTotalData="NA";
            	multicastFramesTotalData="NA";
            }else{
            	packetsTotal= parseInt(receiveOctets) + parseInt(sentOctets);
            	broadcastFramesTotalData = parseInt(receiveBcastPkts) + parseInt(sentBcastPkts);
            	multicastFramesTotalData = parseInt(receiveMcastPkts) + parseInt(sentMcastPkts);  
            }
            
            if(udldInfo.uniDirectionalLinks=="Unknown"){
                udldInfo.uniDirectionalLinksState = "Yes";
            }
            else
                udldInfo.uniDirectionalLinksState = "No";

            if(portsInterfacesInfo.loopback =="not set")
                portsInterfacesInfo.loopbackinfo = "No";
            else
                portsInterfacesInfo.loopbackinfo = "Yes";
            
            if(udldInfo==""){            	
            	udldInfo.uniDirectionalLinksState="NA";
            }

            var portsPacketTableInfo = [{
                "PortPackets": translate("ports_monitoring_total"),
                "TotalPackets": packetsTotal,
                "SentPackets": sentOctets,
                "ReceivedPackets":receiveOctets               
            }, {
                "PortPackets": translate("ports_monitoring_broadcast"),
                "TotalPackets": broadcastFramesTotalData,
                "SentPackets": sentBcastPkts,
                "ReceivedPackets": receiveBcastPkts              
            }, {
                "PortPackets": translate("ports_monitoring_multicast"),
                "TotalPackets": multicastFramesTotalData,
                "SentPackets": sentMcastPkts,
                "ReceivedPackets": receiveMcastPkts                
            }, {
                "PortPackets": translate("ports_monitoring_crc_errors"),
                "TotalPackets": portsInterfacesInfo.totalCRC,
                "SentPackets": "NA",
                "ReceivedPackets": counterErrorsInfo.crcReceived
            }, {
                "PortPackets": translate("ports_monitoring_runts"),
                "TotalPackets": portsInterfacesInfo.totalRunts,
                "SentPackets": "NA",
                "ReceivedPackets": counterErrorsInfo.runtsReceived
            }, {
                "PortPackets": translate("ports_monitoring_errors"),
                "TotalPackets": portsInterfacesInfo.totalErrors,
                "SentPackets":portsInterfacesInfo.outputErrors,
                "ReceivedPackets": portsInterfacesInfo.inputErrors
            }];
            angular.element("#portsPacketGrid").data('kendoGrid').dataSource.data([]);
            for (var i=0;i<portsPacketTableInfo.length; i++ ) {
                $scope.portsPacketGrid.dataSource.add({
                    "PortPackets":portsPacketTableInfo[i].PortPackets,
                    "TotalPackets": portsPacketTableInfo[i].TotalPackets,
                    "SentPackets": portsPacketTableInfo[i].SentPackets,
                    "ReceivedPackets": portsPacketTableInfo[i].ReceivedPackets
                });
            }


            var portsStatusTableInfo = [{
                "PortOtherStatus": translate("ports_monitoring_unidirectional_links"),
                "PortStatus": udldInfo.uniDirectionalLinksState
            }, {
                "PortOtherStatus": translate("ports_monitoring_buffer_overflow"),
                "PortStatus": portsInterfacesInfo.outputbuffers
            }, {
                "PortOtherStatus": translate("ports_monitoring_queue_drops"),
                "PortStatus": portsInterfacesInfo.queueDrops
            },  {
                "PortOtherStatus": translate("ports_monitoring_optics_intserted"),
                "PortStatus":sfpInf
            }, {
                "PortOtherStatus": translate("ports_monitoring_loopback_enabled"),
                "PortStatus": portsInterfacesInfo.loopbackinfo
            }];
            angular.element("#portsStatusGrid").data('kendoGrid').dataSource.data([]);
            for (var i=0;i<portsStatusTableInfo.length; i++ ) {
                $scope.portsStatusGrid.dataSource.add({
                    "PortOtherStatus":portsStatusTableInfo[i].PortOtherStatus,
                    "PortStatus": portsStatusTableInfo[i].PortStatus
                });
            }
        };

        function unpopulateGridData(){

            var portsPacketTableInfo = [{
                "PortPackets": translate("ports_monitoring_total"),
                "TotalPackets": "",
                "SentPackets": "",
                "ReceivedPackets":""
            }, {
                "PortPackets": translate("ports_monitoring_broadcast"),
                "TotalPackets": "",
                "SentPackets": "",
                "ReceivedPackets": ""
            }, {
                "PortPackets": translate("ports_monitoring_multicast"),
                "TotalPackets": "",
                "SentPackets": "",
                "ReceivedPackets": ""
            }, {
                "PortPackets": translate("ports_monitoring_crc_errors"),
                "TotalPackets": "",
                "SentPackets": "",
                "ReceivedPackets": ""
            }, {
                "PortPackets": translate("ports_monitoring_runts"),
                "TotalPackets": "",
                "SentPackets": "",
                "ReceivedPackets": ""
            }, {
                "PortPackets": translate("ports_monitoring_errors"),
                "TotalPackets": "",
                "SentPackets":"",
                "ReceivedPackets": ""
            }];
            angular.element("#portsPacketGrid").data('kendoGrid').dataSource.data([]);
            for (var i=0;i<portsPacketTableInfo.length; i++ ) {
                $scope.portsPacketGrid.dataSource.add({
                    "PortPackets":portsPacketTableInfo[i].PortPackets,
                    "TotalPackets": portsPacketTableInfo[i].TotalPackets,
                    "SentPackets": portsPacketTableInfo[i].SentPackets,
                    "ReceivedPackets": portsPacketTableInfo[i].ReceivedPackets
                });
            }


            var portsStatusTableInfo = [{
                "PortOtherStatus": translate("ports_monitoring_unidirectional_links"),
                "PortStatus": ""
            }, {
                "PortOtherStatus": translate("ports_monitoring_buffer_overflow"),
                "PortStatus": ""
            }, {
                "PortOtherStatus": translate("ports_monitoring_queue_drops"),
                "PortStatus": ""
            },  {
                "PortOtherStatus": translate("ports_monitoring_optics_intserted"),
                "PortStatus":""
            }, {
                "PortOtherStatus": translate("ports_monitoring_loopback_enabled"),
                "PortStatus": ""
            }];
            angular.element("#portsStatusGrid").data('kendoGrid').dataSource.data([]);
            for (var i=0;i<portsStatusTableInfo.length; i++ ) {
                $scope.portsStatusGrid.dataSource.add({
                    "PortOtherStatus":portsStatusTableInfo[i].PortOtherStatus,
                    "PortStatus": portsStatusTableInfo[i].PortStatus
                });
            }
        };


        $scope.$on('portSelected', function(event, args) {
            var selectedPort = args.object;
			var nIndex;
			angular.forEach($scope.portsDataSource._data, function($value,$index){
				if($value.Port == selectedPort.uniqueId){
					nIndex = $index;
				}
			});
             //Select the port in the grid
            if(selectedPort!=null) {
                populateGridData(selectedPort.uniqueId);
				var newIndex = (selectedPort.uniqueId).split("/");
				newIndex = newIndex[newIndex.length-1];
				var getcurPage = parseInt($("#portsGrid").find(".k-current-page").text());
				var altIndex;
				if($scope.portsDataSource._pageSize <= 10){
					if(newIndex > 10) altIndex  = newIndex - ( 10 * (getcurPage - 1));
					else altIndex  = nIndex+1;
					if((getcurPage == 1 && newIndex > 10) || (getcurPage != 1 && newIndex < 10)){
						angular.element("#portsGrid").find("tr").removeClass("k-state-selected");
					}
				}
				else{
					altIndex = newIndex;
				}
				angular.element("#portsGrid").find("tr").removeClass("k-state-selected");
				angular.element("#portsGrid").find("tr:eq("+altIndex+")").addClass("k-state-selected");
            }
            else{
            	$scope.currentPort = "";
				$rootScope.portNumIdentity = "";
                unpopulateGridData();
            }    
        });


        var showPortEdit = function () {
            var selected = this.dataItem(this.select());
            if(selected!=null) {
                var newport = selected.Port;
                populateGridData(newport);
            }
            else{
            	$scope.currentPort = "";
				$rootScope.portNumIdentity = "";
                unpopulateGridData();
            }

        };

        $scope.portsPacketDataSource = new kendo.data.DataSource({
            pageSize : 10,
            data : portsPacketTableInfo
        });

        $scope.portsStatusDataSource = new kendo.data.DataSource({
            pageSize : 10,
            data : portsStatusTableInfo
        });

        $scope.portsGridOptions = {
            editable: false,
            sortable: true,
            reorderable: true,
            change: showPortEdit,
            filterable: {
                extra: false,
                operators: {
                    string: {
                    	eq : translate("com_is_equal"),
                        neq : translate("com_isnot_equal")
                    }
                },
                messages : {
		            info: translate("com_page_dropDowntext"),
		            filter: translate("com_btn_filter"),
		            clear: translate("com_btn_clear")
		        }
            },
            scrollable: false,
            selectable: true,
            pageable: {
            	messages: {
					  display: translate("com_page_display"), 
					  empty: translate("com_page_empty"),
					  page: translate("com_page_pagetext"),
					  of:translate("com_page_of"),  
					  itemsPerPage: translate("com_page_itemsPerPage"),
					  first: translate("com_page_first"),
					  previous: translate("com_page_previous"),
					  next: translate("com_page_next"),
					  last: translate("com_page_last"),
					  refresh: translate("com_page_refresh"),
					  morePages: translate("com_page_morePage")
				},
                previousNext: true,
                info: true,
                refresh: true,
                pageSizes: gridCrudService.grid_page_sizes,
                buttonCount: 5
            },
            columns: [{
                field: "Port",
                title: translate("ports_monitoring_description_switchport"),
                width:20
            }, {
                field: "Name",
                title: translate("ports_monitoring_description_desc"),
                width:20
            }, {
                field: "Status",
                title: translate("ports_monitoring_description_status"),
                width:20
            }, {
                field: "PortType",
                title: translate("ports_monitoring_description_porttype"),
                width:20
            }, {
                field: "Vlan",
                title: translate("ports_monitoring_description_vlanip"),
                width:20
            }, {
                field: "Duplex",
                title: translate("ports_monitoring_description_duplex"),
                width:20
            }, {
                field: "Power",
                title: translate("ports_monitoring_description_power"),
                width:20
            }, {
                field: "Speed",
                title: translate("ports_monitoring_description_speed"),
                width:20
            }, {
                field: "TxBytes",
                title: translate("ports_monitoring_description_txbytes"),
                width:20
            }, {
                field: "RxBytes",
                title: translate("ports_monitoring_description_rxbytes"),
                width:20
            }, {
                field: "PktDrop",
                title: translate("ports_monitoring_description_pktdrop"),
                width:20
            }]
        };

        $timeout(function(){
            angular.element("#portsGrid").find('.k-pager-refresh').click(function(){
                $scope.manualGridRefresh();
            });
        },10);
        // Manual refresh the kendo ui grid table
        $scope.manualGridRefresh = function() {
            $scope.showInterfaceStatusInfo();
            var grid = angular.element("#portsGrid").data("kendoGrid");
            $scope.formGridData = new kendo.data.ObservableArray(interfaceStatusInfo);
            $scope.portsDataSource = new kendo.data.DataSource({
                pageSize: 10,
                data: $scope.formGridData
            });
            grid.dataSource = $scope.portsDataSource;
            $scope.portsDataSource.read();
            grid.refresh();
        }

        $scope.portsPacketGridOptions = {
            editable: false,
            sortable: true,
            filterable: {
                extra: false,
                operators: {
                    string: {
                    	eq : translate("com_is_equal"),
                        neq : translate("com_isnot_equal")
                    }
                },
                messages : {
		            info: translate("com_page_dropDowntext"),
		            filter: translate("com_btn_filter"),
		            clear: translate("com_btn_clear")
		        }
            },
            scrollable: false,
            selectable: true,
            columns: [{
                field: "PortPackets",
                title: translate("ports_monitoring_packets")
            }, {
                field: "TotalPackets",
                title: translate("ports_monitoring_total")
            }, {
                field: "SentPackets",
                title: translate("ports_monitoring_sent")
            }, {
                field: "ReceivedPackets",
                title: translate("ports_monitoring_received")
            }]
        };



        $scope.portsStatusGridOptions = {
            editable: false,
            sortable: true,
            filterable: {
                extra: false,
                operators: {
                    string: {
                    	eq : translate("com_is_equal"),
                        neq : translate("com_isnot_equal")
                    }
                },
                messages : {
		            info: translate("com_page_dropDowntext"),
		            filter: translate("com_btn_filter"),
		            clear: translate("com_btn_clear")
		        }
            },
            scrollable: false,
            selectable: true,
            columns: [{
                field: "PortOtherStatus",
                title: translate("ports_monitoring_otherstatus"),
                width: "60%"
            }, {
                field: "PortStatus",
                title: translate("ports_monitoring_status"),
                width: "40%"
            }]
        };
    }
]);
