/**
 Description: Start of Angular application
 Copyright (c) 2016 by Cisco Systems, Inc.
 All rights reserved.
 */
'use strict';

// Make this variable true if running the application locally.
var runFromLocalhost = properties.useLocalData;
var httpServerBasePath = "";
var app = angular.module('webUiDevApp', [
	'ngCookies',
	'ngResource',
	'ngSanitize',
	'ngRoute',
	'angular-wizard',
	'kendo.directives',
	'ngDraggable',
	'ngCsv'
]).config(function ($routeProvider) {
	
	$routeProvider.when('/example2', {
		templateUrl : 'features/common/examples/views/gridView.html',
		controller : 'GridCtrl'
	}).when('/example1', {
		templateUrl : 'features/common/examples/views/tabsView.html',
		controller : 'TabsCtrl'
	}).when('/example3', {
		templateUrl : 'features/common/examples/views/accordionView.html',
		controller : 'AccordionsCtrl'
	}).when('/dashboard', {
		templateUrl : 'features/common/db/dashlet/index.html',
		controller : 'DashletCtrl'
	}).when('/userAdministration', {
		templateUrl : 'features/userAdmin/views/userAdministrationView.html',
		controller : 'UserAdministrationCtrl'
	}).when('/todo', {
		templateUrl : 'features/common/todo/todo.html'
	}).when('/vlan', {
		templateUrl : 'features/vlan/views/vlanView.html',
		controller : 'VlanCtrl'
	}).when('/portsConf', {
		templateUrl : 'features/portsConfig/views/portsConfigView.html',
		controller : 'PortsConfCtrl'
	}).when('/clients', {
		templateUrl : 'features/clients/views/clientsMonitorView.html',
		controller : 'ClientsMonitoring'
	}).when('/portsMonitor', {
		templateUrl : 'features/portsMonitor/views/portsMonitorView.html',
		controller : 'PortsMonitorCtrl'
	}).when('/switch', {
		templateUrl : 'features/stp/views/stpView.html',
		controller : 'StpCtrl'
	}).when('/system', {
		templateUrl : 'features/system/views/systemView.html',
		controller : 'SystemCtrl'
	}).when('/management', {
		templateUrl : 'features/management/views/managementView.html',
		controller : 'ManagementCtrl'
	}).when('/documentation', {
		templateUrl : 'features/help/views/documentationView.html',
		controller : 'helpCtrl'
	}).when('/support', {
		templateUrl : 'features/help/views/supportView.html',
		controller : 'helpCtrl'
	}).when('/softwareUpdate', {
		templateUrl : 'features/common/swupdate/views/swupdate.html',
        controller : 'SWUpdateCtrl'
	}).when('/troubleShoot', {
		templateUrl : 'features/troubleShoot/views/troubleShootView.html',
        controller : 'troubleShootCtrl'
	}).when('/netflow', {
		templateUrl : 'features/netFlow/views/netFlow.html',
        controller : 'netFlowCtrl'
	}).otherwise({
		redirectTo : '/dashboard'
	});
});

app.run(['$rootScope', 'deviceInfoService', function($rootScope, deviceInfoService ) {
	//Initialize the deviceInfo
	deviceInfoService.setDeviceInfo();
}]);

//setting time interval for auto refresh
app.constant("dashletReloadTime", 60000);
