<!-- Copyright (c) 2004 by Cisco Systems, Inc. -->
// discover.js - Will discover 2950 devices.

///////////////////////////////////////////////////////////////////////////////////////////////

function WSC295012(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 12;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c295012.gif";	

	// Construct the Mode button and the system LEDs
	constructModeSysleds_24dev(dev);

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 8;
	var xPortStartPos = 77;
	var xPortCoord = xPortStartPos;
	var yPortCoord = 45;

	// Add the 12 FastEthernet ports in 2 groups of 8 and 4 each.
	for(i=0; i<12; i++) {       
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		if(i == 7) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}
	return dev;	
}

///////////////////////////////////////////////////////////////////////////////////////////////

function WSC295024(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 24;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c295024.gif";	

	// Construct the mode button and the system LEDs
	constructModeSysleds_24dev(dev);
	
	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 8;
	var xPortStartPos = 77;
	var xPortCoord = xPortStartPos;
	var yPortCoord = 45;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) {       
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		if(i == 7 || i == 15) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}
	return dev;	
}

///////////////////////////////////////////////////////////////////////////////////////////////

function WSC2950T24(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 24;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c295024t.gif";	

	// Construct the mode button and the system LEDs
	constructModeSysleds_24dev(dev);
	
	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 8;
	var xPortStartPos = 77;
	var xPortCoord = xPortStartPos;
	var yPortCoord = 45;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) {       
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		if(i == 7 || i == 15) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 10/100/1000BaseT ports.
	xPortCoord = 593;
	xPortGap = 3;
	yPortCoord = 45;
	for(i=24; i<26; i++) {       
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}	
	return dev;	
}

///////////////////////////////////////////////////////////////////////////////////////////////

function WSC2950C24(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 24;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c295024c.gif";	

	// Construct the mode button and the system LEDs
	constructModeSysleds_24dev(dev);
	
	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 8;
	var xPortStartPos = 77;
	var xPortCoord = xPortStartPos;
	var yPortCoord = 45;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) {       
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		if(i == 7 || i == 15) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 100BaseFX ports.
	xPortCoord = 586;
	xPortGap = 21;
	yPortCoord = 45;
	portImages = top.fxportImages();
	for(i=24; i<26; i++) {
		port = new top.fxport(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}	
	return dev;	
}

///////////////////////////////////////////////////////////////////////////////////////////////

function WSC2950SX24(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 24;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c295024sx.gif";	

	// Construct the mode button and the system LEDs
	constructModeSysleds_24dev(dev);
	
	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 8;
	var xPortStartPos = 77;
	var xPortCoord = xPortStartPos;
	var yPortCoord = 45;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) {       
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		if(i == 7 || i == 15) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 100BaseFX ports.
	xPortCoord = 586;
	xPortGap = 21;
	yPortCoord = 45;
	portImages = top.fxportImages();
	for(i=24; i<26; i++) {
		port = new top.fxport(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}	
	return dev;	
}

///////////////////////////////////////////////////////////////////////////////////////////////

function WSC2950G12EI(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 14;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c295012g.gif";	

	// Construct the mode button and the system LEDs
	constructModeSysleds_24dev(dev);
	
	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortStartPos = 87;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 12 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<12; i++) {       
		if(i%2 == 0) {
			yPortCoord = 25;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 41;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 GBIC ports.
	xPortCoord = 470;
	xPortGap = 79;
	portWidth = 36;
	yPortCoord = 41;
	for(i=12; i<14; i++) {       
		port = new top.GBICport(int_status[i][6], portImages); // pass the module type plugged-in the GBIC slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}
	
	return dev;
}

///////////////////////////////////////////////////////////////////////////////////////////////

function WSC2950G24EI(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 26;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c295024g.gif";	

	// Construct the mode button and the system LEDs
	constructModeSysleds_24dev(dev);

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 44;
	var xPortStartPos = 87;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) {
		if(i%2 == 0) {
			yPortCoord = 25;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 41;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 GBIC ports.
	xPortCoord = 470;
	xPortGap = 79;
	portWidth = 36;
	yPortCoord = 41;		
	for(i=24; i<26; i++) {
		port = new top.GBICport(int_status[i][6], portImages); // pass the module type plugged-in the GBIC slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}	
	
	return dev;
}

///////////////////////////////////////////////////////////////////////////////////////////////

function WSC2950G48EI(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 50;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c295048g.gif";	

	// Construct the mode button and the system LEDs
	constructModeSysleds_48dev(dev)

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 11;
	var xPortStartPos = 72;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 3 groups of 16 each.
	for(i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 28;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 44;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==15 || i == 31) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 GBIC ports.
	xPortCoord = 597;
	portWidth = 36;
	for(i=48; i<50; i++) {       
		if (i==48) {
			yPortCoord = 23;
		} else {
			yPortCoord = 50;
		}
		port = new top.GBICport(int_status[i][6], portImages); // pass the module type plugged-in the GBIC slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		dev.addPort(port);
	}	
	
	return dev;
}

///////////////////////////////////////////////////////////////////////////////////////////////

function WSC2950SX48SI(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 50;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c295048sx.gif";	

	// Construct the mode button and the system LEDs
	constructModeSysleds_48dev(dev)

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 11;
	var xPortStartPos = 72;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 3 groups of 16 each.
	for(i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 28;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 44;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==15 || i == 31) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 1000BaseSX ports.
	xPortCoord = 586;
	xPortGap = 21;
	yPortCoord = 45;
	portImages = top.fxportImages();
	for(i=48; i<50; i++) {
		port = new top.fxport(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}
		
	return dev;
}

///////////////////////////////////////////////////////////////////////////////////////////////

function WSC2950T48SI(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 50;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c295048t.gif";	

	// Construct the mode button and the system LEDs
	constructModeSysleds_48dev(dev)

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 11;
	var xPortStartPos = 72;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 3 groups of 16 each.
	for(i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 28;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 44;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==15 || i == 31) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 10/100/1000BaseT ports.
	xPortCoord = 593;
	xPortGap = 3;
	yPortCoord = 45;
	for(i=48; i<50; i++) {       
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}		
	return dev;
}
///////////////////////////////////////////////////////////////////////////////////////////////

function WSC2950ST24LRE(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 26;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c295024lre.gif";	

	// Adjust the interface status table array to follow the
	// same interface order as the show hardware led.
	adjustIntStatusTable(int_status);
	
	// Construct the mode button and the system LEDs
	constructModeSysleds_lre(dev)

	// Create the Ports.
	var port;
	var portWidth = 7;
	var portImages = top.ledImages();
	var compPortImages = top.rj45portImages();
	var xPortGap = 9;
	var xPortGroupGap = 65;
	var xPortStartPos = 102;
	var xPortCoord = xPortStartPos;
	var yPortCoord = 31;

	// Add the 24 LRE ports.
	for(i=0; i<24; i++) {
		port = new top.port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.width = 7;
		port.height = 3;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		if(i==11)
			xPortCoord += (xPortGroupGap - xPortGap);
		dev.addPort(port);
	}

	// Add the 2 10/100/1000BaseT ports.
	xPortCoord = 583;
	xPortGap = 15;
	portWidth = 21;	
	for(i=24; i<26; i++) {       
		port = new top.rj45Compositeport(media_type[i-24],compPortImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}		
	return dev;
}

///////////////////////////////////////////////////////////////////////////////////////////////

function WSC2950ST8LRE(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 10;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c29508lre.gif";	

	// Adjust the interface status table array to follow the
	// same interface order as the show hardware led.
	adjustIntStatusTable(int_status);

	// Construct the mode button and the system LEDs
	constructModeSysleds_lre(dev)

	// Create the Ports.
	var port;
	var portWidth = 7;
	var portImages = top.ledImages();
	var compPortImages = top.rj45portImages();
	var xPortGap = 9;
	var xPortGroupGap = 65;
	var xPortStartPos = 102;
	var xPortCoord = xPortStartPos;
	var yPortCoord = 31;

	// Add the 24 LRE ports.
	for(i=0; i<8; i++) {
		port = new top.port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.width = 7;
		port.height = 3;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}

	// Add the 2 10/100/1000BaseT ports.
	xPortCoord = 583;
	xPortGap = 15;
	portWidth = 21;	
	for(i=8; i<10; i++) {       
		port = new top.rj45Compositeport(media_type[i-8], compPortImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}		
	return dev;
}

///////////////////////////////////////////////////////////////////////////////////////////////

function constructModeSysleds_24dev(dev) {
	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/c295024g_mode.gif");
	modeBtn.x = 16;
	modeBtn.y = 53;
	modeBtn.width = 27;
	modeBtn.height = 12;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;

	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 23;
	tempLed.y = 28;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 33;
	tempLed.y = 28;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 7;
	tempLed.y = 38;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 26;
	tempLed.y = 38;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 45;
	tempLed.y = 38;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
}

///////////////////////////////////////////////////////////////////////////////////////////////

function constructModeSysleds_48dev(dev) {
	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/c295024g_mode.gif");
	modeBtn.x = 23;
	modeBtn.y = 64;
	modeBtn.width = 27;
	modeBtn.height = 12;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;

	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 10;
	tempLed.y = 26;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 10;
	tempLed.y = 33;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 10;
	tempLed.y = 40;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 10;
	tempLed.y = 47;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 10;
	tempLed.y = 54;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
}
///////////////////////////////////////////////////////////////////////////////////////////////

function constructModeSysleds_lre(dev) {
	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/c295024g_mode.gif");
	modeBtn.x = 23;
	modeBtn.y = 64;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;

	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 10;
	tempLed.y = 26;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 10;
	tempLed.y = 34;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 10;
	tempLed.y = 47;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 10;
	tempLed.y = 55;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	// override the modes listed by show hardware led.
	dev.modes = new Array("STATUS", "SPEED");
}

///////////////////////////////////////////////////////////////////////////////////////////////

function adjustIntStatusTable(intStatusTable) {
	var tmpArray = intStatusTable.splice(0,2);
	while(tmpArray.length > 0) {
		intStatusTable.push(tmpArray.shift());
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////

function createDevice(int_status, media_type, deviceType) {
	var device = null;
	
	if(deviceType == null) 
		return device;

	if(deviceType == "WS-C2950-12") {
		device = new WSC295012(int_status, media_type);
	} else if(deviceType == "WS-C2950-24") {
		device = new WSC295024(int_status, media_type);
	} else if(deviceType == "WS-C2950T-24") {
		device = new WSC2950T24(int_status, media_type);
	} else if(deviceType == "WS-C2950C-24") {
		device = new WSC2950C24(int_status, media_type);
	} else if(deviceType == "WS-C2950SX-24") {
		device = new WSC2950SX24(int_status, media_type);
	} else if(deviceType == "WS-C2950G-12-EI") {
		device = new WSC2950G12EI(int_status, media_type);
	} else if(deviceType == "WS-C2950G-24-EI" || deviceType == "WS-C2950G-24-EI-DC") {
		device = new WSC2950G24EI(int_status, media_type);
	} else if(deviceType == "WS-C2950G-48-EI") {
		device = new WSC2950G48EI(int_status, media_type);
	} else if(deviceType == "WS-C2950SX-48-SI") {
		device = new WSC2950SX48SI(int_status, media_type);
	} else if(deviceType == "WS-C2950T-48-SI") {
		device = new WSC2950T48SI(int_status, media_type);
	} else if(deviceType == "WS-C2950ST-24-LRE") {
		device = new WSC2950ST24LRE(int_status, media_type);
	} else if(deviceType == "WS-C2950ST-8-LRE") {
		device = new WSC2950ST8LRE(int_status, media_type);
	}
		
	if(device != null) {
		device.type = deviceType;
		device.family = "2950";
	}

	return device;
}
