/*
 *------------------------------------------------------------------
 * framework.js
 *
 * Copyright (c) 2003, 2004 by cisco Systems, Inc.
 * All rights reserved.
 *------------------------------------------------------------------
 */

// This script should only be included in the top frameset.

// Each page loaded in the mainFrame should 
// set the buttons it needs
// set the FAQ its list, if the page does not have any specific FAQ
// then it should pass an empty list, so that a generic set of FAQs
// will be populated.

// TBD: 
// Finalize whether each wizard step should set its buttons ?
// One way is to let the next step and previous step handlers in 
// each wizard to set the buttons needed.
// Other way is to have a centralized location top.nextStep() and top.previousStep()
// In this case the nextStep and previousStep handlers should return
// a value that can be used to find out whether

// The constants to identify the wizrd steps
var WIZARD_FIRST_STEP = 1;
var WIZARD_STEP		  = 2;
var WIZARD_LAST_STEP  = 3;

// different button constants
var APPLY_BTN	= 1;
var CANCEL_BTN	= 2;
var HELP_BTN	= 4;
var REFRESH_BTN	= 8;
var BACK_BTN	= 16;
var NEXT_BTN	= 32;
var FINISH_BTN	= 64;
var DONE_BTN	= 128;

//button sets for view only pages
var READONLY_BTNS = REFRESH_BTN | HELP_BTN;
// button sets for configurable pages
var CONFIG_BTNS	= APPLY_BTN | CANCEL_BTN | REFRESH_BTN | HELP_BTN;

// buttons set for wizards
var INITSTEP_BTNS = NEXT_BTN | CANCEL_BTN;
var LASTSTEP_BTNS = BACK_BTN | FINISH_BTN | CANCEL_BTN;
var WIZDSTEP_BTNS = BACK_BTN | NEXT_BTN | CANCEL_BTN;

// Will get invoked from the topFrame every one minute
// refresh the content in the mainFrame(content frame) and the FPV
function onAutoRefresh() {	// public
	if(mainFrame.onRefresh) {
		var canRefresh = true;
		if(mainFrame.canAutoRefresh) {
			canRefresh = mainFrame.canAutoRefresh();
		}
		if(canRefresh == true)
			mainFrame.onRefresh()
	}
	if(topFrame.onRefresh) {
		topFrame.onRefresh();
		discoveryFrame.location.href = "discover.shtml";
	}
	if(healthFrame != null)
		healthFrame.location.href = "monitordata.shtml";
}

// Will refresh the content in the mainFrame(content frame) and the FPV
function refreshMainFrame() {	// private
	if(mainFrame.onRefresh)
		mainFrame.onRefresh()
	else
		mainFrame.document.location.reload(true);
	if(topFrame.onRefresh) {
		topFrame.onRefresh();
		discoveryFrame.location.href = "discover.shtml";
	}
	if(healthFrame != null)
		healthFrame.location.href = "monitordata.shtml";
}

// will apply the changes made in the mainFrame to the device
// will call the onConfigure() method in the mainFrame page.
function applyMainFrame() {		// private
	if(mainFrame.onConfigure) {
		mainFrame.onConfigure();
	}
	else {
		alert('No handler available for Apply.');
	}
}

// will cancel the modification done in the config page
// will call the onCancel() method in the mainFrame page.
function cancelMainFrame() {	//private
	if(mainFrame.onCancel) {
		mainFrame.onCancel();
	}
	else {
		alert('No handler available for Cancel.');
	}
}

// Function to invoke print from the Main Frame
function printMainFrame() {
	if(top.mainFrame.printPage) {
		top.mainFrame.printPage();
	} else {
		top.mainFrame.focus();
		window.print();
	}
}

// will launch the help window 
// Will launch the help for the active page in a new window
// The help tag will be obtained from the active page, if tag is not passed.
// The help tag will be the filename with or with out anchor eg. legend.htm#ports, legend.htm
var helpwindow = null;
function showHelp(tag) {	// private
	var helpTag = null;
	// The unique id for the help window, will be created using the mac address
	var windowId;

	if(tag != null) {
		helpTag = tag;
	} else if(mainFrame.getHelpTag) {
		helpTag = mainFrame.getHelpTag();
	} else {
		alert('No Help Available');
		return;
	}
	// store the helptag in the dataCache
	dataCache.put("HELPTAG", helpTag);

	if(helpTag != null || helpTag != "") {
		var devices = getDeviceList();
		if((devices != null) && (devices.length > 0)) {
			windowId = devices[0].macAddress + "_help";
			windowId = windowId.replace(/:/g, "_");
		} else {
			windowId = "_blank";
		}

		var _width = 500, _height = 500;

		if( typeof( window.innerWidth ) == 'number' ) {
			//Non-IE
			_width = window.innerWidth;
			_height = window.innerHeight;
		} else {
			if( document.documentElement &&
			( document.documentElement.clientWidth || document.documentElement.clientHeight ) ) {
				//IE 6+ in 'standards compliant mode'
				_width = document.documentElement.clientWidth;
				_height = document.documentElement.clientHeight;
			} else if( document.body && ( document.body.clientWidth || document.body.clientHeight ) ) {
				//IE 4 compatible
				_width = document.body.clientWidth;
				_height = document.body.clientHeight;
			}
		}
		_width *= 0.7;
		_height *= 0.7;
		_width = Math.ceil(_width);
		_height = Math.ceil(_height);
		
		if(!dataCache.get("SETUPMODE"))
		{
			if(helpTag != "")
			{
				if(helpwindow == null || helpwindow.closed) {
	//				helpwindow = window.open(helpTag, windowId, "toolbar=no,status=no,scrollbars=yes,resizable=yes,outerWidth=" + _width + ",outerHeight=" + _height + ",width=" + _width + ",height=" + _height);
					helpwindow = window.open("/help/help.htm", windowId, "toolbar=no,status=no,scrollbars=yes,resizable=yes,outerWidth=" + _width + ",outerHeight=" + _height + ",width=" + _width + ",height=" + _height);
				} else {
					helpwindow.displayHelp(helpTag);
				}
				if(helpwindow)
					helpwindow.focus();
			}
		}
		else
		{
			var helpwindow2 = window.open("/help/xsetup_help.htm", windowId + "xsetup", "toolbar=no,status=no,scrollbars=yes,resizable=yes,outerWidth=" + _width + ",outerHeight=" + _height + ",width=" + _width + ",height=" + _height);
			if(helpwindow2)
					helpwindow2.focus();
		}
	}	
	
}

// return the helpTag for which the help dialog is opened
// This method is the call back used by the Help farmework (helpframework.js) 
// to obtain the helpTag(filename).
function getActiveHelpTag() {
	return dataCache.get("HELPTAG");
}

// function that will take care of moving to the next step of wizard
// will call the onNextStep() in mainFrame
// onNextStep() method should set the necessary buttons for the next step.
function nextStep() {	// private
	if(mainFrame.onNextStep) {
		mainFrame.onNextStep();
	}
	else {
		alert('No handler available for Next.');
	}
	return;
}

// function that will take care of moving to the previous step of wizard
// will call the onPreviousStep() in mainFrame
// onPreviousStep() method should set the necessary buttons for the next step.
function previousStep() {	// private
	if(mainFrame.onPreviousStep) {
		mainFrame.onPreviousStep();
	}
	else {
		alert('No handler available for Back.' );
	}
	return;
}

// function that will take care of applying the configuration in wizard
// will call the onConfigure() in mainFrame
function wizardFinish() {	// private
	if(mainFrame.onFinish) {
		mainFrame.onFinish();
	}
	else {
		alert('No handler available for Finish.');
	}
}

// Will update the faq links on the top right corner of top frame.
// faqList should be a list of FAQ objects.
function setFaq(faqList) {	// public

	if(faqList == null) {
		faqList = dataCache.get("CURRENTFAQS");
	}
	if(faqList == null || faqList.length < 0)
		return false;
	dataCache.put("CURRENTFAQS", faqList);
	if(topFrame.setFaq) {
		topFrame.setFaq(faqList);
	}
}

// Will update the faq combo box with the default set of FAQs
// As of now the FPV related FAQ is the only FAQ which is to
// be displayed everytime, and the default one. This will be
// added by the topbanner.htm. So pass an empty list.
function setDefaultFaq() { // public
	setFaq(new Array());
}

// Will take to the selected FAQ
// The value of the faq item should be the helpTag, which will be the
// help filename with anchor if needed. eg. index.htm#ports
function showFAQ(faq) {	// private
	if(faq.value && faq.value != "no_action"){}
}

// Will show/hide the bottomFrame according to the value of the parameter show
// Will show the frame if show is true, otherwise hide.
function showButtonFrame(show) {
	if(!top.contentFrameset || !top.contentFrameset.rows)
		return;
	if(show === true) {
		top.contentFrameset.rows = "*,40";
	} else {
		top.contentFrameset.rows = "*,0";
	}
}

// will set the buttons in the bottom panel.
// buttonSet will be an integer where each bit will stand for a button
// The following values can be passed as the value to setButtons
// READONLY_BTNS
// CONFIG_BTNS
// INITSTEP_BTNS
// LASTSTEP_BTNS
// WIZDSTEP_BTNS
function setButtons(buttonSet) {	// public
	if(buttonSet == null) {
		buttonSet = dataCache.get("CURRENTBUTTONS");
		if(buttonSet == null)
			buttonSet = READONLY_BTNS;
	}
	else {
		dataCache.remove("OK_BUTTON_NAME");
	}

	dataCache.put("CURRENTBUTTONS", buttonSet);

	if(bottomFrame.setButtons)
		bottomFrame.setButtons(buttonSet);
}

// renameOkButton will change the label of the "Submit" button
// to the label specified.
function renameOkButton(label) {
	dataCache.put("OK_BUTTON_NAME", label);
	setButtons(null);
}

// will set the specified page in the mainFrame
// menuPage is the page needs to be displayed in the mainFrame
function setmainFramePage(menuPage) {	// public
	if(menuPage != null) {
		// window.open is safer than setting the location directly.
		window.open(menuPage, "mainFrame");
	}
}

// This will expand and make the menu items selected and
// sets the page in the meinFrame accordingly.
function selectMenu(menuItem, loadURLFlag) {		// public
	if(top.leftFrame && leftFrame.selectMenu) {
		leftFrame.selectMenu(menuItem, loadURLFlag);
	}
}

// This method will disable the menu system [Menu and Toolbar].
function freezeMenu(reason) {
	if(leftFrame.freezeMenu) {
		leftFrame.freezeMenu(reason);
	}
	if(toolbarFrame.freezeToolbar) {
		toolbarFrame.freezeToolbar(reason);
	}
}

//This method will enable the menu system [Menu and Toolbar]
function unFreezeMenu() {
	if(leftFrame.unFreezeMenu) {
		leftFrame.unFreezeMenu();
	}
	if(toolbarFrame.unFreezeToolbar) {
		toolbarFrame.unFreezeToolbar();
	}
}

// Can be used to redirect the window to a new IP address
function redirectToNewIP(newIP, timeout) {
	if(newIP == null || newIP == "")
		newIP = dataCache.get("NEW_IP");
	else
		dataCache.put("NEW_IP", newIP);

	if(newIP != null && newIP != "") {
		if(timeout == null) {
			window.location = "http://" + newIP + "/";
		}
		else if(!isNaN(timeout)) {
			setTimeout('redirectToNewIP();', timeout);
		}
	}
}

// the object which holds the data.
// similar to a hash table.
var dataCache = new HashTable();

// create a hash table object
function HashTable() {		// public
	this._globalHash = new Array();
	// public methods			syntax
	this.put = _put;			// put(key, value), returns true if adds to hash table
	this.get = _get;			// get(key), returns the value if key is found, otherwise null
	this.remove = _remove;		// remove(key), returns true if removed, otherwise false.
	this.size = _size;			// size(), returns the number of not null items in the hast
	this.getKeys = _getKeys;	// getKeys(), returns the non null keys in the hash
	this.clear = _clear;		// clear(), will clear the key value pairs in hash
}

// the function will add a key value pair to the global hash.
// the key should be a string object 
// the dataObj can be of any type
function _put(key, dataObj) {		// private
	if(key != null) {
		if(typeof(key) == 'string') {
			this._globalHash[key] = dataObj;
			return true;
		}
	}
	return false;
}

// return the value stored in the hash
// key should be a String type
function _get(key) {		// private
	if(key != null) {
		if(typeof(key) == 'string') {
			if(this._globalHash[key] != null) {
				return this._globalHash[key];
			}
		}
	}
	return null;
}

// removes the data stord in the hash with the key
// key should be of type String
function _remove(key) {		// private
	if(key != null) {
		if(typeof(key) == 'string') {
			if(this._globalHash[key]) {
				this._globalHash[key] = null;
				return true;
			}
		}
	}
	return false;
}

// returns the number of non null items in the hash
function _size() {		// private
	var no_of_items = 0;
	for (key in this._globalHash) {
		if(this._globalHash[key]) {
			no_of_items += 1;
		}
	}
	return no_of_items;
}

// returns the non null keys
function _getKeys() {		// private
	var keys = new Array();
	for (key in this._globalHash) {
		if(this._globalHash[key]) {
			keys[keys.length] = key;
		}
	}
	return keys;
}

// clear the hash
function _clear() {
	for (key in this._globalHash) {
		this._globalHash[key] = null;
	}
}

// can be used to restrict the window resizing,
// can restrict the user from minimizing the window below a specified size
function _onResize() {
	var _width = 0, _height = 0;

	  if( typeof( window.innerWidth ) == 'number' ) {
		//Non-IE
		_width = window.innerWidth;
		_height = window.innerHeight;
	  } else {
		if( document.documentElement &&
			( document.documentElement.clientWidth || document.documentElement.clientHeight ) ) {
		  //IE 6+ in 'standards compliant mode'
		  _width = document.documentElement.clientWidth;
		  _height = document.documentElement.clientHeight;
		} else {
		  if( document.body && ( document.body.clientWidth || document.body.clientHeight ) ) {
			//IE 4 compatible
			_width = document.body.clientWidth;
			_height = document.body.clientHeight;
		  }
		}
	  }

	if( _height < 768) {
		if(top.window.screen.availHeight < 768)
			_height = top.window.screen.availHeight;
		else
			_height = 768;
	}
	if(_width < 1024) {
		if(top.window.screen.availWidth < 1024)
			_width = top.window.screen.availWidth;
		else
			_width = 1024;
	}

	//if(_width != top.window.outerWidth || _height != top.window.outerHeight)
		//top.window.resizeTo(_width, _height);
}

//top.window.onResize="_onResize();";

// _deviceList will hold the list of devices discovered.
var _deviceList = new Array();
// _selectedDeviceIndex contains the index of the currently selected devcie
// in the FPV
var _selectedDeviceIndex = 0;

// setDeviceList will set the device list to the list of devices passed as devices
function setDeviceList(devices) {
	_deviceList = devices;
}

// returns the list of devices.
function getDeviceList() {
	return _deviceList;
}

// getSelectedDevice returns the selected devcie
function getSelectedDevice() {
	if(!_deviceList[_selectedDeviceIndex]) {
		_selectedDeviceIndex = 0;		
	}
	return _deviceList[_selectedDeviceIndex];
}

// setSelectedDeviceIndex sets the selected device index
function setSelectedDeviceIndex(deviceIndex) { // deviceIndex is the position in the combobox
	_selectedDeviceIndex = deviceIndex;
}

// getSelectedDeviceIndex returns the selected device index
function getSelectedDeviceIndex() { // deviceIndex is the position in the combobox
	return _selectedDeviceIndex;
}

// create a device object, if device type is not known to the current code, 
// an UnknownDevice will be created
function mainCreateDevice(int_status, media_type, deviceType) {
	var dev = null;
	dev = createDevice(int_status, media_type, deviceType);
	if(!dev) dev = new unknownDevice();
	return dev;
}

// Device constructor
function device() {
	this.name = "Switch";	// the host name
	this.type = "";			// the model
	this.noofports = 0;		// number of ports 
	this.x=0;				// device xcoordinate in the FPV area
	this.y=0;				// device ycoordinate in FPV area
	this.modes = new Array();	// list of modes supported by the device
	this.modeAliases = new Array();	// The mode string that should be displayed in the mode combo-box
	this.ports = new Array();	// list of ports
	this.sysleds = new Array();	// list of system LEDs
	this.portLeds = new Array();	// list of port LEDs
	this.portDescrs = new Array();	// port description
	this.upTime = "";		// upTime of the device.
	this.ipAddress = "";		// ipAddress of the device
	this.macAddress = "";	// mac Address of device
	this.swVersion = "";		// running software version
	this.serialNo = "";		// serial number of the device
	this.hardLeds = new Array();	// The led details poarsed from show hardware led
	this.setMode = _setMode;		// the method to set the current selected mode
	this.refresh = _refreshDevice;	// the method to refresh the device details in FPV
	this.draw = _drawDevice;			// the method to create the string form which represents the device in HTML
	this.addPort = _addPortToDevice;	// the method to add a portto the port list.
}

// the setmode method for device
function _setMode(mode, frame) {
	if(frame == null) frame = top.topFrame.document;
	var x;
	for(x in this.modes) {
		var y = this.modes[x];		
		if(this.sysleds[y]) {
			if(y == mode) {
				this.sysleds[y].color = "GREEN";
			} else {
				this.sysleds[y].color = "BLACK";
			}
		}
	}
	for (i =0; i < this.ports.length; i++) {
		this.ports[i].color = this.hardLed[mode][i];
	}
	this.refresh(frame);
}

// the addPort method of devcie
function _addPortToDevice(port) {
	port.device = this;
	this.ports[this.ports.length] = port;
}

// the refresh method of devcie
function _refreshDevice(frame) {
	for (i =0; i < this.ports.length; i++) {
		this.ports[i].refresh(frame);
	}
	var sysled;
	for (sysled in this.sysleds) {
		this.sysleds[sysled].refresh(frame);
	}
}

// the draw method of device
function _drawDevice() {
	var str = "<img id='"+ this.id +"' style='position:absolute; left:" + this.x +"px; top:" + this.y + "px; z-index:300'";
	str += " src='" + this.image + "' name='" + this.name +"' border='0'>";
	return str;
}

// Mode button constructor
function modebtn(modeImage) {
	this.name = "";
	this.x = 0;
	this.y = 0;
	this.id = "";
	this.device = "";
	this.index = 0;
	this.image = modeImage;
	this.draw = _drawModeBtn;
}

// the draw method for mode button
function _drawModeBtn() {
	var str = "<img id='"+ this.id +"_id' style='position:absolute; left:" + (this.device.x + this.x) +"px; top:" + (this.device.y + this.y) + "px;" 
	str += " cursor: pointer; cursor: hand; z-index:400' src=" + this.image + " name='" + this.id +"' border='0' onClick='updateDisplayMode();'";
	if(this.height)
		str += " width='" + this.width + "' height='" + this.height + "'";
	str += " onMouseOver='document.images[&quot;" + this.id + "&quot;].style.top=" + (this.device.y + this.y + 1) +";document.images[&quot;" + this.id + "&quot;].style.left=" + (this.device.x + this.x + 1) +";'";
	str += " onMouseOut='document.images[&quot;" + this.id + "&quot;].style.top=" + (this.device.y + this.y) +";document.images[&quot;" + this.id + "&quot;].style.left=" + (this.device.x + this.x) + ";'";
	str += " title='Click this button to select a different Mode'>";
	return str;
}

// LED constructor
function led(ledImages) {
	this.name = "";		// name of the led
	this.x = 0;			// the xcoordinate of the led in FPV area
	this.y = 0;			// the ycoordinate of the led in FPV area
	this.id = "";		// the id to identify the image in the FPV
	this.color = "BLACK";	// the current color of led
	this.descr = "";		// the description // TBD: do we need this ?
	this.device = "";		// the device this led belongs to
	this.width = 7;			// Width of the LED image
	this.height = 3;		// Height of the LED image
	this.images = ledImages;	// the images to be used to represent in different colors
	this.draw = _drawLed;	// the method to create the string form which represents the led in HTML
	this.refresh = _refreshLed;	// the method to refresh the port details in FPV
}

// refresh method of led
function _refreshLed(frame) {
	frame.images[this.id].src = this.images.img[this.color].src;
}

// draw method of led
function _drawLed() {
	var str = "<img id='"+ this.id +"_id' style='position:absolute; left:" + (this.device.x + this.x) +"px; top:" + (this.device.y + this.y) + "px; z-index:400'";
	str += " width='" + this.width + "' height='" + this.height + "' name='" + this.id +"' border='0'>";
	return str;
}
var ledImgs = null
// method to create the led images.
function ledImages() {
	if(ledImgs != null) return ledImgs;
	ledImgs = new portImages();
	ledImgs.img["BLACK"].src = "images/led_gray.gif";
	ledImgs.img["GREEN"].src = "images/led_green.gif";
	ledImgs.img["CYAN"].src = "images/led_cyan.gif";
	ledImgs.img["BROWN"].src = "images/led_brown.gif";
	ledImgs.img["YELLOW"].src = "images/led_yellow.gif";
	ledImgs.img["AMBER"].src = "images/led_amber.gif";
	ledImgs.img["BLINKGREEN"].src = "images/led_blinkgreen.gif";
	ledImgs.img["ALT_GREEN_BLACK"].src = "images/led_blinkgreen.gif";
	ledImgs.img["ALT_AMBER_BLACK"].src = "images/led_blinkamber.gif";
	ledImgs.img["BLINKGREEN_AMBER"].src = "images/led_blinkgreen_amber.gif";
	ledImgs.img["ALT_GREEN_AMBER"].src = "images/led_blinkgreen_amber.gif";
	return ledImgs;
}

// unknownDevice constructor
function unknownDevice() {
	var dev = new device();
	dev.draw = _drawUnknownDevice;
	return dev;
}

// draw method of unknownDevice
function _drawUnknownDevice() {
	var str = '<table align="center" bgcolor="#DADADA" width="100%" height="100%"><tr><td height="80" align="center" valign="middle" class="fpvcontentbold">Unsupported Device</td></tr></table>';
	return str;
}

// Ports constructor
function port(portImages) {
	this.name = "";	// the port name eg. Fastethernet0/1
	this.x = 0;		// the xcoordinate of the port 
	this.y = 0;		// the ycoordinate of the port
	this.id = "";	// the id which will be used to identify the port image object in FPV
	this.index = 0;	// the port index respective to the device
	this.color = "BLACK";	// the color code which used to display the image according to ports state
	this.descr = "";		// the port description, specified by the user.
	this.device = "";		// the device this port belongs to
	this.images = portImages;	// the list of images which will be used to display the status in different mode
	this.width = 19;		// the width of the port image; the default value is 19
	this.height = 15;		// the height of the port image; the default value is 15
	this.draw = _drawPort;		// the method to create the string form which represents the port in HTML
	this.refresh = _refreshPort;	// the method to refresh the port details in FPV
	this.setImage = _setImagePort;	// the method to change the image displayed for the port.
}

// the refresh method of port
function _refreshPort(frame) {
	frame.images[this.id].src = this.images.img[this.color].src;
}

// setImage method of port
function _setImagePort(image, frame) {
	frame.images[this.id].src = image;
}

// the draw method for port
function _drawPort() {
	var str = "<img id='"+ this.id +"_id' style='position:absolute; left:" + (this.device.x + this.x) +"px; top:" + (this.device.y + this.y) + "px; z-index:400'";
	str += " width='" + this.width + "' height='" + this.height + "' name='" + this.id +"' border='0' onClick='handleClick(" + this.index + ");'";
	str += " onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; showTooltip(" + this.index + ");'";
	str += " onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; resetPort(); hideLayerWrapper(2000);'>";
	return str;
}

// the RJ45 Port constructor
function rj45port(portImages) {
	var p = new port(portImages);
	return p;
}

// the inverted RJ45 Port constructor
function rj45portInv(portImages) {
	var p = new port(portImages);
	return p;
}

// the internalport constructor
function internalport(portImages) {
   var p = new port(portImages);
   return p;
}

// the sidePort constructor
function rj45portSide(portImages) {
   var p = new port(portImages);
   return p;
}

// the FX Port constructor
function fxport(portImages) {
	var p = new port(portImages);
	return p;
}

// the GBIC port constructor
// the images and other characteristics will change according to the connector plugged in
function GBICport(cType, images) {
	var p = new port(images);
	if (cType.indexOf ("1000BaseCX") != -1) {
		// construct GBIC Razor port
		p.images = GBIC_RazorImages();
		p.draw = _drawRazorPort;
		p.refresh = _refreshRazorPort;
		p.setImage = _setImageRazorPort;
		p.leftImg = GBIC_RazorConnectorImages();		
		p.rightImg = p.leftImg;
		p.connWidth = 14;
		p.connHeight = 9;
	} else if (cType.indexOf ("1000BaseTX") != -1) {
		// construct GBIC-T port
		p.images = GBIC_TImages();
	} else if (cType.indexOf ("1000BaseSX") != -1) {
		// construct GBIC SX port
		p.images = GBIC_FiberImages();
	} else if (cType.indexOf ("1000BaseLX") != -1) {
		// construct GBIC LX port
		p.images = GBIC_FiberImages();
	} else if (cType.indexOf ("1000BaseZX") != -1) {
		// construct GBIC ZX port
		p.images = GBIC_FiberImages();
	} else if (cType.toUpperCase().indexOf("10GBASE") != -1) {
		// construct GBIC 10Gig port
		p.images = GBIC_10GImages();
	} else if (cType.indexOf ("CWDM") != -1) {
		// construct GBIC CWDM port
		p.images = GBIC_CWDMImages();
		p.draw = _drawGBICCWDMPort;
		p.refresh = _refreshGBICCWDMPort;
		p.setImage = _setImageGBICCWDMPort;
		p.cwdmImages = GBIC_CWDMColorCodeImages();
	} else if (cType.indexOf ("DWDM") != -1) {
		// construct GBIC SX port
		p.images = GBIC_DWDMImages();
	} else if (cType.indexOf("unknown") != -1) {
		// construct GBIC Empty port
		p.images = GBIC_EmptyImages();
	} else {
		// All other type will be treated as Empty slot
		// construct GBIC Empty port
		p.images = GBIC_EmptyImages();
	}
	p.width = 36;
	p.height = 18;
	p.connType = cType;
	return p;
}

// refresh method for GBIC Razor port
function _refreshRazorPort(frame) {
	frame.images[this.id].src = this.images.img[this.color].src;
	frame.images[this.id + "_left"].src = this.leftImg.img[this.color].src;
	frame.images[this.id + "_right"].src = this.rightImg.img[this.color].src;
}

// setImage method for GBIC Razor port
function _setImageRazorPort(image, frame) {
	frame.images[this.id].src = image;
	frame.images[this.id + "_left"].src = 'images/spacer.gif';
	frame.images[this.id + "_right"].src = 'images/spacer.gif';
}

// draw method for GBIC Razor port
function _drawRazorPort() {
	var str = "<img id='"+ this.id +"_id' style='position:absolute; left:" + (this.device.x + this.x) +"px; top:" + (this.device.y + this.y) + "px; z-index:400'";
	str += " width='" + this.width + "' height='" + this.height + "' name='" + this.id +"' border='0' onClick='handleClick(" + this.index + ")'";
	str += " onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; showTooltip(" + this.index + ");";
	str += "document.images[&quot;" + this.id + "_left&quot;].style.top=" + (this.device.y + this.y + 6) +";document.images[&quot;" + this.id + "_left&quot;].style.left=" + (this.device.x + this.x + 4) +";";
	str += "document.images[&quot;" + this.id + "_right&quot;].style.top=" + (this.device.y + this.y + 6) +";document.images[&quot;" + this.id + "_right&quot;].style.left=" + (this.device.x + this.x + 21) +";'";
	str += " onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; resetPort(); hideLayerWrapper(2000);";
	str += "document.images[&quot;" + this.id + "_left&quot;].style.top=" + (this.device.y + this.y + 5) +";document.images[&quot;" + this.id + "_left&quot;].style.left=" + (this.device.x + this.x + 3) +";";
	str += "document.images[&quot;" + this.id + "_right&quot;].style.top=" + (this.device.y + this.y + 5) +";document.images[&quot;" + this.id + "_right&quot;].style.left=" + (this.device.x + this.x + 20) +";'>";

	str += "<img id='"+ this.id +"_id_left' style='position:absolute; left:" + (this.device.x + this.x + 3) +"px; top:" + (this.device.y + this.y + 5) + "px; z-index:500'";
	str += " width='" + this.connWidth + "' height='" + this.connHeight + "' name='" + this.id +"_left' border='0' onClick='handleClick(" + this.index + ")'";
	str += " onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; showTooltip(" + this.index + ");";
	str += "document.images[&quot;" + this.id + "_left&quot;].style.top=" + (this.device.y + this.y + 6) +";document.images[&quot;" + this.id + "_left&quot;].style.left=" + (this.device.x + this.x + 4) +";";
	str += "document.images[&quot;" + this.id + "_right&quot;].style.top=" + (this.device.y + this.y + 6) +";document.images[&quot;" + this.id + "_right&quot;].style.left=" + (this.device.x + this.x + 21) +";'";
	str += " onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; resetPort(); hideLayerWrapper(2000);";
	str += "document.images[&quot;" + this.id + "_left&quot;].style.top=" + (this.device.y + this.y + 5) +";document.images[&quot;" + this.id + "_left&quot;].style.left=" + (this.device.x + this.x + 3) +";";
	str += "document.images[&quot;" + this.id + "_right&quot;].style.top=" + (this.device.y + this.y + 5) +";document.images[&quot;" + this.id + "_right&quot;].style.left=" + (this.device.x + this.x + 20) +";'>";

	str += "<img id='"+ this.id +"_id_right' style='position:absolute; left:" + (this.device.x + this.x + 20) +"px; top:" + (this.device.y + this.y + 5) + "px; z-index:500'";
	str += " width='" + this.connWidth + "' height='" + this.connHeight + "' name='" + this.id +"_right' border='0' onClick='handleClick(" + this.index + ")'";
	str += " onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; showTooltip(" + this.index + ");";
	str += "document.images[&quot;" + this.id + "_left&quot;].style.top=" + (this.device.y + this.y + 6) +";document.images[&quot;" + this.id + "_left&quot;].style.left=" + (this.device.x + this.x + 4) +";";
	str += "document.images[&quot;" + this.id + "_right&quot;].style.top=" + (this.device.y + this.y + 6) +";document.images[&quot;" + this.id + "_right&quot;].style.left=" + (this.device.x + this.x + 21) +";'";
	str += " onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; resetPort(); hideLayerWrapper(2000);";
	str += "document.images[&quot;" + this.id + "_left&quot;].style.top=" + (this.device.y + this.y + 5) +";document.images[&quot;" + this.id + "_left&quot;].style.left=" + (this.device.x + this.x + 3) +";";
	str += "document.images[&quot;" + this.id + "_right&quot;].style.top=" + (this.device.y + this.y + 5) +";document.images[&quot;" + this.id + "_right&quot;].style.left=" + (this.device.x + this.x + 20) +";'>";

	return str;
}

// refresh method for GBIC CWDM port
function _refreshGBICCWDMPort(frame) {
	frame.images[this.id].src = this.images.img[this.color].src;
	if(!this.cwdmImages[this.connType])
		this.connType = "other";
	frame.images[this.id + "_color"].src = this.cwdmImages[this.connType].src;
}

// setImage method for GBIC CWDM port
function _setImageGBICCWDMPort(image, frame) {
	frame.images[this.id].src = image;	
	frame.images[this.id + "_color"].src = 'images/spacer.gif';
}

// draw method for GBIC CWDM port
function _drawGBICCWDMPort() {
	var str = "<img id='"+ this.id +"_id' style='position:absolute; left:" + (this.device.x + this.x) +"px; top:" + (this.device.y + this.y) + "px; z-index:400'";
	str += " width='" + this.width + "' height='" + this.height + "' name='" + this.id +"' border='0' onClick='handleClick(" + this.index + ")'";
	str += " onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; showTooltip(" + this.index + ");";
	str += "document.images[&quot;" + this.id + "_color&quot;].style.top=" + (this.device.y + this.y + 1) +";document.images[&quot;" + this.id + "_color&quot;].style.left=" + (this.device.x + this.x + 1) +";'";
	str += " onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; resetPort(); hideLayerWrapper(2000);";
	str += "document.images[&quot;" + this.id + "_color&quot;].style.top=" + (this.device.y + this.y) +";document.images[&quot;" + this.id + "_color&quot;].style.left=" + (this.device.x + this.x) +";'>";

	str += "<img id='"+ this.id +"_id_color' style='position:absolute; left:" + (this.device.x + this.x) +"px; top:" + (this.device.y + this.y) + "px; z-index:500'";
	str += " width='" + this.width + "' height='" + this.height + "' name='" + this.id +"_color' border='0' onClick='handleClick(" + this.index + ")'";
	str += " onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; showTooltip(" + this.index + ");";
	str += "document.images[&quot;" + this.id + "_color&quot;].style.top=" + (this.device.y + this.y + 1) +";document.images[&quot;" + this.id + "_color&quot;].style.left=" + (this.device.x + this.x + 1) +";'";
	str += " onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; resetPort(); hideLayerWrapper(2000);";
	str += "document.images[&quot;" + this.id + "_color&quot;].style.top=" + (this.device.y + this.y) +";document.images[&quot;" + this.id + "_color&quot;].style.left=" + (this.device.x + this.x) +";'>";

	return str;
}

// SFP port constructor
function SFPport(cType, images) {
	var p = new port(images);
	if (cType.indexOf ("1000BaseTX") != -1) {
		// construct SFP-T port
		p.images = SFP_TImages();
	} else if (cType.indexOf ("1000BaseSX") != -1) {
		// construct SFP-SX port
		p.images = SFP_SXImages();
	} else if (cType.indexOf ("1000BaseLX") != -1) {
		// construct SFP-LX port
		p.images = SFP_LXImages();
	} else if (cType.indexOf ("1000BaseZX") != -1) {
		// construct SFP-ZX port
		p.images = SFP_ZXImages();
	} else if (cType.indexOf ("CWDM") != -1) {
		// construct SFP-CWDM port
		p.images = SFP_CWDMImages();
		p.draw = _drawSFPCWDMPort;
		p.refresh = _refreshSFPCWDMPort;
		p.setImage = _setImageSFPCWDMPort;
		p.cwdmImages = SFP_CWDMColorCodeImages();
	} else if (cType.indexOf ("100BaseFX SFP") != -1) {
		// construct SFP-FX100 port
		p.images = SFP_100FXImages();
	} else if (cType.indexOf("unknown") != -1) {
		// construct Empty port
		p.images = SFP_EmptyImages();
	} else {
	  	// any other type is considered as Empty	
		// construct Empty SFP port
		p.images = SFP_EmptyImages();
	}
	p.width = 21;
	p.height = 16;
	p.connType = cType;
	return p;
}

// refresh method for SFP CWDM port
function _refreshSFPCWDMPort(frame) {
	frame.images[this.id].src = this.images.img[this.color].src;
	if(!this.cwdmImages[this.connType])
		this.connType = "other";
	frame.images[this.id + "_color"].src = this.cwdmImages[this.connType].src;
}

// setImage method for SFP CWDM port
function _setImageSFPCWDMPort(image,frame) {
	frame.images[this.id].src = image;
	frame.images[this.id + "_color"].src = 'images/spacer.gif';
}

// draw method for SFP CWDM port
function _drawSFPCWDMPort() {
	var str = "<img id='"+ this.id +"_id' style='position:absolute; left:" + (this.device.x + this.x) +"px; top:" + (this.device.y + this.y) + "px; z-index:400'";
	str += " width='" + this.width + "' height='" + this.height + "' name='" + this.id +"' border='0' onClick='handleClick(" + this.index + ")'";
	str += " onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; showTooltip(" + this.index + ");";
	str += "document.images[&quot;" + this.id + "_color&quot;].style.top=" + (this.device.y + this.y + 1) +";document.images[&quot;" + this.id + "_color&quot;].style.left=" + (this.device.x + this.x + 1) +";'";
	str += " onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; resetPort(); hideLayerWrapper(2000);";
	str += "document.images[&quot;" + this.id + "_color&quot;].style.top=" + (this.device.y + this.y) +";document.images[&quot;" + this.id + "_color&quot;].style.left=" + (this.device.x + this.x) +";'>";

	str += "<img id='"+ this.id +"_id_color' style='position:absolute; left:" + (this.device.x + this.x) +"px; top:" + (this.device.y + this.y) + "px; z-index:500'";
	str += " width='" + this.width + "' height='" + this.height + "' name='" + this.id +"_color' border='0' onClick='handleClick(" + this.index + ")'";
	str += " onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; showTooltip(" + this.index + ");";
	str += "document.images[&quot;" + this.id + "_color&quot;].style.top=" + (this.device.y + this.y + 1) +";document.images[&quot;" + this.id + "_color&quot;].style.left=" + (this.device.x + this.x + 1) +";'";
	str += " onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; resetPort(); hideLayerWrapper(2000);";
	str += "document.images[&quot;" + this.id + "_color&quot;].style.top=" + (this.device.y + this.y) +";document.images[&quot;" + this.id + "_color&quot;].style.left=" + (this.device.x + this.x) +";'>";

	return str;
}

// the RJ45 composite Port constructor
function rj45Compositeport(cType, portImages) {
	var p = new port(portImages);
	p.connType = cType;
	p.width = 21;
	p.height = 33;
	p.baseImage = "images/spacer.gif";
	if(cType.indexOf("-") != -1) {
		cType = cType.substring(0,cType.lastIndexOf("-"));
	} else {
		cType = "Empty";
		p.connType = cType + "-" + p.connType;
	}
	var sfpPort = new SFPport(cType,portImages);
	p.sfpPort = sfpPort;
	p.draw = _drawrj45CompositePort;
	p.refresh = _refreshrj45CompositePort;
	p.setImage = _setImagerj45CompositePort;
	p.rj45Width = 19;
	p.rj45Height = 15;
	p.sfpWidth = 21;
	p.sfpHeight = 16;
	return p;
}

// refresh method for RJ45 composite port
function _refreshrj45CompositePort(frame) {
	frame.images[this.id].src = this.baseImage;
	if(this.color.indexOf("-") != -1) {
		var colors = this.color.split("-");
		this.sfpColor = colors[0];
		this.rj45Color = colors[1];
	} else {
		this.rj45Color = this.color;
		this.sfpColor = this.color;
	}
	frame.images[this.id + "_rj45"].src = this.images.img[this.rj45Color].src;
	frame.images[this.id + "_sfp"].src = this.sfpPort.images.img[this.sfpColor].src;
	if(frame.images[this.id + "_sfp_color"]) {
		frame.images[this.id + "_sfp_color"].src = this.sfpPort.cwdmImages[this.sfpPort.connType].src;
	}
}

// setImage method for RJ45 composite port
function _setImagerj45CompositePort(image, frame) {
	frame.images[this.id].src = image;
	frame.images[this.id + "_rj45"].src = 'images/spacer.gif';
	frame.images[this.id + "_sfp"].src = 'images/spacer.gif';
}

// draw method for RJ45 composite port
function _drawrj45CompositePort() {
	var str = "<img id='"+ this.id +"_id' style='position:absolute; left:" + (this.device.x + this.x) +"px; top:" + (this.device.y + this.y) + "px; z-index:400'";
	str += " width='" + this.width + "' height='" + this.height + "' name='" + this.id +"' border='0' onClick='handleClick(" + this.index + ")'";
	str += " onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; showTooltip(" + this.index + ");";
	str += "document.images[&quot;" + this.id + "_rj45&quot;].style.top=" + (this.device.y + this.y + 18) +";document.images[&quot;" + this.id + "_rj45&quot;].style.left=" + (this.device.x + this.x + 2) +";";
	str += "document.images[&quot;" + this.id + "_sfp&quot;].style.top=" + (this.device.y + this.y + 1) +";document.images[&quot;" + this.id + "_sfp&quot;].style.left=" + (this.device.x + this.x + 1) +";'";
	str += " onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; resetPort(); hideLayerWrapper(2000);";
	str += "document.images[&quot;" + this.id + "_rj45&quot;].style.top=" + (this.device.y + this.y + 17) +";document.images[&quot;" + this.id + "_rj45&quot;].style.left=" + (this.device.x + this.x + 1) +";";
	str += "document.images[&quot;" + this.id + "_sfp&quot;].style.top=" + (this.device.y + this.y) +";document.images[&quot;" + this.id + "_sfp&quot;].style.left=" + (this.device.x + this.x) +";'>";

	str += "<img id='"+ this.id +"_id_rj45' style='position:absolute; left:" + (this.device.x + this.x + 1) +"px; top:" + (this.device.y + this.y + 17) + "px; z-index:500'";
	str += " width='" + this.rj45Width + "' height='" + this.rj45Height + "' name='" + this.id +"_rj45' border='0' onClick='handleClick(" + this.index + ")'";
	str += " onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; showTooltip(" + this.index + "); ";
	str += "document.images[&quot;" + this.id + "_rj45&quot;].style.top=" + (this.device.y + this.y + 18) +";document.images[&quot;" + this.id + "_rj45&quot;].style.left=" + (this.device.x + this.x + 2) +";";
	str += "document.images[&quot;" + this.id + "_sfp&quot;].style.top=" + (this.device.y + this.y + 1) +";document.images[&quot;" + this.id + "_sfp&quot;].style.left=" + (this.device.x + this.x + 1) +";'";
	str += " onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; resetPort(); hideLayerWrapper(2000); ";
	str += "document.images[&quot;" + this.id + "_rj45&quot;].style.top=" + (this.device.y + this.y + 17) +";document.images[&quot;" + this.id + "_rj45&quot;].style.left=" + (this.device.x + this.x + 1) +";";
	str += "document.images[&quot;" + this.id + "_sfp&quot;].style.top=" + (this.device.y + this.y) +";document.images[&quot;" + this.id + "_sfp&quot;].style.left=" + (this.device.x + this.x) +";'>";

	str += "<img id='"+ this.id +"_id_sfp' style='position:absolute; left:" + (this.device.x + this.x) +"px; top:" + (this.device.y + this.y) + "px; z-index:500'";
	str += " width='" + this.sfpWidth + "' height='" + this.sfpHeight + "' name='" + this.id +"_sfp' border='0' onClick='handleClick(" + this.index + ")'";
	str += " onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; showTooltip(" + this.index + "); ";
	str += "document.images[&quot;" + this.id + "_rj45&quot;].style.top=" + (this.device.y + this.y + 18) +";document.images[&quot;" + this.id + "_rj45&quot;].style.left=" + (this.device.x + this.x + 2) +";";
	str += "document.images[&quot;" + this.id + "_sfp&quot;].style.top=" + (this.device.y + this.y + 1) +";document.images[&quot;" + this.id + "_sfp&quot;].style.left=" + (this.device.x + this.x + 1) +";'";
	str += " onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; resetPort(); hideLayerWrapper(2000); ";
	str += "document.images[&quot;" + this.id + "_rj45&quot;].style.top=" + (this.device.y + this.y + 17) +";document.images[&quot;" + this.id + "_rj45&quot;].style.left=" + (this.device.x + this.x + 1) +";";
	str += "document.images[&quot;" + this.id + "_sfp&quot;].style.top=" + (this.device.y + this.y) +";document.images[&quot;" + this.id + "_sfp&quot;].style.left=" + (this.device.x + this.x) +";'>";
	
	if(this.sfpPort.cwdmImages) {
		str += "<img id='"+ this.id +"_id_sfp_color' style='position:absolute; left:" + (this.device.x + this.x) +"px; top:" + (this.device.y + this.y) + "px; z-index:600'";
		str += " width='" + this.sfpWidth + "' height='" + this.sfpHeight + "' name='" + this.id +"_sfp_color' border='0' onClick='handleClick(" + this.index + ")'";
		str += " onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; showTooltip(" + this.index + ");'";
		str += " onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; resetPort(); hideLayerWrapper(2000);'>";
	}
	return str;
}

// the 10Gig Port constructor
function tenGigport(cType, portImages) {
	var p = new port(portImages);
	if(cType.indexOf("10GBase-LR Xenpak") != -1) {
		p.baseImg = "images/10gig_base.gif";
		p.images = GBIC_10GImages();
		p.draw = _draw10GigPort;
		p.refresh = _refresh10GigPort;
		p.setImage = _setImage10GigPort;
	} else {
		p.images = GBIC_10GEmptyImages();
	}
	p.baseWidth = 47;
	p.baseHeight = 26;
	p.connWidth = 31;
	p.connHeight = 14;
	return p;
}

// refresh method for 10Gig  port
function _refresh10GigPort(frame) {
	frame.images[this.id].src = this.baseImg;
	frame.images[this.id + "_connector"].src = this.images.img[this.color].src;
}

// setImage method for 10Gig  port
function _setImage10GigPort(image, frame) {
	frame.images[this.id].src = image;
	frame.images[this.id + "_connector"].src = 'images/spacer.gif';
}

// draw method for 10Gig port
function _draw10GigPort() {
	var str = "<img id='"+ this.id +"_id' style='position:absolute; left:" + (this.device.x + this.x) +"px; top:" + (this.device.y + this.y) + "px; z-index:400'";
	str += " width='" + this.baseWidth + "' height='" + this.baseHeight + "' name='" + this.id +"' border='0' onClick='handleClick(" + this.index + ")'";
	str += " onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; showTooltip(" + this.index + ");";
	str += "document.images[&quot;" + this.id + "_connector&quot;].style.top=" + (this.device.y + this.y + 10) +";document.images[&quot;" + this.id + "_connector&quot;].style.left=" + (this.device.x + this.x + 8) +";'";
	str += " onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; resetPort(); hideLayerWrapper(2000);";
	str += "document.images[&quot;" + this.id + "_connector&quot;].style.top=" + (this.device.y + this.y + 9) +";document.images[&quot;" + this.id + "_connector&quot;].style.left=" + (this.device.x + this.x + 7) +";'>";

	str += "<img id='"+ this.id +"_connector_id' style='position:absolute; left:" + (this.device.x + this.x + 7) +"px; top:" + (this.device.y + this.y + 9) + "px; z-index:500'";
	str += " width='" + this.connWidth + "' height='" + this.connHeight + "' name='" + this.id +"_connector' border='0' onClick='handleClick(" + this.index + ")'";
	str += " onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; showTooltip(" + this.index + ");";
	str += "document.images[&quot;" + this.id + "_connector&quot;].style.top=" + (this.device.y + this.y + 10) +";document.images[&quot;" + this.id + "_connector&quot;].style.left=" + (this.device.x + this.x + 8) +";'";
	str += " onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; resetPort(); hideLayerWrapper(2000);";
	str += "document.images[&quot;" + this.id + "_connector&quot;].style.top=" + (this.device.y + this.y + 9) +";document.images[&quot;" + this.id + "_connector&quot;].style.left=" + (this.device.x + this.x + 7) +";'>";

	return str;
}

// function to create Port images
function portImages() {
	this.img = new Array();
	this.img["BLACK"] = new Image();
	this.img["GREEN"] = new Image();
	this.img["CYAN"] = new Image();
	this.img["BROWN"] = new Image();
	this.img["YELLOW"] = new Image();
	this.img["AMBER"] = new Image();
	this.img["BLINKGREEN"] = new Image();
	this.img["ALT_GREEN_BLACK"] = new Image();
	this.img["ALT_AMBER_BLACK"] = new Image();
	this.img["BLINKGREEN_AMBER"] = new Image();
	this.img["ALT_GREEN_AMBER"] = new Image();
}

var rj45Imgs = null;
// method to create RJ45 port images
function rj45portImages() {
	if(rj45Imgs != null) return rj45Imgs;
	rj45Imgs = new portImages();
	rj45Imgs.img["BLACK"].src = "images/gray.gif";
	rj45Imgs.img["GREEN"].src = "images/green.gif";
	rj45Imgs.img["CYAN"].src = "images/cyan.gif";
	rj45Imgs.img["BROWN"].src = "images/brown.gif";
	rj45Imgs.img["YELLOW"].src = "images/yellow.gif";
	rj45Imgs.img["AMBER"].src = "images/amber.gif";
	rj45Imgs.img["BLINKGREEN"].src = "images/blinkgreen.gif";
	rj45Imgs.img["ALT_GREEN_BLACK"].src = "images/blinkgreen.gif";
	rj45Imgs.img["BLINKGREEN_AMBER"].src = "images/blinkgreen_amber.gif";
	rj45Imgs.img["ALT_GREEN_AMBER"].src = "images/blinkgreen_amber.gif";
	return rj45Imgs;
}

var rj45InvImgs = null;
// method to create inverted RJ45 port images
function rj45portInvImages() {
	if(rj45InvImgs != null) return rj45InvImgs;
	rj45InvImgs = new portImages();
	rj45InvImgs.img["BLACK"].src = "images/inv_gray.gif";
	rj45InvImgs.img["GREEN"].src = "images/inv_green.gif";
	rj45InvImgs.img["CYAN"].src = "images/inv_cyan.gif";
	rj45InvImgs.img["BROWN"].src = "images/inv_brown.gif";
	rj45InvImgs.img["YELLOW"].src = "images/inv_yellow.gif";
	rj45InvImgs.img["AMBER"].src = "images/inv_amber.gif";
	rj45InvImgs.img["BLINKGREEN"].src = "images/inv_blinkgreen.gif";
	rj45InvImgs.img["ALT_GREEN_BLACK"].src = "images/inv_blinkgreen.gif";
	rj45InvImgs.img["BLINKGREEN_AMBER"].src = "images/inv_blinkgreen_amber.gif";
	rj45InvImgs.img["ALT_GREEN_AMBER"].src = "images/inv_blinkgreen_amber.gif";
	return rj45InvImgs;
}
var internalImages = null;
// method to create Internalport images
function internalportImages(){
	if(internalImages != null) return internalImages;
	var internalImages = new portImages();
	internalImages.img["BLACK"].src = "images/internal_gray.gif";
	internalImages.img["GREEN"].src = "images/internal_green.gif";
	internalImages.img["BROWN"].src = "images/internal_brown.gif";
	internalImages.img["AMBER"].src = "images/internal_amber.gif";
	internalImages.img["YELLOW"].src = "images/internal_yellow.gif";
	internalImages.img["BLINKGREEN"].src = "images/internal_blinkgreen.gif";
	internalImages.img["ALT_GREEN_BLACK"].src = "images/internal_blinkgreen.gif";
	internalImages.img["BLINKGREEN_AMBER"].src = "images/internal_blinkgreen_amber.gif";
	internalImages.img["ALT_GREEN_AMBER"].src = "images/internal_blinkgreen_amber.gif";
	return internalImages;
}

var rj45sideImgs = null;
// method to create side RJ45 port images
function rj45portSideImages() {
	if(rj45sideImgs != null) return rj45sideImgs;
	var rj45sideImgs = new portImages();
	rj45sideImgs.img["BLACK"].src = "images/side_gray.gif";
	rj45sideImgs.img["GREEN"].src = "images/side_green.gif";
	rj45sideImgs.img["BROWN"].src = "images/side_brown.gif";
	rj45sideImgs.img["AMBER"].src = "images/side_amber.gif";
	rj45sideImgs.img["YELLOW"].src = "images/side_yellow.gif";
	rj45sideImgs.img["BLINKGREEN"].src = "images/inv_blinkgreen.gif";
	rj45sideImgs.img["ALT_GREEN_BLACK"].src = "images/inv_blinkgreen.gif";
	rj45sideImgs.img["BLINKGREEN_AMBER"].src = "images/inv_blinkgreen_amber.gif";
	rj45sideImgs.img["ALT_GREEN_AMBER"].src = "images/inv_blinkgreen_amber.gif";
	return rj45sideImgs;
}

var fxPortImgs = null;
// method to create FX port images
function fxportImages() {
	if(fxPortImgs != null) return fxPortImgs;
	fxPortImgs = new portImages();
	fxPortImgs.img["BLACK"].src = "images/fx_gray.gif";
	fxPortImgs.img["GREEN"].src = "images/fx_green.gif";
	fxPortImgs.img["CYAN"].src = "images/fx_cyan.gif";
	fxPortImgs.img["BROWN"].src = "images/fx_brown.gif";
	fxPortImgs.img["AMBER"].src = "images/fx_amber.gif";
	fxPortImgs.img["YELLOW"].src = "images/fx_yellow.gif";
	fxPortImgs.img["BLINKGREEN"].src = "images/fx_blinkgreen.gif";
	fxPortImgs.img["ALT_GREEN_BLACK"].src = "images/fx_blinkgreen.gif";
	fxPortImgs.img["BLINKGREEN_AMBER"].src = "images/fx_blinkgreen_amber.gif";
	fxPortImgs.img["ALT_GREEN_AMBER"].src = "images/fx_blinkgreen_amber.gif";
	return fxPortImgs;
}

var gbicEmptyImgs = null;
// method to create Empty GBIC port images
function GBIC_EmptyImages() {
	if(gbicEmptyImgs != null) return gbicEmptyImgs;
	gbicEmptyImgs = new portImages();
	gbicEmptyImgs.img["BLACK"].src = "images/gbic_empty.gif";
	gbicEmptyImgs.img["GREEN"].src = "images/gbic_empty.gif";
	gbicEmptyImgs.img["CYAN"].src = "images/gbic_empty.gif";
	gbicEmptyImgs.img["BROWN"].src = "images/gbic_empty_brown.gif";
	gbicEmptyImgs.img["YELLOW"].src = "images/gbic_empty_yellow.gif";
	gbicEmptyImgs.img["AMBER"].src = "images/gbic_empty_amber.gif";
	gbicEmptyImgs.img["BLINKGREEN"].src = "images/gbic_empty.gif";
	gbicEmptyImgs.img["ALT_GREEN_BLACK"].src = "images/gbic_empty.gif";
	gbicEmptyImgs.img["BLINKGREEN_AMBER"].src = "images/gbic_empty.gif";
	gbicEmptyImgs.img["ALT_GREEN_AMBER"].src = "images/gbic_empty.gif";
	return gbicEmptyImgs;
}

var gbicRzrImgs = null;
// method to create GBIC Razor port images
function GBIC_RazorImages() {
	if(gbicRzrImgs != null) return gbicRzrImgs;
	gbicRzrImgs = new portImages();
	gbicRzrImgs.img["BLACK"].src = "images/gbic_base.gif";
	gbicRzrImgs.img["GREEN"].src = "images/gbic_base.gif";
	gbicRzrImgs.img["CYAN"].src = "images/gbic_base.gif";
	gbicRzrImgs.img["BROWN"].src = "images/gbic_base.gif";
	gbicRzrImgs.img["YELLOW"].src = "images/gbic_base.gif";
	gbicRzrImgs.img["AMBER"].src = "images/gbic_base.gif";
	gbicRzrImgs.img["BLINKGREEN"].src = "images/gbic_base.gif";
	gbicRzrImgs.img["ALT_GREEN_BLACK"].src = "images/gbic_base.gif";
	gbicRzrImgs.img["BLINKGREEN_AMBER"].src = "images/gbic_base.gif";
	gbicRzrImgs.img["ALT_GREEN_AMBER"].src = "images/gbic_base.gif";
	return gbicRzrImgs;
}

var gbicRzrConnImgs = null;
// method to create GBIC Razor connector images
function GBIC_RazorConnectorImages() {
	if(gbicRzrConnImgs != null) return gbicRzrConnImgs;
	gbicRzrConnImgs = new portImages();
	gbicRzrConnImgs.img["BLACK"].src = "images/gbic_rzr_gray.gif";
	gbicRzrConnImgs.img["GREEN"].src = "images/gbic_rzr_green.gif";
	gbicRzrConnImgs.img["CYAN"].src = "images/gbic_rzr_cyan.gif";
	gbicRzrConnImgs.img["BROWN"].src = "images/gbic_rzr_brown.gif";
	gbicRzrConnImgs.img["YELLOW"].src = "images/gbic_rzr_yellow.gif";	
	gbicRzrConnImgs.img["AMBER"].src = "images/gbic_rzr_amber.gif";
	gbicRzrConnImgs.img["BLINKGREEN"].src = "images/gbic_rzr_blinkgreen.gif";
	gbicRzrConnImgs.img["ALT_GREEN_BLACK"].src = "images/gbic_rzr_blinkgreen.gif";
	gbicRzrConnImgs.img["BLINKGREEN_AMBER"].src = "images/gbic_rzr_green_amber.gif";
	gbicRzrConnImgs.img["ALT_GREEN_AMBER"].src = "images/gbic_rzr_green_amber.gif";
	return gbicRzrConnImgs;
}

var gbicTImgs = null;
// method to create GBIC-T port images
function GBIC_TImages() {
	if(gbicTImgs != null) return gbicTImgs;
	gbicTImgs = new portImages();
	gbicTImgs.img["BLACK"].src = "images/gbic_t_gray.gif";
	gbicTImgs.img["GREEN"].src = "images/gbic_t_green.gif";
	gbicTImgs.img["CYAN"].src = "images/gbic_t_cyan.gif";
	gbicTImgs.img["BROWN"].src = "images/gbic_t_brown.gif";
	gbicTImgs.img["YELLOW"].src = "images/gbic_t_yellow.gif";
	gbicTImgs.img["AMBER"].src = "images/gbic_t_amber.gif";
	gbicTImgs.img["BLINKGREEN"].src = "images/gbic_t_blinkgreen.gif";
	gbicTImgs.img["ALT_GREEN_BLACK"].src = "images/gbic_t_blinkgreen.gif";
	gbicTImgs.img["BLINKGREEN_AMBER"].src = "images/gbic_t_green_amber.gif";
	gbicTImgs.img["ALT_GREEN_AMBER"].src = "images/gbic_t_green_amber.gif";
	return gbicTImgs;
}

var gbicFbrImgs = null;
// method to create GBIC Fiber port images (used by SX, LX and ZX ports)
function GBIC_FiberImages() {
	if(gbicFbrImgs != null) return gbicFbrImgs;
	gbicFbrImgs = new portImages();
	gbicFbrImgs.img["BLACK"].src = "images/gbic_lx_gray.gif";
	gbicFbrImgs.img["GREEN"].src = "images/gbic_lx_green.gif";
	gbicFbrImgs.img["CYAN"].src = "images/gbic_lx_cyan.gif";
	gbicFbrImgs.img["BROWN"].src = "images/gbic_lx_brown.gif";
	gbicFbrImgs.img["YELLOW"].src = "images/gbic_lx_yellow.gif";
	gbicFbrImgs.img["AMBER"].src = "images/gbic_lx_amber.gif";
	gbicFbrImgs.img["BLINKGREEN"].src = "images/gbic_lx_blinkgreen.gif";
	gbicFbrImgs.img["ALT_GREEN_BLACK"].src = "images/gbic_lx_blinkgreen.gif";
	gbicFbrImgs.img["BLINKGREEN_AMBER"].src = "images/gbic_lx_green_amber.gif";
	gbicFbrImgs.img["ALT_GREEN_AMBER"].src = "images/gbic_lx_green_amber.gif";
	return gbicFbrImgs;
}

// method to create GBIC CWDM port images
function GBIC_CWDMImages() {
	return GBIC_FiberImages();
}

// method to create GBIC DWDM port images
function GBIC_DWDMImages() {
	return GBIC_FiberImages();
}

var cwdm_led = null;
// method to create GBIC CCWDM port wave length color code images
function GBIC_CWDMColorCodeImages() {
// CWDM-1470, CWDM-1490, CWDM-1510, CWDM-1530, CWDM-1550, CWDM-1570, CWDM-1590, CWDM-1610
	if(cwdm_led != null) return cwdm_led;
	cwdm_led = new Array();
	cwdm_led["CWDM-1470"] = new Image(); cwdm_led["CWDM-1470"].src = "images/gbic_cwdm_gray.gif";
	cwdm_led["CWDM-1490"] = new Image(); cwdm_led["CWDM-1490"].src = "images/gbic_cwdm_violet.gif";
	cwdm_led["CWDM-1510"] = new Image(); cwdm_led["CWDM-1510"].src = "images/gbic_cwdm_blue.gif";
	cwdm_led["CWDM-1530"] = new Image(); cwdm_led["CWDM-1530"].src = "images/gbic_cwdm_green.gif";	
	cwdm_led["CWDM-1550"] = new Image(); cwdm_led["CWDM-1550"].src = "images/gbic_cwdm_yellow.gif";
	cwdm_led["CWDM-1570"] = new Image(); cwdm_led["CWDM-1570"].src = "images/gbic_cwdm_orange.gif";
	cwdm_led["CWDM-1590"] = new Image(); cwdm_led["CWDM-1590"].src = "images/gbic_cwdm_red.gif";
	cwdm_led["CWDM-1610"] = new Image(); cwdm_led["CWDM-1610"].src = "images/gbic_cwdm_brown.gif";
	cwdm_led["other"] = new Image(); cwdm_led["other"].src = "images/spacer.gif";
	return cwdm_led;
}

var sfpTImgs = null;
// method to create SFP-T port images
function SFP_TImages() {
	if(sfpTImgs != null) return sfpTImgs;
	sfpTImgs = new portImages();
	sfpTImgs.img["BLACK"].src = "images/sfp_gray.gif";
	sfpTImgs.img["GREEN"].src = "images/sfp_green.gif";
	sfpTImgs.img["CYAN"].src = "images/sfp_cyan.gif";
	sfpTImgs.img["BROWN"].src = "images/sfp_brown.gif";
	sfpTImgs.img["YELLOW"].src = "images/sfp_yellow.gif";
	sfpTImgs.img["AMBER"].src = "images/sfp_amber.gif";
	sfpTImgs.img["BLINKGREEN"].src = "images/sfp_blinkgreen.gif";
	sfpTImgs.img["ALT_GREEN_BLACK"].src = "images/sfp_blinkgreen.gif";
	sfpTImgs.img["BLINKGREEN_AMBER"].src = "images/sfp_blinkgreen_amber.gif";
	sfpTImgs.img["ALT_GREEN_AMBER"].src = "images/sfp_blinkgreen_amber.gif";
	return sfpTImgs;
}

var sfpSXImgs = null;
// method to create SFP-SX port images
function SFP_SXImages() {
	if(sfpSXImgs != null) return sfpSXImgs;
	sfpSXImgs = new portImages();
	sfpSXImgs.img["BLACK"].src = "images/sfp_gray.gif";
	sfpSXImgs.img["GREEN"].src = "images/sfp_green.gif";
	sfpSXImgs.img["CYAN"].src = "images/sfp_cyan.gif";
	sfpSXImgs.img["BROWN"].src = "images/sfp_brown.gif";
	sfpSXImgs.img["YELLOW"].src = "images/sfp_yellow.gif";
	sfpSXImgs.img["AMBER"].src = "images/sfp_amber.gif";
	sfpSXImgs.img["BLINKGREEN"].src = "images/sfp_blinkgreen.gif";
	sfpSXImgs.img["ALT_GREEN_BLACK"].src = "images/sfp_blinkgreen.gif";
	sfpSXImgs.img["BLINKGREEN_AMBER"].src = "images/sfp_blinkgreen_amber.gif";
	sfpSXImgs.img["ALT_GREEN_AMBER"].src = "images/sfp_blinkgreen_amber.gif";
	return sfpSXImgs;
}

// method to create SFP-LX port images
function SFP_LXImages() {
	return SFP_SXImages();
}

// method to create SFP-ZX port images
function SFP_ZXImages() {
	return SFP_SXImages();
}

// method to create SFP-CWDM port images
function SFP_CWDMImages() {
	return SFP_SXImages();
}

// method to create SFP-FX100 port images
function SFP_100FXImages() {
	return SFP_SXImages();
}

var sfpEmptyImgs = null;
// method to create SFP Empty port images
function SFP_EmptyImages() {
	if(sfpEmptyImgs != null) return sfpEmptyImgs;
	sfpEmptyImgs = new portImages();
	sfpEmptyImgs.img["BLACK"].src = "images/sfp_empty_gray.gif";
	sfpEmptyImgs.img["GREEN"].src = "images/sfp_empty_green.gif";
	sfpEmptyImgs.img["CYAN"].src = "images/sfp_empty_gray.gif";
	sfpEmptyImgs.img["BROWN"].src = "images/sfp_empty_brown.gif";
	sfpEmptyImgs.img["YELLOW"].src = "images/sfp_empty_yellow.gif";
	sfpEmptyImgs.img["AMBER"].src = "images/sfp_empty_amber.gif";
	sfpEmptyImgs.img["BLINKGREEN"].src = "images/sfp_empty_blinkgreen.gif";
	sfpEmptyImgs.img["ALT_GREEN_BLACK"].src = "images/sfp_empty_blinkgreen.gif";
	sfpEmptyImgs.img["BLINKGREEN_AMBER"].src = "images/sfp_empty_gray.gif";
	sfpEmptyImgs.img["ALT_GREEN_AMBER"].src = "images/sfp_empty_gray.gif";
	return sfpEmptyImgs;
}

var cwdm_sfp_led = null;
// method to create SFP CCWDM port wave length color code images
function SFP_CWDMColorCodeImages() {
// CWDM-1470, CWDM-1490, CWDM-1510, CWDM-1530, CWDM-1550, CWDM-1570, CWDM-1590, CWDM-1610
	if(cwdm_sfp_led != null) return cwdm_sfp_led;
	cwdm_sfp_led = new Array();
	cwdm_sfp_led["CWDM-1470"] = new Image(); cwdm_sfp_led["CWDM-1470"].src = "images/cwdm_gray.gif";
	cwdm_sfp_led["CWDM-1490"] = new Image(); cwdm_sfp_led["CWDM-1490"].src = "images/cwdm_violet.gif";
	cwdm_sfp_led["CWDM-1510"] = new Image(); cwdm_sfp_led["CWDM-1510"].src = "images/cwdm_blue.gif";
	cwdm_sfp_led["CWDM-1530"] = new Image(); cwdm_sfp_led["CWDM-1530"].src = "images/cwdm_green.gif";	
	cwdm_sfp_led["CWDM-1550"] = new Image(); cwdm_sfp_led["CWDM-1550"].src = "images/cwdm_yellow.gif";
	cwdm_sfp_led["CWDM-1570"] = new Image(); cwdm_sfp_led["CWDM-1570"].src = "images/cwdm_orange.gif";
	cwdm_sfp_led["CWDM-1590"] = new Image(); cwdm_sfp_led["CWDM-1590"].src = "images/cwdm_red.gif";
	cwdm_sfp_led["CWDM-1610"] = new Image(); cwdm_sfp_led["CWDM-1610"].src = "images/cwdm_brown.gif";
	cwdm_sfp_led["other"] = new Image(); cwdm_sfp_led["other"].src = "images/spacer.gif";
	return cwdm_sfp_led;
}

var gbic10GImgs = null;
// method to create GBIC 10Gig port images
function GBIC_10GImages() {
	if(gbic10GImgs != null) return gbic10GImgs;
	gbic10GImgs = new portImages();
	gbic10GImgs.img["BLACK"].src = "images/10gig_gray.gif";
	gbic10GImgs.img["GREEN"].src = "images/10gig_green.gif";
	gbic10GImgs.img["CYAN"].src = "images/10gig_cyan.gif";
	gbic10GImgs.img["BROWN"].src = "images/10gig_brown.gif";
	gbic10GImgs.img["YELLOW"].src = "images/10gig_yellow.gif";
	gbic10GImgs.img["AMBER"].src = "images/10gig_amber.gif";
	gbic10GImgs.img["BLINKGREEN"].src = "images/10gig_blinkgreen.gif";
	gbic10GImgs.img["ALT_GREEN_BLACK"].src = "images/10gig_blinkgreen.gif";
	gbic10GImgs.img["BLINKGREEN_AMBER"].src = "images/10gig_blinkgreen_amber.gif";
	gbic10GImgs.img["ALT_GREEN_AMBER"].src = "images/10gig_blinkgreen_amber.gif";
	return gbic10GImgs;
}

var gbic10GEmptyImgs = null;
// method to create GBIC 10Gig Empty port images
function GBIC_10GEmptyImages() {
	if(gbic10GEmptyImgs != null) return gbic10GEmptyImgs;
	gbic10GEmptyImgs = new portImages();
	gbic10GEmptyImgs.img["BLACK"].src = "images/10gig_empty.gif";
	gbic10GEmptyImgs.img["GREEN"].src = "images/10gig_empty_green.gif";
	gbic10GEmptyImgs.img["CYAN"].src = "images/10gig_empty.gif";
	gbic10GEmptyImgs.img["BROWN"].src = "images/10gig_empty_brown.gif";
	gbic10GEmptyImgs.img["YELLOW"].src = "images/10gig_empty_yellow.gif";	
	gbic10GEmptyImgs.img["AMBER"].src = "images/10gig_empty_amber.gif";
	gbic10GEmptyImgs.img["BLINKGREEN"].src = "images/10gig_empty.gif";
	gbic10GEmptyImgs.img["ALT_GREEN_BLACK"].src = "images/10gig_empty.gif";
	gbic10GEmptyImgs.img["BLINKGREEN_AMBER"].src = "images/10gig_empty.gif";
	gbic10GEmptyImgs.img["ALT_GREEN_AMBER"].src = "images/10gig_empty.gif";
	return gbic10GEmptyImgs;
}

//functions to avoid dragging of images
//addImageEvents can be called in the onload event of a document with the document itself as the parameter
//the function needs to be called each time a new IMG element is created in the document
var netscape = !document.all && document.getElementById;
var x, y, x1, y1;

function addImageEvents(frameDocument)
{
	if (!(document.getElementById || document.all || document.layers)) return;

	for (i=0;i<frameDocument.images.length;i++)
	{
		if(netscape) //netscape
		{
			frameDocument.images[i].onmousedown = imgMouseDown;
			frameDocument.images[i].onmouseup = function() {return false};
			frameDocument.images[i].onmousemove = imgMouseMove;
			//if image does not have a pre-defined onclick event or does not have a link cancel the click event
			if(!frameDocument.images[i].onclick && frameDocument.images[i].parentNode.tagName.toLowerCase() != "a") frameDocument.images[i].onclick = function() {return false};
		}
		else //IE
		{
			//when the drag event is cancelled the mouseout event needs to be called
			//to ensure that if there is a rollover image, it is restored to its original src
			frameDocument.images[i].ondrag = function() {this.fireEvent("onmouseout");return false};
		}
	}
}

//record the x and y co-ordinates of the mousedown event
function imgMouseDown(e)
{
	x = e.screenX;
	y = e.screenY;
	return false;
}

//check if the parent tag is an anchor tag or 
//if the new difference betn (x, y) and (x1, y1) is more than 10px
//assume it as an attempt to drag the image
function imgMouseMove(e)
{
	var tagname = '';
	x1 = e.screenX;
	y1 = e.screenY;
	if (e.target.parentNode)
		tagname = e.target.parentNode.tagName;
		
	if ((!(tagname.toLowerCase() == "a") || ((Math.abs(x-x1) > 10) || (Math.abs(y-y1) > 10))))
	{
		return false;
	}
}
