/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import javachart.chart.Axis;
import javachart.chart.AxisInterface;
import javachart.chart.Dataset;
import javachart.chart.Plotarea;

public class StackAxis
extends Axis
implements AxisInterface {
    protected boolean stackValues = true;

    public StackAxis() {
    }

    public StackAxis(Dataset[] datasetArray, boolean bl, Plotarea plotarea) {
        super(datasetArray, bl, plotarea);
    }

    protected double getMaxValsFromData(int n) {
        if (!this.stackValues) {
            return super.getMaxValsFromData(n);
        }
        int n2 = 0;
        double d = Double.MIN_VALUE;
        if (this.userAxisEnd != null) {
            return this.userAxisEnd;
        }
        int n3 = 0;
        while (n3 < n) {
            n2 = Math.max(n2, this.datasets[n3].data.size());
            ++n3;
        }
        if (!this.isXAxis) {
            n3 = 0;
            while (n3 < n2) {
                double d2 = 0.0;
                int n4 = 0;
                while (n4 < n) {
                    try {
                        d2 += this.datasets[n4].getDataElementAt((int)n3).y;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                    ++n4;
                }
                d = Math.max(d, d2);
                ++n3;
            }
        } else {
            n3 = 0;
            while (n3 < n2) {
                double d3 = 0.0;
                int n5 = 0;
                while (n5 < n) {
                    d3 += this.datasets[n5].getDataElementAt((int)n3).x;
                    ++n5;
                }
                d = Math.max(d, d3);
                ++n3;
            }
        }
        return d;
    }

    protected double getMinValsFromData(int n) {
        int n2 = 0;
        double d = Double.MAX_VALUE;
        if (!this.stackValues) {
            return super.getMinValsFromData(n);
        }
        if (this.userAxisStart != null) {
            return this.userAxisStart;
        }
        int n3 = 0;
        while (n3 < n) {
            n2 = Math.max(n2, this.datasets[n3].data.size());
            ++n3;
        }
        if (!this.isXAxis) {
            n3 = 0;
            while (n3 < n2) {
                double d2 = 0.0;
                int n4 = 0;
                while (n4 < n) {
                    try {
                        d2 += this.datasets[n4].getDataElementAt((int)n3).y;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                    ++n4;
                }
                d = Math.min(d, d2);
                ++n3;
            }
        } else {
            n3 = 0;
            while (n3 < n2) {
                double d3 = 0.0;
                int n5 = 0;
                while (n5 < n) {
                    try {
                        d3 += this.datasets[n5].getDataElementAt((int)n3).x;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                    ++n5;
                }
                d = Math.min(d, d3);
                ++n3;
            }
        }
        if (!this.isXAxis) {
            return Math.min(d, this.datasets[0].minY());
        }
        return Math.min(d, this.datasets[0].minX());
    }

    public boolean getStackValues() {
        return this.stackValues;
    }

    public void setStackValues(boolean bl) {
        this.stackValues = bl;
    }
}

