/*
 * Decompiled with CFR 0.152.
 */
public class UpdateNotify
extends Thread {
    ClusterPanel m_callee;
    static double m_call_period;
    double last_update_time;
    boolean allowed_to_run = true;
    boolean allowUpdates = true;

    UpdateNotify(ClusterPanel clusterPanel, double d) {
        this.m_callee = clusterPanel;
        this.setUpdatePeriod(d);
        this.setLastUpdateTime(System.currentTimeMillis());
    }

    public double getUpdatePeriod() {
        return m_call_period;
    }

    public void run() {
        while (this.allowed_to_run) {
            UpdateNotify updateNotify = this;
            synchronized (updateNotify) {
                try {
                    this.wait((long)(m_call_period / 10.0));
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("ClusterPanel : Thread interrupted");
                }
                if (!this.allowed_to_run) {
                    Object var4_3 = null;
                    break;
                }
            }
            double d = System.currentTimeMillis();
            if (!this.allowUpdates || !(d - this.last_update_time > m_call_period) || !this.m_callee.isShowing()) continue;
            System.out.println("Time since last update in ms = " + (d - this.last_update_time));
            this.m_callee.dynamicUpdate(false);
        }
    }

    public void setAllowUpdates(boolean bl) {
        System.out.println("View Updates are " + (bl ? "ENABLED" : "DISABLED"));
        this.allowUpdates = bl;
    }

    public void setLastUpdateTime(double d) {
        this.last_update_time = d;
    }

    public void setUpdatePeriod(double d) {
        m_call_period = d;
    }

    public void shutdown() {
        this.allowed_to_run = false;
    }
}

