/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Image;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

public class RelayNode
extends Node {
    private Node masterNode;
    private String masterPort;
    private String portLbl;
    private static int numberOfRelays = 0;
    private final int MIN_X = 25;
    private final int MIN_Y = 10;

    public RelayNode(ClusterPanel clusterPanel, Node node, String string) {
        super(clusterPanel);
        this.x = 25.0;
        this.y = 10.0;
        this.vbn = -1;
        this.masterNode = node;
        this.masterPort = string;
        this.portLbl = String.valueOf(node.hostLbl) + ":" + string;
        this.hostLbl = this.newRelayName();
        this.vbnLbl = this.deviceLbl = String.valueOf(this.hostLbl) + "_es0";
        this.hopCount = 0;
        this.clusterID = this.deviceLbl;
        this.switchStr = this.deviceLbl;
        try {
            this.devUrl = new URL("http://0.0.0.0/");
            this.consoleUrl = new URL("http://0.0.0.0/");
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println(malformedURLException);
        }
        this.bFixed = false;
        this.macAddr = "0000.0000.0000";
        this.upStreamMacAddr = "0000.0000.0000";
        this.candidateNeighborsShown = true;
        this.designation = 1;
        this.disqualificationCode = "0";
        this.bPlaced = false;
        this.bNeighborsPlaced = false;
        this.bStack = true;
        this.isVisible = true;
    }

    protected Image currentImage(boolean bl) {
        return ImageFactory.getEntry(ImageFactory.UNKNOWN_NODE).getImage();
    }

    protected String currentLabel(boolean bl, boolean bl2) {
        if (bl2) {
            return this.portLbl;
        }
        return this.hostLbl;
    }

    protected Color currentLabelColor() {
        return Color.yellow;
    }

    public boolean isRelay() {
        return true;
    }

    public boolean isSelectable() {
        return false;
    }

    private String newRelayName() {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append("Unknown");
        stringBuffer.append(numberOfRelays);
        ++numberOfRelays;
        return stringBuffer.toString();
    }

    public void placeYourself() {
        Object object;
        int n = 0;
        int n2 = 0;
        Hashtable<Node, Node> hashtable = new Hashtable<Node, Node>();
        Enumeration<Object> enumeration = this.getEdges().elements();
        while (enumeration.hasMoreElements()) {
            object = (Edge)enumeration.nextElement();
            hashtable.put(((Edge)object).fromPort.getDevice(), ((Edge)object).fromPort.getDevice());
            hashtable.put(((Edge)object).toPort.getDevice(), ((Edge)object).toPort.getDevice());
        }
        enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            object = (Node)enumeration.nextElement();
            n = (int)((double)n + ((Node)object).x);
            n2 = (int)((double)n2 + ((Node)object).y);
        }
        this.x = n / hashtable.size();
        this.y = n2 / hashtable.size();
        this.bPlaced = true;
    }

    public static void reset() {
        numberOfRelays = 0;
    }
}

