/*
 * Decompiled with CFR 0.152.
 */
package clairvoyant;

import java.awt.Graphics;
import java.awt.Point;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import javachart.chart.Dataset;
import javachart.chart.DateAxis;
import javachart.chart.Plotarea;

public class InsetDateAxis
extends DateAxis {
    double dataStart;
    double dataEnd;

    public InsetDateAxis() {
    }

    public InsetDateAxis(Dataset[] datasetArray, boolean bl, Plotarea plotarea) {
        super(datasetArray, bl, plotarea);
    }

    public void draw(Graphics graphics) {
        this.dateFormat = null;
        super.draw(graphics);
    }

    public void drawOverlays(Graphics graphics) {
        if (!this.globals.isThreeD() && this.getGridVis()) {
            this.drawGrids(graphics);
        }
    }

    protected void drawTicks(Graphics graphics) {
        int n;
        int n2;
        if (this.getMajTickVis()) {
            switch (this.getSide()) {
                case 0: {
                    this.startPoint = new Point((int)((double)this.globals.getMaxX() * this.plotarea.getLlX()), (int)((double)this.globals.getMaxY() * this.plotarea.getLlY()));
                    n2 = this.startPoint.y;
                    this.endPoint = new Point((int)((double)this.globals.getMaxX() * this.plotarea.getUrX()), (int)((double)this.globals.getMaxY() * this.plotarea.getLlY()));
                    this.increment = this.getIncrement(this.endPoint.x, this.startPoint.x, this.numMajTicks);
                    n = 0;
                    while (n < this.numMajTicks) {
                        this.getTickGc().drawLine(graphics, this.whereOnAxis(n, 4), n2, this.whereOnAxis(n, 4), n2 - this.getMajTickLength());
                        ++n;
                    }
                    break;
                }
                default: {
                    super.drawTicks(graphics);
                    break;
                }
            }
        }
        if (this.getMinTickVis()) {
            switch (this.getSide()) {
                case 0: {
                    this.startPoint = new Point((int)((double)this.globals.getMaxX() * this.plotarea.getLlX()), (int)((double)this.globals.getMaxY() * this.plotarea.getLlY()));
                    n2 = this.startPoint.y;
                    this.endPoint = new Point((int)((double)this.globals.getMaxX() * this.plotarea.getUrX()), (int)((double)this.globals.getMaxY() * this.plotarea.getLlY()));
                    this.increment = this.getIncrement(this.endPoint.x, this.startPoint.x, this.numMinTicks);
                    n = 0;
                    while (n < this.numMajTicks) {
                        this.getTickGc().drawLine(graphics, this.whereOnAxis(n, 4), n2, this.whereOnAxis(n, 4), n2 - this.getMinTickLength());
                        ++n;
                    }
                    break;
                }
                default: {
                    super.drawTicks(graphics);
                    break;
                }
            }
        }
    }

    public double getAxisEnd() {
        return this.dataEnd;
    }

    public double getAxisStart() {
        return this.dataStart;
    }

    protected int getDayIncrement(Date date, Date date2) {
        int n = 0;
        this.calendar.setTime(date);
        Calendar calendar = (Calendar)this.calendar.clone();
        calendar.setTime(date2);
        while (this.calendar.before(calendar)) {
            this.calendar.add(5, 1);
            ++n;
        }
        if (n <= 7) {
            return 1;
        }
        if (n <= 14) {
            return 2;
        }
        if (n <= 21) {
            return 3;
        }
        int n2 = n / 3;
        while (n2 % this.calendar.getMaximum(7) > 0) {
            ++n2;
        }
        return n2;
    }

    protected String getLabel(double d, int n) {
        if (this.dateFormat == null) {
            switch (this.getScalingType()) {
                case 1: {
                    this.dateFormat = DateFormat.getTimeInstance();
                    break;
                }
                case 2: {
                    this.dateFormat = DateFormat.getTimeInstance(3);
                    break;
                }
                case 3: {
                    this.dateFormat = DateFormat.getTimeInstance(3);
                    break;
                }
                case 4: {
                    this.dateFormat = DateFormat.getDateInstance(3);
                    break;
                }
                case 5: {
                    this.dateFormat = DateFormat.getDateInstance(3);
                    break;
                }
                case 6: {
                    this.dateFormat = DateFormat.getDateInstance(3);
                    break;
                }
                case 7: {
                    this.dateFormat = DateFormat.getDateInstance(3);
                }
            }
            this.secondaryUserDateFormat = this.dateFormat;
        }
        return super.getLabel(d, n);
    }

    protected double getMaxValsFromData(int n) {
        this.dataEnd = super.getMaxValsFromData(n);
        return this.dataEnd;
    }

    protected double getMinValsFromData(int n) {
        this.dataStart = super.getMinValsFromData(n);
        return this.dataStart;
    }

    protected int whereOnAxis(int n, int n2) {
        int n3 = super.whereOnAxis(n, n2);
        double d = (double)(n3 -= this.startPoint.x) / ((double)this.endPoint.x - (double)this.startPoint.x);
        double d2 = this.endPoint.x - this.startPoint.x;
        double d3 = (this.axisEnd - this.axisStart) / (this.dataEnd - this.dataStart);
        double d4 = d2 * d3;
        double d5 = (this.axisStart - this.dataStart) / (this.axisEnd - this.axisStart);
        double d6 = d4 * d5;
        double d7 = (double)n3 / d2 * d4 + d6;
        int n4 = (int)Math.round(d7) + this.startPoint.x + 1;
        if (n4 > this.endPoint.x || n4 < this.startPoint.x) {
            return -200;
        }
        return n4;
    }
}

