/*
 * Decompiled with CFR 0.152.
 */
public class Validation {
    private Validation() {
    }

    public static boolean isMACAddress(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        if (string.length() != 14) {
            return false;
        }
        if (string.equals("0000.0000.0000")) {
            return false;
        }
        if (string.equals("ffff.ffff.ffff")) {
            return false;
        }
        if (string.equals("FFFF.FFFF.FFFF")) {
            return false;
        }
        if (string.charAt(4) != '.' || string.charAt(9) != '.') {
            return false;
        }
        int n = 0;
        while (n < 3) {
            int n2 = 0;
            while (n2 < 4) {
                if (!Validation.is_hex(string.charAt(n * 5 + n2))) {
                    return false;
                }
                ++n2;
            }
            ++n;
        }
        return true;
    }

    protected static boolean isVLANID(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        return Validation.isValidInteger(string, 1, 1005);
    }

    public static boolean isValidInteger(String string) {
        if (string == null) {
            return false;
        }
        try {
            Integer n = new Integer(string.trim());
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isValidInteger(String string, int n, int n2) {
        if (string == null) {
            return false;
        }
        try {
            Integer n3 = new Integer(string.trim());
            int n4 = n3;
            return n4 >= n && n4 <= n2;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean is_hex(char c) {
        return Character.digit(c, 16) != -1;
    }
}

