/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class PortMappingBasic_JDialog
extends JDialog
implements ActionListener {
    JButton ok_JButton;
    JButton cancel_JButton;
    JButton help_JButton;
    JButton advanced_JButton;
    JApplet theApplet;
    CommonSwitch[] switches;
    PortConfig_JDialog parent;
    int[] selection;
    PortConfigTableModel configTableModel;
    JTextField description_JTextField = null;
    JTextField fixed_JTextField = null;
    JTextField incr_JTextField = null;
    boolean isNum;

    public PortMappingBasic_JDialog(JApplet jApplet, CommonSwitch[] commonSwitchArray, PortConfig_JDialog portConfig_JDialog, int[] nArray) {
        super((Frame)null);
        Object object;
        this.setDefaultCloseOperation(2);
        this.theApplet = this.theApplet;
        this.switches = commonSwitchArray;
        this.parent = portConfig_JDialog;
        this.selection = nArray;
        this.configTableModel = portConfig_JDialog.portConfigTableModel;
        JPanel jPanel = new JPanel();
        if (nArray.length == 1) {
            object = (String)this.configTableModel.getValueAt(nArray[0], 0);
            this.setTitle("Basic Port Description: " + (String)object);
            jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            int n = nArray[0];
            String string = (String)this.configTableModel.getValueAt(n, 8);
            this.description_JTextField = new JTextField(string, 15);
            jPanel.setLayout(new GridLayout(2, 2));
            jPanel.add(new JLabel("Interface: "));
            jPanel.add(new JLabel((String)this.configTableModel.getValueAt(n, 0)));
            jPanel.add(new JLabel("Description: "));
            jPanel.add(this.description_JTextField);
        } else {
            this.setTitle("Basic Port Description: Multiple Ports");
            object = new JPanel(new BorderLayout());
            ((JComponent)object).setBorder(new TitledBorder("Starting Description"));
            JPanel jPanel2 = new JPanel();
            String string = (String)this.configTableModel.getValueAt(nArray[0], 8);
            String string2 = new String("");
            if (!string.trim().equals("")) {
                int n = string.length() - 1;
                char c = string.charAt(n);
                if (Character.isLetter(c)) {
                    string2 = String.valueOf(c);
                    --n;
                } else {
                    n = string.length() - 1;
                    while (n >= 0) {
                        c = string.charAt(n);
                        if (!Character.isDigit(c)) break;
                        string2 = String.valueOf(c).concat(string2);
                        --n;
                    }
                }
                this.fixed_JTextField = new JTextField(string.substring(0, n + 1));
                this.incr_JTextField = new JTextField(string2, 3);
            } else {
                this.fixed_JTextField = new JTextField(10);
                this.incr_JTextField = new JTextField(3);
            }
            jPanel2.add(new JLabel("Fixed Text"));
            jPanel2.add(this.fixed_JTextField);
            jPanel2.add(this.incr_JTextField);
            jPanel2.add(new JLabel("Increment"));
            ((Container)object).add((Component)jPanel2, "Center");
            JPanel jPanel3 = new JPanel(new FlowLayout(2));
            this.advanced_JButton = new JButton("Advanced...");
            this.advanced_JButton.addActionListener(this);
            jPanel3.add(this.advanced_JButton);
            ((Container)object).add((Component)jPanel3, "South");
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)object, "Center");
        }
        object = new JPanel(new FlowLayout(1));
        this.ok_JButton = new JButton("OK");
        this.ok_JButton.setDefaultCapable(true);
        this.cancel_JButton = new JButton("Cancel");
        this.help_JButton = new JButton("Help");
        this.ok_JButton.addActionListener(this);
        this.cancel_JButton.addActionListener(this);
        this.help_JButton.addActionListener(this);
        ((Container)object).add(this.ok_JButton);
        ((Container)object).add(this.cancel_JButton);
        ((Container)object).add(this.help_JButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)object, "South");
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.ok_JButton) {
            this.clickOK();
        } else if (object == this.cancel_JButton) {
            this.clickCancel();
        } else if (object == this.help_JButton) {
            this.clickHelp();
        } else if (object == this.advanced_JButton) {
            this.clickAdvanced();
        }
    }

    private void clickAdvanced() {
        String string = String.valueOf(this.fixed_JTextField.getText()) + this.incr_JTextField.getText();
        PortMappingAdvanced_JDialog portMappingAdvanced_JDialog = new PortMappingAdvanced_JDialog(this.parent, this, string);
        ModalDialog.show((RootPaneContainer)this.parent, (Dialog)portMappingAdvanced_JDialog, null);
        this.dispose();
    }

    private void clickCancel() {
        this.dispose();
    }

    private void clickHelp() {
        HelpDialog.Factory.showHelp((JApplet)this.parent.theApplet, (String)"prtdescb");
    }

    private void clickOK() {
        if (this.description_JTextField != null) {
            String string = this.description_JTextField.getText();
            if (PortMappingBasic_JDialog.isValidText(string)) {
                this.updateDescription(this.selection[0], string);
            } else {
                JOptionPane.showMessageDialog(this, "Description contains invalid characters.\nOnly alphanumeric characters, spaces, '-' and '_' are allowed.", "Invalid Description", 0);
            }
        } else {
            try {
                int n;
                String string = this.fixed_JTextField.getText();
                String string2 = this.incr_JTextField.getText();
                if (string.trim().equals("") && string2.trim().equals("")) {
                    int n2 = 0;
                    while (n2 < this.selection.length) {
                        this.updateDescription(this.selection[n2], "");
                        ++n2;
                    }
                    this.dispose();
                    return;
                }
                if (!PortMappingBasic_JDialog.isValidText(string)) {
                    JOptionPane.showMessageDialog(this, "Fixed text contains invalid characters.\nOnly alphanumeric characters, spaces, '-' and '_' are allowed.", "Invalid Description", 0);
                    return;
                }
                int n3 = 0;
                char c = 'A';
                this.isNum = (string2.length() == 1 && Character.isLetter(string2.charAt(0))) ^ true;
                if (this.isNum) {
                    n3 = Integer.valueOf(string2);
                    string2 = String.valueOf(n3);
                } else {
                    c = string2.charAt(0);
                    n = 1;
                    while (n <= this.selection.length) {
                        if (!Character.isLetter((char)(c + n))) {
                            JOptionPane.showMessageDialog(this, "Selection contains too many ports to\nbe autofilled by alphabetical letters.", "Invalid Increment Value", 0);
                            return;
                        }
                        ++n;
                    }
                }
                ((Component)this).setCursor(new Cursor(3));
                this.parent.setCursor(new Cursor(3));
                n = 0;
                while (n < this.selection.length) {
                    this.updateDescription(this.selection[n], string.concat(string2));
                    if (this.isNum) {
                        string2 = String.valueOf(++n3);
                    } else {
                        c = (char)(c + 1);
                        string2 = String.valueOf(c);
                    }
                    ++n;
                }
                ((Component)this).setCursor(new Cursor(0));
                this.parent.setCursor(new Cursor(0));
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, "Increment is not a numerical or letter value.", "Invalid Increment Value", 0);
                return;
            }
        }
        this.dispose();
    }

    static boolean isValidText(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!Character.isLetterOrDigit(c) && !Character.isSpace(c) && c != '-' && c != '_') {
                return false;
            }
            ++n;
        }
        return true;
    }

    void updateDescription(int n, String string) {
        String string2 = (String)this.configTableModel.getValueAt(n, 0);
        String string3 = this.switches[this.parent.switchIndex].esn;
        this.switches[this.parent.switchIndex].Cli.setPortDescription(string3, string2, string);
        this.configTableModel.updatePortDescription(string2, string);
    }
}

