/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class FloodingControl
extends DeviceComboDialog {
    public static final String BROADCAST_CLI = "";
    public static final String NEW_BROADCAST_CLI = "/broadcast";
    public static final String UNICAST_CLI = "/unicast";
    public static final String MULTICAST_CLI = "/multicast";
    public static final String BROADCAST_TITLE = "Broadcast Storm";
    public static final String UNICAST_TITLE = "Unicast Storm";
    public static final String MULTICAST_TITLE = "Multicast Storm";
    public static final int BROADCAST_TAB = 0;
    public static final int UNICAST_TAB = 1;
    public static final int MULTICAST_TAB = 2;
    protected boolean newCli;
    protected FloodingControlGui gui;

    public FloodingControl(JApplet jApplet, CommonSwitch[] commonSwitchArray) {
        this(jApplet, commonSwitchArray, null);
    }

    public FloodingControl(JApplet jApplet, CommonSwitch[] commonSwitchArray, CommonSwitch commonSwitch) {
        super(jApplet, commonSwitchArray, commonSwitch);
        this.constructorInit();
    }

    protected void deviceChanged() {
        this.newCli = this.device.Cli.isUnicastStormSupported(this.device.esn);
        if (this.device.deviceType.indexOf("C2950") != -1) {
            this.gui.tabbedPanel.setSelectedIndex(0);
            if (this.gui.tabbedPanel.getComponentCount() == 4) {
                this.gui.tabbedPanel.remove(this.gui.unknownMacPanel);
            }
        } else if (this.gui.tabbedPanel.getComponentCount() == 3) {
            this.gui.tabbedPanel.addTab("unknownMacPanel", this.gui.unknownMacPanel);
        }
    }

    protected String getButtonsNeeded() {
        String string = "OK MODIFY REFRESH HELP ";
        return string;
    }

    protected JPanel getContentPanel() {
        this.gui = new FloodingControlGui();
        return this.gui;
    }

    protected String getHelpUrl() {
        String string = BROADCAST_CLI;
        JPanel jPanel = (JPanel)this.gui.tabbedPanel.getSelectedComponent();
        if (jPanel == this.gui.broadcastPanel) {
            string = BROADCAST_CLI;
        } else if (jPanel == this.gui.unicastPanel) {
            string = BROADCAST_CLI;
        } else if (jPanel == this.gui.multicastPanel) {
            string = BROADCAST_CLI;
        } else if (jPanel == this.gui.unknownMacPanel) {
            string = BROADCAST_CLI;
        }
        return "fldctlwn";
    }

    protected void getMirrorObjects(Vector vector) {
        vector.addElement(new Storm(this.gui.broadcastPanel, this.gui.broadcastTable, BROADCAST_CLI, BROADCAST_TITLE, 0));
        vector.addElement(new Storm(this.gui.unicastPanel, this.gui.unicastTable, UNICAST_CLI, UNICAST_TITLE, 1));
        vector.addElement(new Storm(this.gui.multicastPanel, this.gui.multicastTable, MULTICAST_CLI, MULTICAST_TITLE, 2));
        vector.addElement(new UnknownMacs());
    }

    protected void getSelectedPorts(JTable jTable, Vector vector, Vector vector2) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)jTable.getModel();
        int[] nArray = jTable.getSelectedRows();
        int n = 0;
        while (n < nArray.length) {
            vector.addElement(this.device);
            String string = (String)defaultTableModel.getValueAt(nArray[n], 0);
            vector2.addElement(string);
            ++n;
        }
    }

    protected String getWindowTitle() {
        return "Flooding Control";
    }

    protected boolean isDeviceSupported(CommonSwitch commonSwitch) {
        return Switch.type(commonSwitch.switchBoxName) != 0;
    }

    protected class Storm
    implements DeviceMirrorObject,
    ListSelectionListener,
    ActionListener,
    ChangeListener,
    Runnable,
    ModalDialog.ParentDelegate {
        String stormCli;
        String stormTitle;
        int stormTab;
        Vector[] data;
        int numCols;
        protected JPanel guiPanel;
        protected JTable guiTable;
        protected int filterStateCol = 1;
        protected int trapStateCol = 3;
        protected int risingThresholdCol = 5;
        protected int fallingThresholdCol = 6;
        protected NonEditableTableModel tableModel;
        protected String[] columnNames;
        private int ugfmStartCol;
        private int ugfmNumCols;
        private int ugfmNumRows;

        protected Storm(JPanel jPanel, JTable jTable, String string, String string2, int n) {
            this.guiPanel = jPanel;
            this.guiTable = jTable;
            this.stormCli = string;
            this.stormTitle = string2;
            this.stormTab = n;
            this.ugfmStartCol = 0;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FloodingConfigDialog floodingConfigDialog;
            JPanel jPanel = (JPanel)FloodingControl.this.gui.tabbedPanel.getSelectedComponent();
            if (jPanel != this.guiPanel) {
                return;
            }
            FloodingControl.this.setPreventUserOps(true);
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            FloodingControl.this.getSelectedPorts(this.guiTable, vector, vector2);
            FloodingConfigDialog floodingConfigDialog2 = floodingConfigDialog = new FloodingConfigDialog(FloodingControl.this.applet);
            floodingConfigDialog2.getClass();
            FloodingConfigDialog.Storm storm = floodingConfigDialog2.new FloodingConfigDialog.Storm(this.stormCli, this.stormTitle);
            storm.setMirrorData(this.data[0], this.guiTable.getSelectedRows());
            storm.setMirrorCols(this.filterStateCol, this.trapStateCol, this.risingThresholdCol, this.fallingThresholdCol);
            storm.setMirrorVals("Enabled", "Disabled");
            floodingConfigDialog.completeConstruction(vector, vector2, storm);
            ModalDialog.show((RootPaneContainer)FloodingControl.this, (Dialog)floodingConfigDialog, (ModalDialog.ParentDelegate)this);
            FloodingControl.this.setPreventUserOps(false);
        }

        public void hookupListeners() {
            ListSelectionModel listSelectionModel = this.guiTable.getSelectionModel();
            listSelectionModel.addListSelectionListener(this);
            FloodingControl.this.gui.tabbedPanel.addChangeListener(this);
            FloodingControl.this.modifyButton.addActionListener(this);
        }

        public void initializeMembers() {
            this.data = new Vector[2];
            this.data[0] = new Vector();
            this.data[1] = new Vector();
            this.tableModel = new NonEditableTableModel();
            this.guiTable.setModel(this.tableModel);
            this.columnNames = new String[]{"Interface", "Action State", "Action Status", "Trap State", "Trap Status", "Rising Threshold", "Falling Threshold", "Packets", "Traps Sent"};
            this.numCols = this.columnNames.length;
            this.tableModel.setColumnIdentifiers(this.columnNames);
            FloodingControl.this.setTableColumnTitleToolTips(this.guiTable);
        }

        public void modalDialogClosed(Dialog dialog) {
            this.updateGuiFromMirror();
        }

        public void run() {
            this.updateGuiFromMirror();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (object == FloodingControl.this.gui.tabbedPanel) {
                this.updateModifyButton();
            } else if (object == this) {
                SwingUtilities.invokeLater(this);
            }
        }

        public void ugfmAlways() {
            this.ugfmNumCols = this.data[0].size();
            int n = this.ugfmStartCol;
            while (n < this.ugfmNumCols) {
                String[] stringArray = (String[])this.data[0].elementAt(n);
                int n2 = 0;
                while (n2 < this.ugfmNumRows) {
                    this.tableModel.setValueAt(stringArray[n2], n2, n);
                    ++n2;
                }
                ++this.ugfmStartCol;
                ++n;
            }
        }

        public void ugfmFinal() {
            this.ugfmStartCol = 0;
            this.guiTable.repaint();
            this.updateModifyButton();
        }

        public void ugfmInitial() {
            this.ugfmStartCol = 0;
            if (this.data[0].size() == 0) {
                this.tableModel.setNumRows(0);
                DeviceDialog.setContainerEnabled(this.guiPanel, false);
                FloodingControl.this.gui.tabbedPanel.setEnabledAt(this.stormTab, false);
                return;
            }
            if (!this.guiPanel.isEnabled()) {
                DeviceDialog.setContainerEnabled(this.guiPanel, true);
                FloodingControl.this.gui.tabbedPanel.setEnabledAt(this.stormTab, true);
            }
            this.ugfmNumRows = ((String[])this.data[0].elementAt(0)).length;
            this.tableModel.setNumRows(this.ugfmNumRows);
        }

        public void updateDeviceFromMirror() {
        }

        public void updateGuiFromMirror() {
            if (this.ugfmStartCol == 0) {
                this.ugfmInitial();
            }
            if (this.data[0].size() == 0) {
                return;
            }
            this.ugfmAlways();
            if (this.ugfmStartCol == this.numCols) {
                this.ugfmFinal();
            }
        }

        public void updateMirrorFromDevice() {
            FloodingControl.this.device.Cli.getStormInfo((ChangeListener)this, this.data[0], FloodingControl.this.device.esn, this.stormCli, FloodingControl.this.newCli);
        }

        public void updateMirrorFromGui() {
        }

        protected void updateModifyButton() {
            JPanel jPanel = (JPanel)FloodingControl.this.gui.tabbedPanel.getSelectedComponent();
            if (jPanel != this.guiPanel) {
                return;
            }
            ListSelectionModel listSelectionModel = this.guiTable.getSelectionModel();
            FloodingControl.this.enableModify = listSelectionModel.isSelectionEmpty() ^ true;
            FloodingControl.this.updateBottomButtons();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            this.updateModifyButton();
        }
    }

    protected class UnknownMacs
    implements DeviceMirrorObject,
    ListSelectionListener,
    ActionListener,
    ChangeListener,
    Runnable,
    ModalDialog.ParentDelegate {
        Vector[] data;
        int numCols;
        protected int unicastCol = 1;
        protected int multicastCol = 2;
        protected NonEditableTableModel tableModel;
        protected String[] columnNames;
        private int ugfmStartCol;
        private int ugfmNumCols;
        private int ugfmNumRows;

        protected UnknownMacs() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JPanel jPanel = (JPanel)FloodingControl.this.gui.tabbedPanel.getSelectedComponent();
            if (jPanel != FloodingControl.this.gui.unknownMacPanel) {
                return;
            }
            FloodingControl.this.setPreventUserOps(true);
            JTable jTable = FloodingControl.this.gui.unknownMacTable;
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            FloodingControl.this.getSelectedPorts(jTable, vector, vector2);
            FloodingConfigDialog floodingConfigDialog = new FloodingConfigDialog(FloodingControl.this.applet);
            FloodingConfigDialog.UnknownMacs unknownMacs = floodingConfigDialog.new FloodingConfigDialog.UnknownMacs();
            unknownMacs.setMirrorData(this.data[0], jTable.getSelectedRows());
            unknownMacs.setMirrorCols(this.unicastCol, this.multicastCol);
            unknownMacs.setMirrorVals("Not Blocked", "Blocked");
            floodingConfigDialog.completeConstruction(vector, vector2, unknownMacs);
            ModalDialog.show((RootPaneContainer)FloodingControl.this, (Dialog)floodingConfigDialog, (ModalDialog.ParentDelegate)this);
            FloodingControl.this.setPreventUserOps(false);
        }

        public void hookupListeners() {
            ListSelectionModel listSelectionModel = FloodingControl.this.gui.unknownMacTable.getSelectionModel();
            listSelectionModel.addListSelectionListener(this);
            FloodingControl.this.gui.tabbedPanel.addChangeListener(this);
            FloodingControl.this.modifyButton.addActionListener(this);
        }

        public void initializeMembers() {
            this.data = new Vector[2];
            this.data[0] = new Vector();
            this.data[1] = new Vector();
            this.tableModel = new NonEditableTableModel();
            FloodingControl.this.gui.unknownMacTable.setModel(this.tableModel);
            this.columnNames = new String[]{"Interface", "Unicast", "Multicast"};
            this.numCols = this.columnNames.length;
            this.tableModel.setColumnIdentifiers(this.columnNames);
            FloodingControl.this.setTableColumnTitleToolTips(FloodingControl.this.gui.unknownMacTable);
        }

        public void modalDialogClosed(Dialog dialog) {
            this.updateGuiFromMirror();
        }

        public void run() {
            this.updateGuiFromMirror();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (object == FloodingControl.this.gui.tabbedPanel) {
                this.updateModifyButton();
            } else if (object == this) {
                SwingUtilities.invokeLater(this);
            }
        }

        public void ugfmAlways() {
            this.ugfmNumCols = this.data[0].size();
            int n = this.ugfmStartCol;
            while (n < this.ugfmNumCols) {
                String[] stringArray = (String[])this.data[0].elementAt(n);
                int n2 = 0;
                while (n2 < this.ugfmNumRows) {
                    this.tableModel.setValueAt(stringArray[n2], n2, n);
                    ++n2;
                }
                ++this.ugfmStartCol;
                ++n;
            }
        }

        public void ugfmFinal() {
            this.ugfmStartCol = 0;
            FloodingControl.this.gui.unknownMacTable.repaint();
            this.updateModifyButton();
        }

        public void ugfmInitial() {
            this.ugfmStartCol = 0;
            this.ugfmNumRows = ((String[])this.data[0].elementAt(0)).length;
            this.tableModel.setNumRows(this.ugfmNumRows);
        }

        public void updateDeviceFromMirror() {
        }

        public void updateGuiFromMirror() {
            if (this.ugfmStartCol == 0) {
                this.ugfmInitial();
            }
            if (this.data[0].size() == 0) {
                return;
            }
            this.ugfmAlways();
            if (this.ugfmStartCol == this.numCols) {
                this.ugfmFinal();
            }
        }

        public void updateMirrorFromDevice() {
            FloodingControl.this.device.Cli.getUnknownMacsInfo((ChangeListener)this, this.data[0], FloodingControl.this.device.esn);
        }

        public void updateMirrorFromGui() {
        }

        protected void updateModifyButton() {
            JPanel jPanel = (JPanel)FloodingControl.this.gui.tabbedPanel.getSelectedComponent();
            if (jPanel != FloodingControl.this.gui.unknownMacPanel) {
                return;
            }
            ListSelectionModel listSelectionModel = FloodingControl.this.gui.unknownMacTable.getSelectionModel();
            FloodingControl.this.enableModify = listSelectionModel.isSelectionEmpty() ^ true;
            FloodingControl.this.updateBottomButtons();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            this.updateModifyButton();
        }
    }
}

