/*
 * Decompiled with CFR 0.152.
 */
import custom.CiscoChartPanel;

public class GraphMapper
extends Thread {
    private CiscoChartPanel chartPanel;
    private DataCollector collector;
    private String[] dataSetName = new String[3];
    private boolean running = true;
    private boolean zoomable = false;
    private int maxDataPoints;
    private int pollingInterval;
    private int dataType;
    private long startTime = 0L;
    private long endTime = 0L;
    public static final int LINK_UTIL_TYPE = 0;
    public static final int LINK_BYTES_TYPE = 1;
    public static final int LINK_PACKETS_TYPE = 2;
    public static final int LINK_ERRORS_TYPE = 3;
    public static final int DEVICE_BANDWIDTH_TYPE = 4;

    public GraphMapper(CommonSwitch commonSwitch, String string, CiscoChartPanel ciscoChartPanel, int n, int n2, int n3) {
        this.chartPanel = ciscoChartPanel;
        this.pollingInterval = n2;
        this.maxDataPoints = n3;
        this.dataType = n;
        this.collector = new DataCollector(commonSwitch, string, ciscoChartPanel, n, this.dataSetName, n2);
        this.setTimeSpan(true);
        this.setDataType(n);
    }

    public void run() {
        while (this.running) {
            switch (this.dataType) {
                case 4: {
                    this.collector.addDeviceData();
                    break;
                }
                default: {
                    this.collector.addLinkData();
                }
            }
            try {
                Thread.sleep(this.pollingInterval);
            }
            catch (Exception exception) {
                return;
            }
            this.setTimeSpan(false);
        }
    }

    public void setDataType(int n) {
        this.dataType = n;
        this.collector.setDataType(n);
        this.chartPanel.getChart().clearAllDatasets();
        this.setTimeSpan(true);
        switch (n) {
            case 0: {
                this.dataSetName[0] = "Utilization";
                this.dataSetName[1] = "none";
                this.dataSetName[2] = "none";
                this.chartPanel.getChart().getYAxis().setTitleString(" % Utilization");
                break;
            }
            case 1: {
                this.dataSetName[0] = "Total Bytes";
                this.dataSetName[1] = "Total Received";
                this.dataSetName[2] = "Total Transmitted";
                this.chartPanel.getChart().getYAxis().setTitleString("kBytes");
                this.chartPanel.getChart().getYAxis().setLabelPrecision(3);
                break;
            }
            case 2: {
                this.dataSetName[0] = "Total Packets";
                this.dataSetName[1] = "Unicast Packets";
                this.dataSetName[2] = "Bcast&Mcast Packets";
                this.chartPanel.getChart().getYAxis().setTitleString("kPackets");
                this.chartPanel.getChart().getYAxis().setLabelPrecision(3);
                break;
            }
            case 3: {
                this.dataSetName[0] = "Total Errors";
                this.dataSetName[1] = "Total Packets Dropped";
                this.dataSetName[2] = "none";
                this.chartPanel.getChart().getYAxis().setTitleString("Number of Errors");
                this.chartPanel.getChart().getYAxis().setLabelPrecision(0);
                break;
            }
            case 4: {
                this.dataSetName[0] = "Bandwidth Usage";
                this.chartPanel.getChart().getYAxis().setTitleString("Mbps");
                this.chartPanel.getChart().getYAxis().setLabelPrecision(5);
                break;
            }
        }
    }

    public void setDevice(CommonSwitch commonSwitch) {
        this.setTimeSpan(true);
        this.collector.setDevice(commonSwitch);
    }

    public void setPollingInterval(int n) {
        this.pollingInterval = n;
    }

    public void setPort(String string) {
        this.setTimeSpan(true);
        this.collector.setPort(string);
    }

    public void setRunning(boolean bl) {
        this.running = bl;
    }

    public synchronized void setTimeSpan(boolean bl) {
        long l = System.currentTimeMillis();
        if (bl) {
            this.startTime = System.currentTimeMillis();
            this.endTime = this.startTime + (long)(this.pollingInterval * this.maxDataPoints);
            this.chartPanel.getChart().getXAxis().setAxisStart((double)this.startTime);
            this.chartPanel.getChart().getXAxis().setAxisEnd((double)this.endTime);
            this.chartPanel.setUnZoomTimeSpan((long)(this.pollingInterval * this.maxDataPoints));
        } else if (l >= this.endTime) {
            this.endTime += (long)this.pollingInterval;
            this.chartPanel.getChart().getXAxis().setAxisEnd((double)this.endTime);
            this.startTime = this.endTime - (long)(this.pollingInterval * this.maxDataPoints);
            this.chartPanel.getChart().getXAxis().setAxisStart((double)this.startTime);
        }
    }

    public void setZoomable(boolean bl) {
        this.zoomable = bl;
    }
}

