/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IGMPSnoopDialog
extends JDialog
implements ActionListener,
ItemListener,
TabbedPaneListener {
    boolean frameSizeAdjusted = false;
    JPanel deviceList_JPanel = new JPanel();
    JComboBox devices_JCombo = new JComboBox();
    JButton okButton = new JButton("OK");
    JButton modifyButton = new JButton("Modify ...");
    JButton cancelButton = new JButton("Cancel");
    JButton helpButton = new JButton("Help");
    private CommonSwitch[] switches = null;
    private CommonSwitch theSwitch = null;
    private JApplet theApplet = null;
    JTabbedPane vlan_JTabbedPane = new JTabbedPane();
    IGMPSettingsPanel igmpSettingsPanel = null;
    MultiCastPanel multiCastPanel = null;
    MultiRouterPortsPanel multiRouterPanel = null;

    public IGMPSnoopDialog(Frame frame, JApplet jApplet, CommonSwitch[] commonSwitchArray, CommonSwitch commonSwitch) {
        super(frame);
        int n;
        this.theApplet = jApplet;
        this.switches = commonSwitchArray;
        this.theSwitch = commonSwitch;
        if (this.theSwitch == null) {
            this.theSwitch = commonSwitchArray[0];
            n = 0;
            while (n < commonSwitchArray.length) {
                if (commonSwitchArray[n].memberType.equals("CC") || commonSwitchArray[n].memberType.equals("AC")) {
                    this.theSwitch = commonSwitchArray[n];
                    break;
                }
                ++n;
            }
        }
        this.setTitle("IGMP Snooping");
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        ((Component)this).setSize(405, 305);
        this.setVisible(false);
        this.deviceList_JPanel.setLayout(new FlowLayout(1, 5, 5));
        this.getContentPane().add("North", this.deviceList_JPanel);
        this.deviceList_JPanel.setBounds(0, 0, 513, 62);
        this.deviceList_JPanel.add(new JLabel("Host Name:"));
        if (jApplet.getClass().getName().equalsIgnoreCase("DeviceManager")) {
            this.deviceList_JPanel.add(new JLabel(this.theSwitch.switchName));
            this.deviceList_JPanel.setBorder(BorderFactory.createTitledBorder(""));
        } else {
            this.deviceList_JPanel.add(this.devices_JCombo);
            this.devices_JCombo.setBounds(191, 25, 130, 27);
            this.deviceList_JPanel.setBorder(BorderFactory.createTitledBorder("Device List"));
            n = 0;
            while (n < commonSwitchArray.length) {
                if (commonSwitchArray[n].supportIGMPSnooping()) {
                    this.devices_JCombo.addItem(commonSwitchArray[n].switchName);
                }
                ++n;
            }
            this.devices_JCombo.setSelectedItem(this.theSwitch.switchName);
            this.devices_JCombo.addItemListener(this);
        }
        this.igmpSettingsPanel = new IGMPSettingsPanel(this.theApplet, this.theSwitch);
        this.igmpSettingsPanel.addTabbedPaneListener(this);
        this.multiCastPanel = new MultiCastPanel(this.theApplet, this.theSwitch);
        this.multiCastPanel.addTabbedPaneListener(this);
        this.multiRouterPanel = new MultiRouterPortsPanel(this.theApplet, this.theSwitch);
        this.multiRouterPanel.addTabbedPaneListener(this);
        this.vlan_JTabbedPane.add("Settings", this.igmpSettingsPanel);
        this.vlan_JTabbedPane.add("Multicast Groups", this.multiCastPanel);
        this.vlan_JTabbedPane.add("Multicast Router Ports", this.multiRouterPanel);
        this.vlan_JTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Object object = changeEvent.getSource();
                if (IGMPSnoopDialog.this.vlan_JTabbedPane.getSelectedIndex() == 0) {
                    IGMPSnoopDialog.this.modifyButton.setEnabled(IGMPSnoopDialog.this.igmpSettingsPanel.getModifyButtonStatus());
                } else if (IGMPSnoopDialog.this.vlan_JTabbedPane.getSelectedIndex() == 1) {
                    IGMPSnoopDialog.this.modifyButton.setEnabled(IGMPSnoopDialog.this.multiCastPanel.getModifyButtonStatus());
                    IGMPSnoopDialog.this.multiCastPanel.setremoveButtonStatus(IGMPSnoopDialog.this.multiCastPanel.getModifyButtonStatus());
                } else if (IGMPSnoopDialog.this.vlan_JTabbedPane.getSelectedIndex() == 2) {
                    IGMPSnoopDialog.this.modifyButton.setEnabled(IGMPSnoopDialog.this.multiRouterPanel.getModifyButtonStatus());
                    IGMPSnoopDialog.this.multiRouterPanel.setremoveButtonStatus(IGMPSnoopDialog.this.multiRouterPanel.getModifyButtonStatus());
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.vlan_JTabbedPane, "Center");
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 5, 5));
        jPanel2.add(this.okButton);
        jPanel2.add(this.modifyButton);
        this.modifyButton.setEnabled(false);
        jPanel2.add(this.cancelButton);
        jPanel2.add(this.helpButton);
        this.getContentPane().add((Component)jPanel2, "South");
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.modifyButton.addActionListener(this);
        this.helpButton.addActionListener(this);
    }

    public IGMPSnoopDialog(JApplet jApplet, CommonSwitch commonSwitch) {
        this(null, jApplet, null, commonSwitch);
    }

    public IGMPSnoopDialog(JApplet jApplet, CommonSwitch[] commonSwitchArray) {
        this(null, jApplet, commonSwitchArray, null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.modifyButton) {
            if (this.vlan_JTabbedPane.getSelectedIndex() == 0) {
                this.igmpSettingsPanel.applyChanges();
            }
            if (this.vlan_JTabbedPane.getSelectedIndex() == 1) {
                this.multiCastPanel.applyChanges();
            }
            if (this.vlan_JTabbedPane.getSelectedIndex() == 2) {
                this.multiRouterPanel.applyChanges();
            }
        } else if (object == this.okButton || object == this.cancelButton) {
            this.dispose();
        } else if (object == this.helpButton) {
            HelpDialog.Factory.showHelp((JApplet)this.theApplet, (String)"igmpsnp");
        }
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.frameSizeAdjusted) {
            return;
        }
        this.frameSizeAdjusted = true;
        Insets insets = this.getInsets();
        ((Component)this).setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
    }

    public void dataChanged() {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.devices_JCombo) {
            String string = (String)this.devices_JCombo.getSelectedItem();
            int n = 0;
            while (n < this.switches.length) {
                if (this.switches[n].switchName.equals(string)) {
                    this.theSwitch = this.switches[n];
                    break;
                }
                ++n;
            }
            ((Component)this).setCursor(new Cursor(3));
            this.igmpSettingsPanel.setSwitch(this.theSwitch);
            this.multiCastPanel.setSwitch(this.theSwitch);
            this.multiRouterPanel.setSwitch(this.theSwitch);
            ((Component)this).setCursor(new Cursor(0));
        }
    }

    public void readyForChanges() {
        this.modifyButton.setEnabled(true);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            ((Component)this).setLocation(50, 50);
        }
        super.setVisible(bl);
    }
}

