<!-- Copyright (c) 2004 by Cisco Systems, Inc. -->
// discover.js for c2940 devices.

// c2940 models.
// WS-C2940-8TF-S, WS-C2940-8TT-S

function WS_C2940_8TF_S(int_status, media_type) {
	var dev = new top.device();

	dev.noofports = 10;
	dev.x=55;
	dev.y=0;
	dev.image = "images/c29408tf.gif";

	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/c2940_mode.gif");
	modeBtn.x = 25;
	modeBtn.y = 65;
	modeBtn.width = 17;
	modeBtn.height = 12;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;		

	// Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 37;
	tempLed.y = 31;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 37;
	tempLed.y = 39;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 37;
	tempLed.y = 47;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 37;
	tempLed.y = 55;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var xPortGap = 4;
	var xPortGroupGap = 30;
	var xPortStartPos = 76;
	var xPortCoord = xPortStartPos;
	var yPortCoord = 50;

	// Add the 8 FastEthernet ports.
	for(i=0; i<8; i++) {       
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
    }

	// Add the FX Port
	i = 8;
	xPortCoord = 305;
	port = new top.fxport(top.fxportImages());
	port.index = i;
	port.x = xPortCoord;
	port.y = yPortCoord;
	port.id = "port_" + i;
	xPortCoord += (portWidth + xPortGap);
	dev.addPort(port);

	// Add the SFP Port
	i = 9;
	xPortCoord = 342;
	port = new top.SFPport(int_status[i][6], portImages);
	port.index = i;
	port.x = xPortCoord;
	port.y = yPortCoord;
	port.id = "port_" + i;
	xPortCoord += (portWidth + xPortGap);
	dev.addPort(port);
	
	return dev;
}


function WS_C2940_8TT_S(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 9;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c29408tt.gif";	

	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/c2940_mode.gif");
	modeBtn.x = 25;
	modeBtn.y = 65;
        modeBtn.width = 17;
        modeBtn.height = 12;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;		

	// Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 37;
	tempLed.y = 31;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 37;
	tempLed.y = 39;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 37;
	tempLed.y = 47;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 37;
	tempLed.y = 55;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var xPortGap = 4;
	var xPortGroupGap = 30;
	var xPortStartPos = 76;
	var xPortCoord = xPortStartPos;
	var yPortCoord = 50;

	// Add the 8 FastEthernet ports.
	for(i=0; i<8; i++) {       
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
    }

	// Add the 10/100/100 Port.
	i = 8;
	xPortCoord = 342;
	port = new top.rj45port(portImages);
	port.index = i;
	port.x = xPortCoord;
	port.y = yPortCoord;
	port.id = "port_" + i;
	xPortCoord += (portWidth + xPortGap);
	dev.addPort(port);

	return dev;
}


function createDevice(int_status, media_type, deviceType) {
	
	var device = null;
	if(deviceType == null)
		return device;
	if(deviceType == "WS-C2940-8TF-S") {
		device = new WS_C2940_8TF_S(int_status, media_type);
	} else if(deviceType == "WS-C2940-8TT-S") {
		device = new WS_C2940_8TT_S(int_status, media_type);
	}

	if(device != null) {
		device.type = deviceType;
		device.family = "2940";
	}

	return device;
}
